DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -8.50886383385411E-12   0.00000000000000E+00  -3.15728012860965E-10   1.62007058817728E-22
      8.82476145374894E-09   8.50903344088814E-09  -7.92652838203068E-19  -2.49110336317875E-01  -2.49110336321286E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41073657029142E-09   0.00000000000000E+00   3.41073657029142E-09
      3.70243398395254E-18  -2.49110336317880E-01  -2.45355022493277E-01   0.00000000000000E+00   1.00220414226385E-11
     -9.83304508698233E-23  -1.19297920526017E-08  -1.19197700111792E-08  -2.90978114574948E-18
      1.17500000000000E-12
      0.00000000000000E+00  -8.51749723915162E-12   0.00000000000000E+00  -2.08520972375229E-11   1.58785907416490E-22
      8.53860979120237E-09   8.51775769396501E-09  -7.94640859345724E-19  -2.48252192543813E-01  -2.48252192547026E-01
      0.00000000000000E+00   0.00000000000000E+00   3.21239898788879E-09   0.00000000000000E+00   3.21239898788879E-09
      3.70460235326937E-18  -2.48252192543827E-01  -2.44556663160721E-01   0.00000000000000E+00   1.35338917821178E-11
     -9.83194162761774E-23  -1.17436905736345E-08  -1.17301566818525E-08  -2.90996149392364E-18
      2.08625000000000E-12
      0.00000000000000E+00  -8.52760016024444E-12   0.00000000000000E+00  -6.84222483529775E-13   1.53560790618167E-22
      8.52823904811609E-09   8.52755482563271E-09  -7.97023785080280E-19  -2.47244517435905E-01  -2.47244517438815E-01
      0.00000000000000E+00   0.00000000000000E+00   2.90984813472557E-09   0.00000000000000E+00   2.90984813472557E-09
      3.70725395238214E-18  -2.47244517435914E-01  -2.43641133222686E-01   0.00000000000000E+00   1.54907891221637E-11
     -9.83048023544514E-23  -1.14528937494784E-08  -1.14374029603563E-08  -2.91023016730186E-18
      3.31643750000000E-12
      0.00000000000000E+00  -8.53926444186980E-12   0.00000000000000E+00   3.44736246605891E-13   1.46828574696026E-22
      8.53891163905042E-09   8.53925637529717E-09  -7.99785651219567E-19  -2.46075878863369E-01  -2.46075878865889E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51986710760836E-09   0.00000000000000E+00   2.51986710760836E-09
      3.71035386139958E-18  -2.46075878863374E-01  -2.42591677183208E-01   0.00000000000000E+00   1.47291381792574E-11
     -9.82874633583343E-23  -1.10738526210860E-08  -1.10591234829069E-08  -2.91056821018001E-18
      4.97719062500000E-12
      0.00000000000000E+00  -8.55221454981606E-12   0.00000000000000E+00   3.38885653653473E-13   1.39286655804212E-22
      8.55193645527422E-09   8.55227534092801E-09  -8.02852569735717E-19  -2.44775766755823E-01  -2.44775766757900E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07744424576354E-09   0.00000000000000E+00   2.07744424576354E-09
      3.71380398342275E-18  -2.44775766755822E-01  -2.41426854953943E-01   0.00000000000000E+00   1.23675264313444E-11
     -9.82683441235810E-23  -1.06420871131221E-08  -1.06297195866909E-08  -2.91095141368703E-18
      7.21920734375000E-12
      0.00000000000000E+00  -8.56599126039719E-12   0.00000000000000E+00   3.02469337931148E-13   1.31596696493729E-22
      8.56571858728638E-09   8.56602105662444E-09  -8.06082300792552E-19  -2.43404171690076E-01  -2.43404171691697E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62093961321785E-09   0.00000000000000E+00   1.62093961321785E-09
      3.71743815713566E-18  -2.43404171690049E-01  -2.40194760916984E-01   0.00000000000000E+00   9.44504539442962E-12
     -9.82484254037463E-23  -1.01964057152366E-08  -1.01869606698422E-08  -2.91135585634311E-18
      1.02459299140625E-11
      0.00000000000000E+00  -8.57949243676670E-12   0.00000000000000E+00   2.79267694184985E-13   1.24357790593179E-22
      8.57934008129997E-09   8.57961934899428E-09  -8.09269512905678E-19  -2.42048458961100E-01  -2.42048458962286E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18680729878819E-09   0.00000000000000E+00   1.18680729878819E-09
      3.72103029357351E-18  -2.42048458961143E-01  -2.38971550820444E-01   0.00000000000000E+00   6.62890477977358E-12
     -9.82288968703878E-23  -9.77305555256249E-09  -9.76642664778281E-09  -2.91176078066784E-18
      1.43320053839844E-11
      0.00000000000000E+00  -8.59189147628971E-12   0.00000000000000E+00   2.65329470628369E-13   1.18089588252184E-22
      8.59177477241628E-09   8.59204010188703E-09  -8.12176075239594E-19  -2.40810670894333E-01  -2.40810670895140E-01
      0.00000000000000E+00   0.00000000000000E+00   8.06936964039154E-10   0.00000000000000E+00   8.06936964039154E-10
      3.72432749890805E-18  -2.40810670894261E-01  -2.37849541633310E-01   0.00000000000000E+00   4.25308224192628E-12
     -9.82110148468481E-23  -9.40323014816815E-09  -9.39897706592633E-09  -2.91215142366845E-18
      1.98482072683789E-11
      0.00000000000000E+00  -8.60217808685695E-12   0.00000000000000E+00   2.45069547984271E-13   1.13166796686794E-22
      8.60209181675851E-09   8.60233688630661E-09  -8.14587191411457E-19  -2.39783527978233E-01  -2.39783527978738E-01
      0.00000000000000E+00   0.00000000000000E+00   5.04434009124863E-10   0.00000000000000E+00   5.04434009124863E-10
      3.72711005873974E-18  -2.39783527978212E-01  -2.36914466577294E-01   0.00000000000000E+00   2.45981646810971E-12
     -9.81958110371513E-23  -9.10923071189915E-09  -9.10677089543114E-09  -2.91252286732828E-18
      2.72950798123115E-11
      0.00000000000000E+00  -8.60980120004518E-12   0.00000000000000E+00   2.02006282300917E-13   1.09742339272617E-22
      8.60974219611787E-09   8.60994420240028E-09  -8.16377478868184E-19  -2.39021762689168E-01  -2.39021762689456E-01
      0.00000000000000E+00   0.00000000000000E+00   2.88866339309418E-10   0.00000000000000E+00   2.88866339309418E-10
      3.72926120955081E-18  -2.39021762689241E-01  -2.36218216171919E-01   0.00000000000000E+00   1.26598735776946E-12
     -9.81837558929669E-23  -8.90007652906737E-09  -8.89881054170970E-09  -2.91288373068262E-18
      3.73483577466206E-11
      0.00000000000000E+00  -8.61476081585439E-12   0.00000000000000E+00   1.36351716938240E-13   1.07717385979432E-22
      8.61474884392143E-09   8.61488519563847E-09  -8.17553961131446E-19  -2.38523150871110E-01  -2.38523150871264E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54238492140337E-10   0.00000000000000E+00   1.54238492140337E-10
      3.73081181198046E-18  -2.38523150871504E-01  -2.35760448119790E-01   0.00000000000000E+00   5.85468162281221E-13
     -9.81745555786480E-23  -8.76970915594090E-09  -8.76912368777872E-09  -2.91325785084902E-18
      5.09202829579378E-11
      0.00000000000000E+00  -8.61769984744503E-12   0.00000000000000E+00   7.01042451301285E-14   1.06796767777834E-22
      8.61765974716310E-09   8.61772985140834E-09  -8.18244318773169E-19  -2.38233160519754E-01  -2.38233160519837E-01
      0.00000000000000E+00   0.00000000000000E+00   8.21830752910568E-11   0.00000000000000E+00   8.21830752910568E-11
      3.73192719453195E-18  -2.38233160520155E-01  -2.35492245273057E-01   0.00000000000000E+00   2.62279689701551E-13
     -9.81672255549867E-23  -8.70017520638893E-09  -8.69991292669933E-09  -2.91368287575878E-18
      6.92423819932160E-11
      0.00000000000000E+00  -8.61926120797756E-12   0.00000000000000E+00   2.62344070163786E-14   1.06617921788569E-22
      8.61926913718959E-09   8.61929537159671E-09  -8.18631827550782E-19  -2.38072713938262E-01  -2.38072713938312E-01
      0.00000000000000E+00   0.00000000000000E+00   4.97276531328874E-11   0.00000000000000E+00   4.97276531328874E-11
      3.73283830951744E-18  -2.38072713938404E-01  -2.35341518289025E-01   0.00000000000000E+00   1.34281232536804E-13
     -9.81604268614239E-23  -8.66915730596211E-09  -8.66902302472967E-09  -2.91420648196666E-18
      8.92423819932160E-11
      0.00000000000000E+00  -8.62017965534963E-12   0.00000000000000E+00   5.18413644197863E-15   1.06809527205778E-22
      8.62015509277565E-09   8.62016027691220E-09  -8.18846925830877E-19  -2.37984288749646E-01  -2.37984288749684E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82198615028213E-11   0.00000000000000E+00   3.82198615028213E-11
      3.73360270674750E-18  -2.37984288749501E-01  -2.35256440022168E-01   0.00000000000000E+00   9.60204903333933E-14
     -9.81542089845653E-23  -8.65847615890519E-09  -8.65838013841496E-09  -2.91475578091662E-18
      1.09242381993216E-10
      0.00000000000000E+00  -8.62073072377288E-12   0.00000000000000E+00   1.78522516044758E-15   1.07117311010177E-22
      8.62076107375743E-09   8.62076285898269E-09  -8.18992003532956E-19  -2.37923746281354E-01  -2.37923746281389E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41865938717969E-11   0.00000000000000E+00   3.41865938717969E-11
      3.73428643862493E-18  -2.37923746280782E-01  -2.35196977462724E-01   0.00000000000000E+00   7.98249227682745E-14
     -9.81484138728656E-23  -8.65502927777717E-09  -8.65494945285450E-09  -2.91529443509198E-18
      1.29242381993216E-10
      0.00000000000000E+00  -8.62128179219612E-12   0.00000000000000E+00   1.90452916822641E-15   1.07457457781395E-22
      8.62127228653934E-09   8.62127419106862E-09  -8.19110586082998E-19  -2.37872644271884E-01  -2.37872644271917E-01
      0.00000000000000E+00   0.00000000000000E+00   3.25138004740925E-11   0.00000000000000E+00   3.25138004740925E-11
      3.73493671463442E-18  -2.37872644271934E-01  -2.35146241436652E-01   0.00000000000000E+00   7.25634422821257E-14
     -9.81427949079559E-23  -8.65386055498493E-09  -8.65378799154274E-09  -2.91582612855142E-18
      1.49242381993216E-10
      0.00000000000000E+00  -8.62174101588216E-12   0.00000000000000E+00   1.37655393161490E-15   1.07804030732344E-22
      8.62174711590248E-09   8.62174849245652E-09  -8.19216653883379E-19  -2.37825169791074E-01  -2.37825169791106E-01
      0.00000000000000E+00   0.00000000000000E+00   3.16013673605952E-11   0.00000000000000E+00   3.16013673605952E-11
      3.73556874198163E-18  -2.37825169789744E-01  -2.35098904812042E-01   0.00000000000000E+00   6.99271405622373E-14
     -9.81372716630030E-23  -8.65341978695760E-09  -8.65334985981713E-09  -2.91635208809825E-18
      1.69242381993216E-10
      0.00000000000000E+00  -8.62220023956820E-12   0.00000000000000E+00   1.18200414157669E-15   1.08149107716910E-22
      8.62220418030731E-09   8.62220536231156E-09  -8.19314899161115E-19  -2.37779467683263E-01  -2.37779467683294E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09463241051453E-11   0.00000000000000E+00   3.09463241051453E-11
      3.73618766846373E-18  -2.37779467679831E-01  -2.35053265054503E-01   0.00000000000000E+00   6.82756289068387E-14
     -9.81318176679108E-23  -8.65321996204554E-09  -8.65315168641673E-09  -2.91687276930262E-18
      1.89242381993216E-10
      0.00000000000000E+00  -8.62265946325423E-12   0.00000000000000E+00   1.25931665462285E-15   1.08490377507627E-22
      8.62264964624083E-09   8.62265090555759E-09  -8.19407078455510E-19  -2.37734924082363E-01  -2.37734924082393E-01
      0.00000000000000E+00   0.00000000000000E+00   3.03895459174062E-11   0.00000000000000E+00   3.03895459174062E-11
      3.73679545938208E-18  -2.37734924076414E-01  -2.35008756495629E-01   0.00000000000000E+00   6.68286338425363E-14
     -9.81264223627483E-23  -8.65310728010869E-09  -8.65304045147494E-09  -2.91738838092657E-18
      2.09242381993216E-10
      0.00000000000000E+00  -8.62311868694027E-12   0.00000000000000E+00   1.06776228504268E-15   1.08827255304801E-22
      8.62308575782851E-09   8.62308682559091E-09  -8.19494006896962E-19  -2.37691315807261E-01  -2.37691315807291E-01
      0.00000000000000E+00   0.00000000000000E+00   2.98798738396667E-11   0.00000000000000E+00   2.98798738396667E-11
      3.73739305685887E-18  -2.37691315800268E-01  -2.34965171369247E-01   0.00000000000000E+00   6.58589583795254E-14
     -9.81210812768916E-23  -8.65303255838890E-09  -8.65296669943062E-09  -2.91789904996191E-18
      2.29242381993216E-10
      0.00000000000000E+00  -8.62357791062631E-12   0.00000000000000E+00   9.46072013527297E-16   1.09159703143573E-22
      8.62351348304067E-09   8.62351442911280E-09  -8.19576180976243E-19  -2.37648545652705E-01  -2.37648545652734E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93999158937352E-11   0.00000000000000E+00   2.93999158937352E-11
      3.73798105517675E-18  -2.37648545645498E-01  -2.34922417644614E-01   0.00000000000000E+00   6.49331491501298E-14
     -9.81157920253576E-23  -8.65297927815556E-09  -8.65291434500651E-09  -2.91840487420051E-18
      2.49242381993216E-10
      0.00000000000000E+00  -8.62394528957514E-12   0.00000000000000E+00   1.02337651250851E-15   1.09487826763763E-22
      8.62393338796153E-09   8.62393441133815E-09  -8.19653980150376E-19  -2.37606557393749E-01  -2.37606557393778E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89431718069244E-11   0.00000000000000E+00   2.89431718069244E-11
      3.73855991861289E-18  -2.37606557389651E-01  -2.34880440969118E-01   0.00000000000000E+00   6.38895914901467E-14
     -9.81105525412063E-23  -8.65294147273652E-09  -8.65287758314513E-09  -2.91890593846251E-18
      2.69242381993216E-10
      0.00000000000000E+00  -8.62440451326118E-12   0.00000000000000E+00   9.22977513862718E-16   1.09811777032916E-22
      8.62434588565755E-09   8.62434680863517E-09  -8.19727730270629E-19  -2.37565309628487E-01  -2.37565309628515E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85066108854062E-11   0.00000000000000E+00   2.85066108854062E-11
      3.73913005083059E-18  -2.37565309630799E-01  -2.34839200765526E-01   0.00000000000000E+00   6.30882022577583E-14
     -9.81053613508063E-23  -8.65291650772266E-09  -8.65285341952050E-09  -2.91940232055996E-18
      2.89242381993216E-10
      0.00000000000000E+00  -8.62477189221001E-12   0.00000000000000E+00   9.85221342620426E-16   1.10131705839091E-22
      8.62475132798159E-09   8.62475231320304E-09  -8.19797724721206E-19  -2.37524767328408E-01  -2.37524767328436E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80883605212539E-11   0.00000000000000E+00   2.80883605212539E-11
      3.73969181804102E-18  -2.37524767342281E-01  -2.34798662486399E-01   0.00000000000000E+00   6.21802257420718E-14
     -9.81002169430728E-23  -8.65290285395007E-09  -8.65284067372443E-09  -2.91989409331981E-18
      3.09242381993216E-10
      0.00000000000000E+00  -8.62513927115884E-12   0.00000000000000E+00   9.07675349978691E-16   1.10447761116095E-22
      8.62515002869434E-09   8.62515093636980E-09  -8.19864232887583E-19  -2.37484898928406E-01  -2.37484898928434E-01
      0.00000000000000E+00   0.00000000000000E+00   2.76870228437400E-11   0.00000000000000E+00   2.76870228437400E-11
      3.74024555849789E-18  -2.37484898958995E-01  -2.34758794908116E-01   0.00000000000000E+00   6.14606664077592E-14
     -9.80951180925211E-23  -8.65289941987982E-09  -8.65283795921351E-09  -2.92038132561031E-18
      3.29242381993216E-10
      0.00000000000000E+00  -8.62559849484488E-12   0.00000000000000E+00   9.50265412332871E-16   1.10760080124140E-22
      8.62554228164495E-09   8.62554323191048E-09  -8.19927503284188E-19  -2.37445675395298E-01  -2.37445675395325E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73013829909902E-11   0.00000000000000E+00   2.73013829909902E-11
      3.74079158615771E-18  -2.37445675445024E-01  -2.34719569284998E-01   0.00000000000000E+00   6.06647368183848E-14
     -9.80900635584876E-23  -8.65290527963820E-09  -8.65284461490148E-09  -2.92086408287352E-18
      3.49242381993216E-10
      0.00000000000000E+00  -8.62596587379370E-12   0.00000000000000E+00   8.90307799520048E-16   1.11068792558342E-22
      8.62592835460164E-09   8.62592924490955E-09  -8.19987766062855E-19  -2.37407069722773E-01  -2.37407069722800E-01
      0.00000000000000E+00   0.00000000000000E+00   2.69303746994794E-11   0.00000000000000E+00   2.69303746994794E-11
      3.74133019365170E-18  -2.37407069790015E-01  -2.34680958858201E-01   0.00000000000000E+00   6.00099159420138E-14
     -9.80850522782664E-23  -8.65291962952480E-09  -8.65285961960896E-09  -2.92134242758885E-18
      3.69242381993216E-10
      0.00000000000000E+00  -8.62633325274254E-12   0.00000000000000E+00   9.18031749445677E-16   1.11374018095601E-22
      8.62630850372721E-09   8.62630942175908E-09  -8.20045234182222E-19  -2.37369056774460E-01  -2.37369056774487E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65730047747020E-11   0.00000000000000E+00   2.65730047747020E-11
      3.74186165374720E-18  -2.37369056848490E-01  -2.34642938714504E-01   0.00000000000000E+00   5.93023671178551E-14
     -9.80800832045549E-23  -8.65294172890085E-09  -8.65288242653384E-09  -2.92181641956497E-18
      3.89242381993216E-10
      0.00000000000000E+00  -8.62670063169137E-12   0.00000000000000E+00   8.71296698212721E-16   1.11675869527817E-22
      8.62668296189808E-09   8.62668383319489E-09  -8.20100105054838E-19  -2.37331613050639E-01  -2.37331613050666E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62283787885119E-11   0.00000000000000E+00   2.62283787885119E-11
      3.74238622132296E-18  -2.37331613109416E-01  -2.34605485551252E-01   0.00000000000000E+00   5.87002244918277E-14
     -9.80751554103886E-23  -8.65297091220774E-09  -8.65291221198334E-09  -2.92228611626813E-18
      4.09242381993216E-10
      0.00000000000000E+00  -8.62706801064019E-12   0.00000000000000E+00   8.88248364056190E-16   1.11974451135055E-22
      8.62705195217482E-09   8.62705284042329E-09  -8.20152561418672E-19  -2.37294716619082E-01  -2.37294716619108E-01
      0.00000000000000E+00   0.00000000000000E+00   2.58956564558892E-11   0.00000000000000E+00   2.58956564558892E-11
      3.74290413445208E-18  -2.37294716626463E-01  -2.34568577616620E-01   0.00000000000000E+00   5.80625499177362E-14
     -9.80702679991238E-23  -8.65300655942906E-09  -8.65294849687924E-09  -2.92275157303342E-18
      4.29242381993216E-10
      0.00000000000000E+00  -8.62743538958903E-12   0.00000000000000E+00   8.51431978283454E-16   1.12269861266062E-22
      8.62741567789639E-09   8.62741652932848E-09  -8.20202772671103E-19  -2.37258346941254E-01  -2.37258346941279E-01
      0.00000000000000E+00   0.00000000000000E+00   2.55740769486968E-11   0.00000000000000E+00   2.55740769486968E-11
      3.74341561599106E-18  -2.37258346849036E-01  -2.34532194535613E-01   0.00000000000000E+00   5.75036590667370E-14
     -9.80654201598803E-23  -8.65304810993614E-09  -8.65299060627717E-09  -2.92321284331996E-18
      4.49242381993216E-10
      0.00000000000000E+00  -8.62780276853786E-12   0.00000000000000E+00   8.60660426456059E-16   1.12562191077522E-22
      8.62777433189290E-09   8.62777519255344E-09  -8.20250895639314E-19  -2.37222484812062E-01  -2.37222484812087E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52629263507759E-11   0.00000000000000E+00   2.52629263507759E-11
      3.74392087451807E-18  -2.37222484568169E-01  -2.34496317263476E-01   0.00000000000000E+00   5.69215531301827E-14
     -9.80606111174457E-23  -8.65309504045723E-09  -8.65303811890420E-09  -2.92366997887876E-18
      4.69242381993216E-10
      0.00000000000000E+00  -8.62817014748668E-12   0.00000000000000E+00   8.31283393662916E-16   1.12851526612465E-22
      8.62812808839538E-09   8.62812891967888E-09  -8.20297075704313E-19  -2.37187112214707E-01  -2.37187112214732E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49615572053122E-11   0.00000000000000E+00   2.49615572053122E-11
      3.74442010566218E-18  -2.37187111778558E-01  -2.34460927943968E-01   0.00000000000000E+00   5.63983890593716E-14
     -9.80558401613684E-23  -8.65314687527318E-09  -8.65309047688422E-09  -2.92412302995787E-18
      4.89242381993216E-10
      0.00000000000000E+00  -8.62844568169831E-12   0.00000000000000E+00   8.35003119531935E-16   1.13137947814778E-22
      8.62847711069546E-09   8.62847794569869E-09  -8.20341447482510E-19  -2.37152212267179E-01  -2.37152212267204E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46693628979390E-11   0.00000000000000E+00   2.46693628979390E-11
      3.74491349292014E-18  -2.37152211636480E-01  -2.34426009873069E-01   0.00000000000000E+00   5.58607420076916E-14
     -9.80511066176697E-23  -8.65320316933854E-09  -8.65314730859663E-09  -2.92457204543763E-18
      5.09242381993216E-10
      0.00000000000000E+00  -8.62881306064714E-12   0.00000000000000E+00   8.11196661090896E-16   1.13421530213946E-22
      8.62882154467735E-09   8.62882235587412E-09  -8.20384135775041E-19  -2.37117769100727E-01  -2.37117769100752E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43857924630997E-11   0.00000000000000E+00   2.43857924630997E-11
      3.74540120876940E-18  -2.37117768345048E-01  -2.34391547381493E-01   0.00000000000000E+00   5.53672303740581E-14
     -9.80464098642707E-23  -8.65326351556758E-09  -8.65320814833730E-09  -2.92501707299436E-18
      5.29242381993216E-10
      0.00000000000000E+00  -8.62918043959597E-12   0.00000000000000E+00   8.11015274746364E-16   1.13702344205398E-22
      8.62916152969816E-09   8.62916234071354E-09  -8.20425256138415E-19  -2.37083767825946E-01  -2.37083767825970E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41103277563909E-11   0.00000000000000E+00   2.41103277563909E-11
      3.74588341532453E-18  -2.37083767122703E-01  -2.34357525807048E-01   0.00000000000000E+00   5.48653535069029E-14
     -9.80417493131333E-23  -8.65332753382325E-09  -8.65327266846984E-09  -2.92545815918611E-18
      5.49242381993216E-10
      0.00000000000000E+00  -8.62954781854480E-12   0.00000000000000E+00   7.91394853949005E-16   1.13980456414234E-22
      8.62949719106374E-09   8.62949798245871E-09  -8.20464915691730E-19  -2.37050194429331E-01  -2.37050194429355E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38424963630289E-11   0.00000000000000E+00   2.38424963630289E-11
      3.74636026525179E-18  -2.37050194091962E-01  -2.34323931381588E-01   0.00000000000000E+00   5.43965766848714E-14
     -9.80371244175367E-23  -8.65339487539837E-09  -8.65334047882179E-09  -2.92589534956006E-18
      5.69242381993216E-10
      0.00000000000000E+00  -8.62982335275642E-12   0.00000000000000E+00   7.88503532207753E-16   1.14255929208539E-22
      8.62982865580809E-09   8.62982944431174E-09  -8.20503213574050E-19  -2.37017035763424E-01  -2.37017035763447E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35818489779187E-11   0.00000000000000E+00   2.35818489779187E-11
      3.74683190223135E-18  -2.37017036240818E-01  -2.34290751194659E-01   0.00000000000000E+00   5.39237419569635E-14
     -9.80325346568049E-23  -8.65346521703138E-09  -8.65341129328952E-09  -2.92632868865730E-18
      5.89242381993216E-10
      0.00000000000000E+00  -8.63019073170525E-12   0.00000000000000E+00   7.72106334682253E-16   1.14528821921820E-22
      8.63015605304667E-09   8.63015682515312E-09  -8.20540241568586E-19  -2.36984279487272E-01  -2.36984279487295E-01
      0.00000000000000E+00   0.00000000000000E+00   2.33279676082139E-11   0.00000000000000E+00   2.33279676082139E-11
      3.74729846158351E-18  -2.36984281311953E-01  -2.34257973079928E-01   0.00000000000000E+00   5.34759143579264E-14
     -9.80279795363601E-23  -8.65353826867569E-09  -8.65348479276143E-09  -2.92675822001493E-18
      6.09242381993216E-10
      0.00000000000000E+00  -8.63046626591687E-12   0.00000000000000E+00   7.67499086782794E-16   1.14799190544367E-22
      8.63047952977477E-09   8.63048029727397E-09  -8.20576084464120E-19  -2.36951914076071E-01  -2.36951914076094E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30804472704087E-11   0.00000000000000E+00   2.30804472704087E-11
      3.74776007052892E-18  -2.36951917735564E-01  -2.34225585548871E-01   0.00000000000000E+00   5.30272328000992E-14
     -9.80234585703029E-23  -8.65361377177706E-09  -8.65356074454436E-09  -2.92718398606480E-18
      6.29242381993216E-10
      0.00000000000000E+00  -8.63083364486570E-12   0.00000000000000E+00   7.53774226948117E-16   1.15067088766597E-22
      8.63079925218035E-09   8.63080000595469E-09  -8.20610820560777E-19  -2.36919928783104E-01  -2.36919928783126E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28389032770712E-11   0.00000000000000E+00   2.28389032770712E-11
      3.74821684859446E-18  -2.36919934494224E-01  -2.34193577652868E-01   0.00000000000000E+00   5.25979185250567E-14
     -9.80189712756661E-23  -8.65369150715025E-09  -8.65363890923182E-09  -2.92760602803368E-18
      6.49242381993216E-10
      0.00000000000000E+00  -8.63110917907733E-12   0.00000000000000E+00   7.48349963232722E-16   1.15332567735095E-22
      8.63111541716428E-09   8.63111616551436E-09  -8.20644521988044E-19  -2.36888313647528E-01  -2.36888313647551E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26029595503513E-11   0.00000000000000E+00   2.26029595503513E-11
      3.74866890778547E-18  -2.36888321037904E-01  -2.34161938898329E-01   0.00000000000000E+00   5.21704120087245E-14
     -9.80145171546224E-23  -8.65377129547659E-09  -8.65371912506468E-09  -2.92802438579742E-18
      6.69242381993216E-10
      0.00000000000000E+00  -8.63147655802616E-12   0.00000000000000E+00   7.37029092446668E-16   1.15595676747293E-22
      8.63142823963601E-09   8.63142897666522E-09  -8.20677255224614E-19  -2.36857059421889E-01  -2.36857059421911E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23722639708672E-11   0.00000000000000E+00   2.23722639708672E-11
      3.74911635306489E-18  -2.36857067154669E-01  -2.34130659116514E-01   0.00000000000000E+00   5.17585954989797E-14
     -9.80100956926921E-23  -8.65385299923155E-09  -8.65380124063615E-09  -2.92843909784027E-18
      6.89242381993216E-10
      0.00000000000000E+00  -8.63175209223778E-12   0.00000000000000E+00   7.31463483449730E-16   1.15856462717416E-22
      8.63173793917132E-09   8.63173867063492E-09  -8.20709081562029E-19  -2.36826157493141E-01  -2.36826157493163E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21464918576328E-11   0.00000000000000E+00   2.21464918576328E-11
      3.74955928290204E-18  -2.36826162930890E-01  -2.34099728426917E-01   0.00000000000000E+00   5.13507940430902E-14
     -9.80057063549802E-23  -8.65393651328650E-09  -8.65388516249255E-09  -2.92885020134001E-18
      7.09242381993216E-10
      0.00000000000000E+00  -8.63202762644940E-12   0.00000000000000E+00   7.22128785820863E-16   1.16114970169359E-22
      8.63204469131850E-09   8.63204541344740E-09  -8.20740057869439E-19  -2.36795599672107E-01  -2.36795599672129E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19253775988309E-11   0.00000000000000E+00   2.19253775988309E-11
      3.74999779045401E-18  -2.36795598739281E-01  -2.34069137230644E-01   0.00000000000000E+00   5.09559414068299E-14
     -9.80013486109183E-23  -8.65402174698746E-09  -8.65397079104615E-09  -2.92925773258458E-18
      7.29242381993216E-10
      0.00000000000000E+00  -8.63239500539823E-12   0.00000000000000E+00   7.16325399407127E-16   1.16371239981777E-22
      8.63234856797191E-09   8.63234928429743E-09  -8.20770237440040E-19  -2.36765377918340E-01  -2.36765377918362E-01
      0.00000000000000E+00   0.00000000000000E+00   2.17087373957719E-11   0.00000000000000E+00   2.17087373957719E-11
      3.75043196520193E-18  -2.36765365389767E-01  -2.34038876372968E-01   0.00000000000000E+00   5.05658467549473E-14
     -9.79970219705482E-23  -8.65410858753980E-09  -8.65405802169314E-09  -2.92966172776189E-18
      7.49242381993216E-10
      0.00000000000000E+00  -8.63267053960985E-12   0.00000000000000E+00   7.07594481651056E-16   1.16625308514316E-22
      8.63264944943534E-09   8.63265015702994E-09  -8.20799671129676E-19  -2.36735483931474E-01  -2.36735483931495E-01
      0.00000000000000E+00   0.00000000000000E+00   2.14965099079012E-11   0.00000000000000E+00   2.14965099079012E-11
      3.75086189540009E-18  -2.36735454410068E-01  -2.34008937438776E-01   0.00000000000000E+00   5.01848442627538E-14
     -9.79927260605216E-23  -8.65419685178207E-09  -8.65414666693791E-09  -2.93006222427041E-18
      7.69242381993216E-10
      0.00000000000000E+00  -8.63294607382148E-12   0.00000000000000E+00   6.99927572753753E-16   1.16877205816693E-22
      8.63294694134366E-09   8.63294764127135E-09  -8.20828408497659E-19  -2.36705908717613E-01  -2.36705908717634E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12887756503980E-11   0.00000000000000E+00   2.12887756503980E-11
      3.75128767091310E-18  -2.36705858531255E-01  -2.33979313258246E-01   0.00000000000000E+00   4.98058439992804E-14
     -9.79884607118111E-23  -8.65428622276562E-09  -8.65423641692172E-09  -2.93045926241544E-18
      7.89242381993216E-10
      0.00000000000000E+00  -8.63322160803310E-12   0.00000000000000E+00   6.88921267733438E-16   1.17126954708816E-22
      8.63324030796598E-09   8.63324099688736E-09  -8.20856498902013E-19  -2.36676642173780E-01  -2.36676642173802E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10857649578169E-11   0.00000000000000E+00   2.10857649578169E-11
      3.75170938621225E-18  -2.36676572280968E-01  -2.33949998518496E-01   0.00000000000000E+00   4.94285790186205E-14
     -9.79842260698155E-23  -8.65437619042410E-09  -8.65432676184518E-09  -2.93085288731024E-18
      8.09242381993216E-10
      0.00000000000000E+00  -8.63349714224472E-12   0.00000000000000E+00   6.76395463444895E-16   1.17374570314861E-22
      8.63352849354397E-09   8.63352916993955E-09  -8.20883991936977E-19  -2.36647672954463E-01  -2.36647672954484E-01
      0.00000000000000E+00   0.00000000000000E+00   2.08878025901876E-11   0.00000000000000E+00   2.08878025901876E-11
      3.75212714226406E-18  -2.36647592631977E-01  -2.33920990422859E-01   0.00000000000000E+00   4.90459224614617E-14
     -9.79800226693488E-23  -8.65446601845221E-09  -8.65441697252985E-09  -2.93124315032708E-18
      8.29242381993216E-10
      0.00000000000000E+00  -8.63386452119355E-12   0.00000000000000E+00   6.60112684893714E-16   1.17620062024091E-22
      8.63381026072963E-09   8.63381092084243E-09  -8.20910936889927E-19  -2.36618988789098E-01  -2.36618988789118E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06951956861661E-11   0.00000000000000E+00   2.06951956861661E-11
      3.75254104617778E-18  -2.36618919392432E-01  -2.33892289072685E-01   0.00000000000000E+00   4.86547966616785E-14
     -9.79758514499949E-23  -8.65455477132516E-09  -8.65450611652860E-09  -2.93163010928785E-18
      8.49242381993216E-10
      0.00000000000000E+00  -8.63404821066797E-12   0.00000000000000E+00   6.41506180477035E-16   1.17863438195756E-22
      8.63408453817097E-09   8.63408517967727E-09  -8.20937380377995E-19  -2.36590577628611E-01  -2.36590577628632E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05080153903078E-11   0.00000000000000E+00   2.05080153903078E-11
      3.75295120648559E-18  -2.36590555058098E-01  -2.33863897278744E-01   0.00000000000000E+00   4.82509735983149E-14
     -9.79717136179858E-23  -8.65464144604104E-09  -8.65459319506754E-09  -2.93201382610759E-18
      8.69242381993217E-10
      0.00000000000000E+00  -8.63432374487959E-12   0.00000000000000E+00   6.21912985919956E-16   1.18104715170310E-22
      8.63435098987165E-09   8.63435161178475E-09  -8.20963361827783E-19  -2.36562429798992E-01  -2.36562429799012E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03258009313579E-11   0.00000000000000E+00   2.03258009313579E-11
      3.75335772250421E-18  -2.36562503606254E-01  -2.33835819268760E-01   0.00000000000000E+00   4.78353523682568E-14
     -9.79676103103566E-23  -8.65472524806838E-09  -8.65467741271611E-09  -2.93239436067643E-18
      8.79242381993216E-10
      0.00000000000000E+00  -8.63441558961680E-12   0.00000000000000E+00   6.05732127913184E-16   1.18225044850804E-22
      8.63448218901674E-09   8.63448279474899E-09  -8.20976241841358E-19  -2.36548420545262E-01  -2.36548420545283E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02357595945440E-11   0.00000000000000E+00   2.02357595945440E-11
      3.75356008010016E-18  -2.36548555835904E-01  -2.33821858522210E-01   0.00000000000000E+00   4.76315367847227E-14
     -9.79669651257574E-23  -8.65476618588014E-09  -8.65471855434346E-09  -2.93258383825880E-18
      8.80929881993216E-10
      0.00000000000000E+00  -8.63450743435401E-12   0.00000000000000E+00   6.14000934786241E-16   1.18245215619757E-22
      8.63450440544315E-09   8.63450501944420E-09  -8.20978411990955E-19  -2.36546058417628E-01  -2.36546058417649E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02206179019447E-11   0.00000000000000E+00   2.02206179019447E-11
      3.75359420239287E-18  -2.36546204698007E-01  -2.33819505152595E-01   0.00000000000000E+00   4.75814315558225E-14
     -9.79653690953426E-23  -8.65477321877748E-09  -8.65472563734602E-09  -2.93261579040191E-18
      8.83208006993216E-10
      0.00000000000000E+00  -8.63450743435401E-12   0.00000000000000E+00   6.08231846814784E-16   1.18272488850999E-22
      8.63453413304541E-09   8.63453474127738E-09  -8.20981336060140E-19  -2.36542872859968E-01  -2.36542872859989E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02002249492695E-11   0.00000000000000E+00   2.02002249492695E-11
      3.75364022103033E-18  -2.36543034633476E-01  -2.33816332146115E-01   0.00000000000000E+00   4.75374373202890E-14
     -9.79647670283770E-23  -8.65478250366385E-09  -8.65473496622663E-09  -2.93265888497019E-18
      8.86283475743216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.05268678304578E-16   1.18309303869188E-22
      8.63457408340431E-09   8.63457468867310E-09  -8.20985273371697E-19  -2.36538578404428E-01  -2.36538578404448E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01728067157527E-11   0.00000000000000E+00   2.01728067157527E-11
      3.75370226186698E-18  -2.36538762485834E-01  -2.33812056047288E-01   0.00000000000000E+00   4.74724380431222E-14
     -9.79641319388840E-23  -8.65479496782667E-09  -8.65474749538872E-09  -2.93271698849529E-18
      8.90435358555716E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.01606656629375E-16   1.18358942305366E-22
      8.63462771299191E-09   8.63462831459869E-09  -8.20990570352824E-19  -2.36532791899021E-01  -2.36532791899042E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01359539596507E-11   0.00000000000000E+00   2.01359539596507E-11
      3.75378586398814E-18  -2.36533008737075E-01  -2.33806297008924E-01   0.00000000000000E+00   4.73842902582232E-14
     -9.79632876432776E-23  -8.65481165284852E-09  -8.65476426855836E-09  -2.93279529363532E-18
      8.96040400352591E-10
      0.00000000000000E+00  -8.63469112382842E-12   0.00000000000000E+00   5.96897223000793E-16   1.18425803043544E-22
      8.63469958626267E-09   8.63470018316001E-09  -8.20997688167887E-19  -2.36525000152678E-01  -2.36525000152698E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00864556319298E-11   0.00000000000000E+00   2.00864556319298E-11
      3.75389844941151E-18  -2.36525266161203E-01  -2.33798547378281E-01   0.00000000000000E+00   4.72650580862402E-14
     -9.79621509120376E-23  -8.65483390385016E-09  -8.65478663879217E-09  -2.93290076124363E-18
      9.03607206778373E-10
      0.00000000000000E+00  -8.63478296856563E-12   0.00000000000000E+00   5.91326021349675E-16   1.18515775102394E-22
      8.63479577433505E-09   8.63479636566119E-09  -8.21007237599806E-19  -2.36514517854439E-01  -2.36514517854459E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00199981325841E-11   0.00000000000000E+00   2.00199981325841E-11
      3.75404993686202E-18  -2.36514859368707E-01  -2.33788131211469E-01   0.00000000000000E+00   4.71041215304424E-14
     -9.79606213936812E-23  -8.65486346791524E-09  -8.65481636379381E-09  -2.93304269926222E-18
      9.13822395453177E-10
      0.00000000000000E+00  -8.63496665804004E-12   0.00000000000000E+00   5.86137150217509E-16   1.18636709517667E-22
      8.63492457522205E-09   8.63492516135932E-09  -8.21020020972135E-19  -2.36500434129460E-01  -2.36500434129480E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99306066135703E-11   0.00000000000000E+00   1.99306066135703E-11
      3.75425353176899E-18  -2.36500893401177E-01  -2.33774152816950E-01   0.00000000000000E+00   4.68892695004448E-14
     -9.79585657161466E-23  -8.65490265724237E-09  -8.65485576797297E-09  -2.93323351079685E-18
      9.27612900164164E-10
      0.00000000000000E+00  -8.63505850277725E-12   0.00000000000000E+00   5.86225875536310E-16   1.18799039834114E-22
      8.63509850544154E-09   8.63509909166754E-09  -8.21037074694290E-19  -2.36481548858228E-01  -2.36481548858248E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98092856627614E-11   0.00000000000000E+00   1.98092856627614E-11
      3.75452671181624E-18  -2.36482188561143E-01  -2.33755431385304E-01   0.00000000000000E+00   4.66125845554629E-14
     -9.79558064421526E-23  -8.65495498991470E-09  -8.65490837733024E-09  -2.93348963712195E-18
      9.46230081523995E-10
      0.00000000000000E+00  -8.63533403698887E-12   0.00000000000000E+00   6.07004674373501E-16   1.19016663964162E-22
      8.63534142369473E-09   8.63534203069953E-09  -8.21059679181941E-19  -2.36456312737125E-01  -2.36456312737145E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96399811175612E-11   0.00000000000000E+00   1.96399811175612E-11
      3.75489235290661E-18  -2.36457189914546E-01  -2.33730409517134E-01   0.00000000000000E+00   4.62976911293210E-14
     -9.79521070206824E-23  -8.65502830950816E-09  -8.65498201181713E-09  -2.93383267372467E-18
      9.51230081523995E-10
      0.00000000000000E+00  -8.63533403698887E-12   0.00000000000000E+00   6.15375458485630E-16   1.19074976256768E-22
      8.63540743184193E-09   8.63540804721750E-09  -8.21065718776243E-19  -2.36449554382066E-01  -2.36449554382086E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95939737590138E-11   0.00000000000000E+00   1.95939737590138E-11
      3.75499032277541E-18  -2.36450493874528E-01  -2.33723707167363E-01   0.00000000000000E+00   4.62148471813577E-14
     -9.79511130272917E-23  -8.65504823582366E-09  -8.65500202097657E-09  -2.93392460399916E-18
      9.57980081523995E-10
      0.00000000000000E+00  -8.63551772646329E-12   0.00000000000000E+00   6.28947151287089E-16   1.19153546772602E-22
      8.63549839052578E-09   8.63549901947305E-09  -8.21073812105656E-19  -2.36440467411901E-01  -2.36440467411921E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95307994085433E-11   0.00000000000000E+00   1.95307994085433E-11
      3.75512215567141E-18  -2.36441485281152E-01  -2.33714689808047E-01   0.00000000000000E+00   4.61173469479138E-14
     -9.79497761667293E-23  -8.65507593622845E-09  -8.65502981888160E-09  -2.93404834356575E-18
      9.67092581523995E-10
      0.00000000000000E+00  -8.63560957120050E-12   0.00000000000000E+00   6.55068359548264E-16   1.19259310014418E-22
      8.63562598239606E-09   8.63562663746454E-09  -8.21084618371354E-19  -2.36428272294207E-01  -2.36428272294226E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94427744089318E-11   0.00000000000000E+00   1.94427744089318E-11
      3.75529932795321E-18  -2.36429375717550E-01  -2.33702567759630E-01   0.00000000000000E+00   4.60115135554965E-14
     -9.79479749915094E-23  -8.65511542338678E-09  -8.65506941187332E-09  -2.93421470958186E-18
      9.79394456523995E-10
      0.00000000000000E+00  -8.63579326067491E-12   0.00000000000000E+00   7.06682280982452E-16   1.19401581425678E-22
      8.63581101681885E-09   8.63581172350125E-09  -8.21098956633164E-19  -2.36411956680726E-01  -2.36411956680745E-01
      0.00000000000000E+00   0.00000000000000E+00   1.93171879321443E-11   0.00000000000000E+00   1.93171879321443E-11
      3.75553696558451E-18  -2.36413106813909E-01  -2.33686280095824E-01   0.00000000000000E+00   4.59295386397880E-14
     -9.79455469682212E-23  -8.65517484097191E-09  -8.65512891143336E-09  -2.93443800895134E-18
      9.96001987773995E-10
      0.00000000000000E+00  -8.63606879488653E-12   0.00000000000000E+00   8.09338003375191E-16   1.19592919488350E-22
      8.63609510235115E-09   8.63609591168927E-09  -8.21117761082814E-19  -2.36390247657217E-01  -2.36390247657236E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91313869883501E-11   0.00000000000000E+00   1.91313869883501E-11
      3.75585469069177E-18  -2.36391231140899E-01  -2.33664373405999E-01   0.00000000000000E+00   4.59669557439218E-14
     -9.79422647456757E-23  -8.65527326563321E-09  -8.65522729867756E-09  -2.93473692960896E-18
      1.01600198777400E-09
      0.00000000000000E+00  -8.63652801857257E-12   0.00000000000000E+00   9.72974893054152E-16   1.19822638840232E-22
      8.63650305794487E-09   8.63650403091988E-09  -8.21139441042623E-19  -2.36364646329740E-01  -2.36364646329759E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88810950095829E-11   0.00000000000000E+00   1.88810950095829E-11
      3.75623231259196E-18  -2.36364880659708E-01  -2.33637973177297E-01   0.00000000000000E+00   4.62683066274633E-14
     -9.79382830965944E-23  -8.65543139423599E-09  -8.65538512592946E-09  -2.93509287154934E-18
      1.03600198777400E-09
      0.00000000000000E+00  -8.63689539752140E-12   0.00000000000000E+00   1.14152125342151E-15   1.20051895917918E-22
      8.63698106340028E-09   8.63698220492165E-09  -8.21160067114926E-19  -2.36339635069107E-01  -2.36339635069125E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86097053814022E-11   0.00000000000000E+00   1.86097053814022E-11
      3.75660450669959E-18  -2.36338374756764E-01  -2.33611402100905E-01   0.00000000000000E+00   4.68151514427011E-14
     -9.79342540827840E-23  -8.65563872545438E-09  -8.65559191030304E-09  -2.93544443958466E-18
      1.05600198777400E-09
      0.00000000000000E+00  -8.63744646594465E-12   0.00000000000000E+00   1.27401408945569E-15   1.20280452060399E-22
      8.63750985386406E-09   8.63751112787827E-09  -8.21179733276270E-19  -2.36315177912768E-01  -2.36315177912786E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83367158330561E-11   0.00000000000000E+00   1.83367158330561E-11
      3.75697124101625E-18  -2.36311594841532E-01  -2.33584541531065E-01   0.00000000000000E+00   4.74625378875550E-14
     -9.79301613012846E-23  -8.65589530624919E-09  -8.65584784371140E-09  -2.93579150773998E-18
      1.06100198777400E-09
      0.00000000000000E+00  -8.63763015541906E-12   0.00000000000000E+00   1.30004176066715E-15   1.20337623908899E-22
      8.63764477105456E-09   8.63764607109644E-09  -8.21184592334234E-19  -2.36309097221273E-01  -2.36309097221291E-01
      0.00000000000000E+00   0.00000000000000E+00   1.82687227364341E-11   0.00000000000000E+00   1.82687227364341E-11
      3.75706258462994E-18  -2.36304880921778E-01  -2.33577806512117E-01   0.00000000000000E+00   4.76295101114587E-14
     -9.79291674185470E-23  -8.65596242334271E-09  -8.65591479383270E-09  -2.93587799229570E-18
      1.06775198777400E-09
      0.00000000000000E+00  -8.63781384489348E-12   0.00000000000000E+00   1.32794709145073E-15   1.20414587425909E-22
      8.63783052569709E-09   8.63783185364430E-09  -8.21191056063622E-19  -2.36300945767142E-01  -2.36300945767161E-01
      0.00000000000000E+00   0.00000000000000E+00   1.81784651184064E-11   0.00000000000000E+00   1.81784651184064E-11
      3.75718528926948E-18  -2.36295778939320E-01  -2.33568674426463E-01   0.00000000000000E+00   4.78580728514004E-14
     -9.79277421440686E-23  -8.65605817683547E-09  -8.65601031876271E-09  -2.93599423320586E-18
      1.07686448777400E-09
      0.00000000000000E+00  -8.63808937910510E-12   0.00000000000000E+00   1.33547042202831E-15   1.20518301386836E-22
      8.63808261528697E-09   8.63808395075751E-09  -8.21199643800194E-19  -2.36290029865710E-01  -2.36290029865728E-01
      0.00000000000000E+00   0.00000000000000E+00   1.80631450028019E-11   0.00000000000000E+00   1.80631450028019E-11
      3.75734988967832E-18  -2.36283416604079E-01  -2.33556268988133E-01   0.00000000000000E+00   4.81447337380831E-14
     -9.79258503919335E-23  -8.65619524049408E-09  -8.65614709576044E-09  -2.93615024587813E-18
      1.08916636277400E-09
      0.00000000000000E+00  -8.63845675805393E-12   0.00000000000000E+00   1.26797666381520E-15   1.20657600017735E-22
      8.63840610231016E-09   8.63840737028695E-09  -8.21211132715020E-19  -2.36275388349012E-01  -2.36275388349030E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79310672256272E-11   0.00000000000000E+00   1.79310672256272E-11
      3.75757047542595E-18  -2.36266599581664E-01  -2.33539391667701E-01   0.00000000000000E+00   4.84017870239223E-14
     -9.79232836011695E-23  -8.65638683929948E-09  -8.65633843751255E-09  -2.93635934271093E-18
      1.10577389402400E-09
      0.00000000000000E+00  -8.63873229226555E-12   0.00000000000000E+00   9.52637652370192E-16   1.20843193430074E-22
      8.63873717285410E-09   8.63873812549187E-09  -8.21227068709124E-19  -2.36255513606355E-01  -2.36255513606373E-01
      0.00000000000000E+00   0.00000000000000E+00   1.78362945791535E-11   0.00000000000000E+00   1.78362945791535E-11
      3.75786669224556E-18  -2.36243793617950E-01  -2.33516511335819E-01   0.00000000000000E+00   4.81949828159744E-14
     -9.79198354442805E-23  -8.65662261505382E-09  -8.65657442007111E-09  -2.93663962353643E-18
      1.12577389402400E-09
      0.00000000000000E+00  -8.63873229226555E-12   0.00000000000000E+00   1.05143703670230E-16   1.21060071385403E-22
      8.63879449969953E-09   8.63879460484336E-09  -8.21248547596179E-19  -2.36230650005617E-01  -2.36230650005635E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79306494375194E-11   0.00000000000000E+00   1.79306494375194E-11
      3.75822530523431E-18  -2.36216753745061E-01  -2.33489423915801E-01   0.00000000000000E+00   4.64124125458923E-14
     -9.79158461066929E-23  -8.65677166669335E-09  -8.65672525428090E-09  -2.93697675763813E-18
      1.13577389402400E-09
      0.00000000000000E+00  -8.63873229226555E-12   0.00000000000000E+00  -4.85484029632218E-16   1.21166421345158E-22
      8.63871115701482E-09   8.63871067153091E-09  -8.21260105060741E-19  -2.36217871855199E-01  -2.36217871855217E-01
      0.00000000000000E+00   0.00000000000000E+00   1.80415597160173E-11   0.00000000000000E+00   1.80415597160173E-11
      3.75840572083147E-18  -2.36203437071660E-01  -2.33476098719023E-01   0.00000000000000E+00   4.50693089281737E-14
     -9.79139161329592E-23  -8.65679730055588E-09  -8.65675223124705E-09  -2.93714561577072E-18
      1.14927389402400E-09
      0.00000000000000E+00  -8.63827306857951E-12   0.00000000000000E+00  -1.47587902909765E-15   1.21304876043743E-22
      8.63832019139668E-09   8.63831871551777E-09  -8.21277906211538E-19  -2.36199660031514E-01  -2.36199660031532E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83350345033447E-11   0.00000000000000E+00   1.83350345033447E-11
      3.75865324379726E-18  -2.36186163833133E-01  -2.33458856499894E-01   0.00000000000000E+00   4.20439612668467E-14
     -9.79114875949697E-23  -8.65669579398227E-09  -8.65665375002110E-09  -2.93737533758572E-18
      1.16749889402400E-09
      0.00000000000000E+00  -8.63717093173302E-12   0.00000000000000E+00  -3.28085963691250E-15   1.21479131054124E-22
      8.63711263011115E-09   8.63710934925164E-09  -8.21307800148356E-19  -2.36172448581215E-01  -2.36172448581234E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90384426837929E-11   0.00000000000000E+00   1.90384426837929E-11
      3.75900021941517E-18  -2.36165274531596E-01  -2.33438126593143E-01   0.00000000000000E+00   3.53657962485090E-14
     -9.79087534661066E-23  -8.65618315773166E-09  -8.65614779193551E-09  -2.93769241926682E-18
      1.18749889402399E-09
      0.00000000000000E+00  -8.63487481330283E-12   0.00000000000000E+00  -5.55894671747057E-15   1.21652018569870E-22
      8.63484790764164E-09   8.63484234869505E-09  -8.21349491522166E-19  -2.36138544442074E-01  -2.36138544442095E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01524621386160E-11   0.00000000000000E+00   2.01524621386160E-11
      3.75940326865795E-18  -2.36147092657274E-01  -2.33420307963066E-01   0.00000000000000E+00   2.48265360209537E-14
     -9.79066856249529E-23  -8.65501963736956E-09  -8.65499481083364E-09  -2.93805377713578E-18
      1.20749889402399E-09
      0.00000000000000E+00  -8.63175209223778E-12   0.00000000000000E+00  -7.57902895628036E-15   1.21807078957320E-22
      8.63177403254050E-09   8.63176645351166E-09  -8.21400023502129E-19  -2.36100567706939E-01  -2.36100567706961E-01
      0.00000000000000E+00   0.00000000000000E+00   2.14264117872148E-11   0.00000000000000E+00   2.14264117872148E-11
      3.75983179689369E-18  -2.36135346491848E-01  -2.33409129484782E-01   0.00000000000000E+00   1.21972777034407E-14
     -9.79057328328946E-23  -8.65320506257645E-09  -8.65319286529885E-09  -2.93843177339156E-18
      1.22749889402399E-09
      0.00000000000000E+00  -8.62844568169831E-12   0.00000000000000E+00  -8.29844748116740E-15   1.21951399992803E-22
      8.62844094302244E-09   8.62843264457508E-09  -8.21455867466749E-19  -2.36060091232317E-01  -2.36060091232340E-01
      0.00000000000000E+00   0.00000000000000E+00   2.24592149749602E-11   0.00000000000000E+00   2.24592149749602E-11
      3.76028098119319E-18  -2.36130856832293E-01  -2.33405364730617E-01   0.00000000000000E+00   2.65672237122374E-16
     -9.79058243076644E-23  -8.65089212522224E-09  -8.65089185955010E-09  -2.93882511372644E-18
      1.24749889402399E-09
      0.00000000000000E+00  -8.62596587379370E-12   0.00000000000000E+00  -6.17795094895482E-15   1.22101729933288E-22
      8.62597600416554E-09   8.62596982621471E-09  -8.21508308067335E-19  -2.36021094745715E-01  -2.36021094745737E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25915407590335E-11   0.00000000000000E+00   2.25915407590335E-11
      3.76073281200837E-18  -2.36132497947435E-01  -2.33407740064449E-01   0.00000000000000E+00  -6.08709702354383E-15
     -9.79064414381294E-23  -8.64855527987661E-09  -8.64856136697373E-09  -2.93922450394103E-18
      1.26749889402399E-09
      0.00000000000000E+00  -8.62614956326812E-12   0.00000000000000E+00   4.21796560894293E-16   1.22286599874404E-22
      8.62616151122724E-09   8.62616193302392E-09  -8.21542216542435E-19  -2.35990558955409E-01  -2.35990558955430E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09301092376835E-11   0.00000000000000E+00   2.09301092376835E-11
      3.76115141419312E-18  -2.36135924943954E-01  -2.33411629993972E-01   0.00000000000000E+00   3.34444048493556E-16
     -9.79064232397291E-23  -8.64709237670557E-09  -8.64709204226162E-09  -2.93960919765069E-18
      1.28749889402399E-09
      0.00000000000000E+00  -8.63138471328895E-12   0.00000000000000E+00   1.32352057809007E-14   1.22545838717900E-22
      8.63133196812778E-09   8.63134520333369E-09  -8.21536191034525E-19  -2.35978437290565E-01  -2.35978437290582E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64821140982867E-11   0.00000000000000E+00   1.64821140982867E-11
      3.76148105647509E-18  -2.36132406137046E-01  -2.33407879693569E-01   0.00000000000000E+00   2.78098944443614E-14
     -9.79038457626802E-23  -8.64785512732634E-09  -8.64782731743199E-09  -2.93994486544056E-18
      1.30749889402399E-09
      0.00000000000000E+00  -8.64396744228638E-12   0.00000000000000E+00   3.18373728583397E-14   1.22925395326383E-22
      8.64397386376874E-09   8.64400570114172E-09  -8.21465219032910E-19  -2.35996465921470E-01  -2.35996465921478E-01
      0.00000000000000E+00   0.00000000000000E+00   8.44506674521271E-12   0.00000000000000E+00   8.44506674521271E-12
      3.76164995780999E-18  -2.36108286010364E-01  -2.33382302968640E-01   0.00000000000000E+00   8.51939027752202E-14
     -9.78960817481758E-23  -8.65253596178954E-09  -8.65245076788687E-09  -2.94018473877708E-18
      1.32749889402399E-09
      0.00000000000000E+00  -8.66601017921619E-12   0.00000000000000E+00   5.90302172100606E-14   1.23465369360923E-22
      8.66592281670233E-09   8.66598184691967E-09  -8.21306994003752E-19  -2.36055276329152E-01  -2.36055276329149E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.32814545307804E-12   0.00000000000000E+00  -3.32814545307804E-12
      3.76158339490093E-18  -2.36045831352312E-01  -2.33316635131420E-01   0.00000000000000E+00   1.71883772418570E-13
     -9.78801889225471E-23  -8.66282558523893E-09  -8.66265370146661E-09  -2.94027640089718E-18
      1.34749889402399E-09
      0.00000000000000E+00  -8.69714554512954E-12   0.00000000000000E+00   7.87864745776336E-14   1.24179575998725E-22
      8.69710252353903E-09   8.69718131001373E-09  -8.21052776687620E-19  -2.36159384768474E-01  -2.36159384768456E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77006659165356E-11   0.00000000000000E+00  -1.77006659165356E-11
      3.76122938158260E-18  -2.35926319241205E-01  -2.33191820602542E-01   0.00000000000000E+00   2.93872428239991E-13
     -9.78537245372971E-23  -8.67977451652540E-09  -8.67948064409726E-09  -2.94017660489498E-18
      1.36749889402399E-09
      0.00000000000000E+00  -8.73397528474976E-12   0.00000000000000E+00   9.14321021751226E-14   1.25027257214454E-22
      8.73387961604874E-09   8.73397104815104E-09  -8.20722308044071E-19  -2.36300255102602E-01  -2.36300255102571E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.15768061855938E-11   0.00000000000000E+00  -3.15768061855938E-11
      3.76059784545889E-18  -2.35736281676642E-01  -2.32994563531298E-01   0.00000000000000E+00   4.21380551079014E-13
     -9.78161266053021E-23  -8.70281562251638E-09  -8.70239424196540E-09  -2.93987553741482E-18
      1.38749889402399E-09
      0.00000000000000E+00  -8.76740676909330E-12   0.00000000000000E+00   8.31937391693065E-14   1.25880025284141E-22
      8.76730957326675E-09   8.76739276700605E-09  -8.20381066481129E-19  -2.36448206337213E-01  -2.36448206337173E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.93471149974773E-11   0.00000000000000E+00  -3.93471149974773E-11
      3.75981090315894E-18  -2.35477256406138E-01  -2.32727456515195E-01   0.00000000000000E+00   5.13981384747142E-13
     -9.77705346248482E-23  -8.72855963339318E-09  -8.72804565200853E-09  -2.93942983667781E-18
      1.39749889402399E-09
      0.00000000000000E+00  -8.78173454809767E-12   0.00000000000000E+00   7.15913789624412E-14   1.26285275390243E-22
      8.78168031318284E-09   8.78175190456193E-09  -8.20219392855636E-19  -2.36518640490138E-01  -2.36518640490097E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.08402082085518E-11   0.00000000000000E+00  -4.08402082085518E-11
      3.75940250107685E-18  -2.35331936624712E-01  -2.32578083124551E-01   0.00000000000000E+00   5.45173040930015E-13
     -9.77464264485870E-23  -8.74145686939423E-09  -8.74091169635339E-09  -2.93918310822122E-18
      1.41099889402399E-09
      0.00000000000000E+00  -8.79165377971608E-12   0.00000000000000E+00   3.72512804028753E-14   1.26711276324472E-22
      8.79162810101793E-09   8.79166535229845E-09  -8.20059395108220E-19  -2.36587997496339E-01  -2.36587997496303E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.57525736528202E-11   0.00000000000000E+00  -3.57525736528202E-11
      3.75891984133254E-18  -2.35116968459083E-01  -2.32358388721570E-01   0.00000000000000E+00   5.38960842437785E-13
     -9.77144742372685E-23  -8.75645173948796E-09  -8.75591277864562E-09  -2.93886044622432E-18
      1.42922389402399E-09
      0.00000000000000E+00  -8.77007026647231E-12   0.00000000000000E+00  -5.32832292681576E-14   1.26771208169425E-22
      8.77015315306722E-09   8.77009986983808E-09  -8.20103152859092E-19  -2.36563611804161E-01  -2.36563611804153E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.74806095325477E-12   0.00000000000000E+00  -7.74806095325477E-12
      3.75877863292167E-18  -2.34847055974085E-01  -2.32086448632637E-01   0.00000000000000E+00   3.70969279438738E-13
     -9.76853232017622E-23  -8.76272277816421E-09  -8.76235180888486E-09  -2.93867548006257E-18
      1.44922389402399E-09
      0.00000000000000E+00  -8.67638863452064E-12   0.00000000000000E+00  -2.08348751926276E-13   1.25721973607464E-22
      8.67667629709201E-09   8.67646794834021E-09  -8.20728571585316E-19  -2.36271137646118E-01  -2.36271137646177E-01
      0.00000000000000E+00   0.00000000000000E+00   5.92413137578228E-11   0.00000000000000E+00   5.92413137578228E-11
      3.75996345919682E-18  -2.34701183656819E-01  -2.31948975477710E-01   0.00000000000000E+00  -1.12330722166863E-13
     -9.76958924840124E-23  -8.73559693137580E-09  -8.73570926209806E-09  -2.93923488761151E-18
      1.46922389402399E-09
      0.00000000000000E+00  -8.48737216534755E-12   0.00000000000000E+00  -4.17906012293715E-13   1.23061327353538E-22
      8.48785977142047E-09   8.48744186540830E-09  -8.22215367365477E-19  -2.35578722620307E-01  -2.35578722620476E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69110564071522E-10   0.00000000000000E+00   1.69110564071522E-10
      3.76334567047825E-18  -2.34882772994256E-01  -2.32155511585216E-01   0.00000000000000E+00  -9.69347662230837E-13
     -9.77813059527709E-23  -8.65558308181743E-09  -8.65655242947976E-09  -2.94113030311278E-18
      1.48922389402399E-09
      0.00000000000000E+00  -8.19245871417418E-12   0.00000000000000E+00  -6.55240397189757E-13   1.18489236325866E-22
      8.19316578607208E-09   8.19251054567501E-09  -8.24777701291823E-19  -2.34382393709209E-01  -2.34382393709526E-01
      0.00000000000000E+00   0.00000000000000E+00   3.17574191766670E-10   0.00000000000000E+00   3.17574191766670E-10
      3.76969715431359E-18  -2.35593335911280E-01  -2.32912227566196E-01   0.00000000000000E+00  -2.20376879213319E-12
     -9.79736270445785E-23  -8.50788096864950E-09  -8.51008473744173E-09  -2.94491945302176E-18
      1.50922389402399E-09
      0.00000000000000E+00  -7.81313994950709E-12   0.00000000000000E+00  -9.42913873873231E-13   1.12182770458129E-22
      7.81406767894892E-09   7.81312476507516E-09  -8.28410367609433E-19  -2.32677986659331E-01  -2.32677986659812E-01
      0.00000000000000E+00   0.00000000000000E+00   4.80823268844285E-10   0.00000000000000E+00   4.80823268844285E-10
      3.77931361969047E-18  -2.36999097472817E-01  -2.34386059575337E-01   0.00000000000000E+00  -3.58843801947509E-12
     -9.82915266310847E-23  -8.29035959589984E-09  -8.29394803391941E-09  -2.95090325208104E-18
      1.52922389402399E-09
      0.00000000000000E+00  -7.42087107689375E-12   0.00000000000000E+00  -8.89685521568636E-13   1.05100683169752E-22
      7.42180089455182E-09   7.42091120903035E-09  -8.32676292295945E-19  -2.30661181089378E-01  -2.30661181089986E-01
      0.00000000000000E+00   0.00000000000000E+00   6.07460299101516E-10   0.00000000000000E+00   6.07460299101516E-10
      3.79146282567250E-18  -2.39142727083771E-01  -2.36613388249525E-01   0.00000000000000E+00  -5.03918013397680E-12
     -9.87203690485595E-23  -8.02333232799785E-09  -8.02837150813193E-09  -2.95878653337656E-18
      1.54922389402399E-09
      0.00000000000000E+00  -7.14809220738739E-12   0.00000000000000E+00  -6.81849379979699E-13   9.91998032768253E-23
      7.14877411110570E-09   7.14809226172582E-09  -8.36474845611002E-19  -2.28838306690968E-01  -2.28838306691584E-01
      0.00000000000000E+00   0.00000000000000E+00   6.16291718861119E-10   0.00000000000000E+00   6.16291718861119E-10
      3.80378866004973E-18  -2.41841473384246E-01  -2.39395279153336E-01   0.00000000000000E+00  -5.55313668075365E-12
     -9.91900654496161E-23  -7.75883084390607E-09  -7.76438398058692E-09  -2.96731381443873E-18
      1.56922389402399E-09
      0.00000000000000E+00  -7.18446272332157E-12   0.00000000000000E+00   8.44773536815334E-14   9.74922080910793E-23
      7.18435989665501E-09   7.18444437400879E-09  -8.37920825069154E-19  -2.28085761736012E-01  -2.28085761736421E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08462272632192E-10   0.00000000000000E+00   4.08462272632192E-10
      3.81195790550237E-18  -2.44602499494536E-01  -2.42210333166405E-01   0.00000000000000E+00  -4.47131954044038E-12
     -9.95577184949784E-23  -7.58843532710038E-09  -7.59290664664092E-09  -2.97403708043322E-18
      1.58922389402399E-09
      0.00000000000000E+00  -7.75215504400130E-12   0.00000000000000E+00   1.40420728466577E-12   1.03928005355401E-22
      7.75071710111620E-09   7.75212130840097E-09  -8.34609685701242E-19  -2.29526132126683E-01  -2.29526132126585E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81903914785345E-11   0.00000000000000E+00  -9.81903914785345E-11
      3.80999409767280E-18  -2.46547156673156E-01  -2.44135769479111E-01   0.00000000000000E+00  -8.32146163728874E-13
     -9.96136765489809E-23  -7.65309877075872E-09  -7.65393091692255E-09  -2.97538441197156E-18
      1.60922389402399E-09
      0.00000000000000E+00  -9.05708507024583E-12   0.00000000000000E+00   3.23615120874139E-12   1.23032495204569E-22
      9.05381253647422E-09   9.05704868768309E-09  -8.24539966555459E-19  -2.34093478805282E-01  -2.34093478804368E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14534922047207E-10   0.00000000000000E+00  -9.14534922047207E-10
      3.79170339923185E-18  -2.46332176148541E-01  -2.43766864908505E-01   0.00000000000000E+00   5.54806613760321E-12
     -9.91220541441284E-23  -8.14806183177336E-09  -8.14251376563585E-09  -2.96716343267640E-18
      1.62922389402399E-09
      0.00000000000000E+00  -1.12004657024579E-11   0.00000000000000E+00   5.31835588779014E-12   1.58638649702518E-22
      1.11951513744857E-08   1.12004697303736E-08  -8.07509192579409E-19  -2.41891205398384E-01  -2.41891205396446E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93761315530144E-09   0.00000000000000E+00  -1.93761315530144E-09
      3.75295113612583E-18  -2.42120764284458E-01  -2.39202487959123E-01   0.00000000000000E+00   1.36227523282806E-11
     -9.78907758497482E-23  -9.27647932740036E-09  -9.26285657507217E-09  -2.94544194354642E-18
      1.64922389402399E-09
      0.00000000000000E+00  -1.40523366374888E-11   0.00000000000000E+00   7.07590933942647E-12   2.10893417942522E-22
      1.40452166839217E-08   1.40522925932614E-08  -7.85811382114929E-19  -2.51907063288437E-01  -2.51907063285449E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98802023586390E-09   0.00000000000000E+00  -2.98802023586390E-09
      3.69319073140855E-18  -2.31812100209334E-01  -2.28326275225636E-01   0.00000000000000E+00   2.15250518389331E-11
     -9.58204039866295E-23  -1.10857974092363E-08  -1.10642723573975E-08  -2.90737934929362E-18
      1.66922389402399E-09
      0.00000000000000E+00  -1.72064686026697E-11   0.00000000000000E+00   7.82623713196040E-12   2.73552969154678E-22
      1.71985951541188E-08   1.72064213912511E-08  -7.62985397497131E-19  -2.62620626959217E-01  -2.62620626955271E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.94580106769129E-09   0.00000000000000E+00  -3.94580106769129E-09
      3.61427471005472E-18  -2.13623393240831E-01  -2.09445579806743E-01   0.00000000000000E+00   2.78142835898966E-11
     -9.28858549284659E-23  -1.32884346071495E-08  -1.32606203235597E-08  -2.85128931255759E-18
      1.68922389402399E-09
      0.00000000000000E+00  -2.01217124063738E-11   0.00000000000000E+00   7.23863654746483E-12   3.35511303764387E-22
      2.01145108920459E-08   2.01217495285937E-08  -7.41790850585165E-19  -2.72893047711592E-01  -2.72893047706786E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.80529788148623E-09   0.00000000000000E+00  -4.80529788148623E-09
      3.51816875242500E-18  -1.86842127943770E-01  -1.82016581808515E-01   0.00000000000000E+00   3.16478916685332E-11
     -8.91722382323670E-23  -1.53480995387759E-08  -1.53164516471075E-08  -2.77637790183983E-18
      1.70922389402399E-09
      0.00000000000000E+00  -2.22378151516352E-11   0.00000000000000E+00   5.26155983642406E-12   3.84031680059212E-22
      2.22325520658213E-08   2.22378136256582E-08  -7.23888370475390E-19  -2.82035724122451E-01  -2.82035724116956E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49469217765707E-09   0.00000000000000E+00  -5.49469217765707E-09
      3.40827490887186E-18  -1.52798959384404E-01  -1.47523891605240E-01   0.00000000000000E+00   3.19347693833895E-11
     -8.49455607050311E-23  -1.67750562173843E-08  -1.67431214480010E-08  -2.68438653839647E-18
      1.72922389402399E-09
      0.00000000000000E+00  -2.29530101202702E-11   0.00000000000000E+00   1.79664480843572E-12   4.05608845480147E-22
      2.29511876700720E-08   2.29529843148808E-08  -7.10855091109013E-19  -2.89296958031182E-01  -2.89296958025456E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72626600100316E-09   0.00000000000000E+00  -5.72626600100316E-09
      3.29374958885179E-18  -1.15688795764523E-01  -1.10261329270270E-01   0.00000000000000E+00   2.81972837576981E-11
     -7.60025248631515E-23  -1.72549155976353E-08  -1.72267183138777E-08  -2.58289449774278E-18
      1.74922389402399E-09
      0.00000000000000E+00  -2.16874814862877E-11   0.00000000000000E+00  -3.10393709189693E-12   3.89322941122736E-22
      2.16905680673953E-08   2.16874641303038E-08  -7.04661003606919E-19  -2.93612621838525E-01  -2.93612621833443E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.08185236447623E-09   0.00000000000000E+00  -5.08185236447623E-09
      3.19211254156227E-18  -8.20944624568192E-02  -7.68626536678347E-02   0.00000000000000E+00   2.16826750747456E-11
     -4.09213424297741E-23  -1.66272944409022E-08  -1.66056117658275E-08  -2.48745153795535E-18
      1.76922389402399E-09
      0.00000000000000E+00  -1.82711327963793E-11   0.00000000000000E+00  -8.40818690725709E-12   3.38385414557970E-22
      1.82796051764017E-08   1.82711969894948E-08  -7.07091412141499E-19  -2.93850845752351E-01  -2.93850845749091E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.25962435078646E-09   0.00000000000000E+00  -3.25962435078646E-09
      3.12692005454654E-18  -5.85199102101458E-02  -5.37903118670382E-02   0.00000000000000E+00   1.41638483874803E-11
      2.11245488632359E-23  -1.50257364870959E-08  -1.50115726387084E-08  -2.41982864240504E-18
      1.78922389402399E-09
      0.00000000000000E+00  -1.35781422592863E-11   0.00000000000000E+00  -1.15972892842172E-11   2.63563290791529E-22
      1.35897402646207E-08   1.35781429753368E-08  -7.21469500298877E-19  -2.88350125046216E-01  -2.88350125045780E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.35633289015253E-10   0.00000000000000E+00  -4.35633289015253E-10
      3.11820738876623E-18  -4.69088194111182E-02  -4.27680804932262E-02   0.00000000000000E+00   6.22146449091080E-12
      4.30693125119291E-23  -1.31487311508125E-08  -1.31425096863215E-08  -2.39673788846736E-18
      1.80922389402399E-09
      0.00000000000000E+00  -8.65489696601408E-12   0.00000000000000E+00  -1.21379034780175E-11   1.73678495236139E-22
      8.66710688688805E-09   8.65496898341021E-09  -7.52292416627673E-19  -2.75093110443114E-01  -2.75093110445959E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84435862763967E-09   0.00000000000000E+00   2.84435862763967E-09
      3.17509456131903E-18  -4.57145264533229E-02  -4.20915096725621E-02   0.00000000000000E+00  -2.40431018506740E-12
      9.04156906123084E-25  -1.14969233008648E-08  -1.14993276110499E-08  -2.42280214469135E-18
      1.82922389402399E-09
      0.00000000000000E+00  -3.75075537808098E-12   0.00000000000000E+00  -1.21908136288981E-11   8.25760729104753E-23
      3.76289017684007E-09   3.75069936321126E-09  -8.02610918637893E-19  -2.52403046187071E-01  -2.52403046193285E-01
      0.00000000000000E+00   0.00000000000000E+00   6.21437824617992E-09   0.00000000000000E+00   6.21437824617992E-09
      3.29938212624263E-18  -5.46127381243747E-02  -5.14730879391484E-02   0.00000000000000E+00  -1.30732635494287E-11
     -5.93134526088280E-23  -9.95200434584177E-09  -9.96507760939126E-09  -2.49677120760473E-18
      1.84922389402399E-09
      0.00000000000000E+00   6.80753192182188E-13   0.00000000000000E+00  -1.10924691996947E-11   8.07545987509859E-24
     -6.69695784371470E-10  -6.80788253571156E-10  -8.73645311447352E-19  -2.19057340321699E-01  -2.19057340330914E-01
      0.00000000000000E+00   0.00000000000000E+00   9.21572546328080E-09   0.00000000000000E+00   9.21572546328080E-09
      3.48369663550824E-18  -7.30132962936621E-02  -7.03242278575961E-02   0.00000000000000E+00  -2.96121198527829E-11
     -8.34059747207113E-23  -8.50532508985673E-09  -8.53493720970960E-09  -2.61005132406089E-18
      1.86922389402399E-09
      0.00000000000000E+00   3.42250228730128E-12   0.00000000000000E+00  -7.02773930882738E-12  -3.21290431220973E-23
     -3.41548125236575E-09  -3.42250899167461E-09  -9.60690197644588E-19  -1.76375933547257E-01  -1.76375933558205E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09485369227941E-08   0.00000000000000E+00   1.09485369227941E-08
      3.70266737396412E-18  -9.67446900677671E-02  -9.43734865487034E-02   0.00000000000000E+00  -5.33033076981199E-11
     -8.99449051445207E-23  -7.47272462342124E-09  -7.52602793111945E-09  -2.74197717631954E-18
      1.88922389402399E-09
      0.00000000000000E+00   4.32919353301398E-12   0.00000000000000E+00  -2.60087042639615E-12  -4.34634317320687E-23
     -4.32657494045633E-09  -4.32917581088277E-09  -1.05179690970361E-18  -1.29345066552909E-01  -1.29345066564034E-01
      0.00000000000000E+00   0.00000000000000E+00   1.11253550885344E-08   0.00000000000000E+00   1.11253550885344E-08
      3.92517447573481E-18  -1.22641459469566E-01  -1.20500200131753E-01   0.00000000000000E+00  -8.15620620777136E-11
     -9.75490924058554E-23  -6.71461721557390E-09  -6.79617927765171E-09  -2.87337756603120E-18
      1.90922389402399E-09
      0.00000000000000E+00   4.05669019771925E-12   0.00000000000000E+00   2.52409409816400E-13  -4.58715883722878E-23
     -4.05695077552924E-09  -4.05669836611947E-09  -1.13355742614123E-18  -8.47418506437533E-02  -8.47418506538349E-02
      0.00000000000000E+00   0.00000000000000E+00   1.00815942846289E-08   0.00000000000000E+00   1.00815942846289E-08
      4.12680636142739E-18  -1.50019176966850E-01  -1.48120918895760E-01   0.00000000000000E+00  -1.08565241341347E-10
     -1.05887846524211E-22  -5.91633067716787E-09  -6.02489591850933E-09  -2.99324893528616E-18
      1.92922389402399E-09
      0.00000000000000E+00   2.98991357505383E-12   0.00000000000000E+00   2.25614268071514E-12  -4.67221311648592E-23
     -2.99218185963000E-09  -2.98992571694933E-09  -1.19300381114690E-18  -5.06413721891365E-02  -5.06413721971198E-02
      0.00000000000000E+00   0.00000000000000E+00   7.98330544699529E-09   0.00000000000000E+00   7.98330544699529E-09
      4.28647247036730E-18  -1.79185702703313E-01  -1.77612439067290E-01   0.00000000000000E+00  -1.23226586718658E-10
     -1.13662932174597E-22  -4.87015314332719E-09  -4.99337973004596E-09  -3.09346865922040E-18
      1.94922389402399E-09
      0.00000000000000E+00   1.67166606191419E-12   0.00000000000000E+00   3.01849555485401E-12  -4.71315795486144E-23
     -1.67470674943816E-09  -1.67168825388336E-09  -1.22584680025304E-18  -3.10323770644704E-02  -3.10323770699220E-02
      0.00000000000000E+00   0.00000000000000E+00   5.45160660092081E-09   0.00000000000000E+00   5.45160660092081E-09
      4.39550460238571E-18  -2.08949219880269E-01  -2.07758277524125E-01   0.00000000000000E+00  -1.18377650009619E-10
     -1.20166409300607E-22  -3.66154069702772E-09  -3.77991834703746E-09  -3.16965780213267E-18
      1.96922389402399E-09
      0.00000000000000E+00   8.19530590102761E-13   0.00000000000000E+00   1.99112962067021E-12  -4.73193557193586E-23
     -8.21542370741812E-10  -8.19551241121189E-10  -1.24158824756825E-18  -2.13335544604963E-02  -2.13335544640618E-02
      0.00000000000000E+00   0.00000000000000E+00   3.56547237118936E-09   0.00000000000000E+00   3.56547237118936E-09
      4.46681404980950E-18  -2.35689487545837E-01  -2.34824324842828E-01   0.00000000000000E+00  -1.02268886948842E-10
     -1.25242096829413E-22  -2.64365224311921E-09  -2.74592113006818E-09  -3.22522580224125E-18
      1.98922389402399E-09
      0.00000000000000E+00   4.32680556984659E-13   0.00000000000000E+00   9.03280364443846E-13  -4.74143937990131E-23
     -4.33609574413249E-10  -4.32706294048852E-10  -1.24957938345093E-18  -1.63329224592130E-02  -1.63329224616076E-02
      0.00000000000000E+00   0.00000000000000E+00   2.39456765870760E-09   0.00000000000000E+00   2.39456765870760E-09
      4.51470540298365E-18  -2.56826738977393E-01  -2.56208610399929E-01   0.00000000000000E+00  -8.17037139925461E-11
     -1.29015296632964E-22  -1.88015765066610E-09  -1.96186136465878E-09  -3.26512601953272E-18
      2.00922389402399E-09
      0.00000000000000E+00   2.69839837915714E-13   0.00000000000000E+00   3.75456213198063E-13  -4.74703916679051E-23
     -2.70236035431740E-10  -2.69860579218590E-10  -1.25431196218862E-18  -1.34199581464134E-02  -1.34199581480586E-02
      0.00000000000000E+00   0.00000000000000E+00   1.64517287589400E-09   0.00000000000000E+00   1.64517287589400E-09
      4.54760886050153E-18  -2.72045189522355E-01  -2.71611866877177E-01   0.00000000000000E+00  -6.04397857311236E-11
     -1.31677030961486E-22  -1.31487251094415E-09  -1.37531229667540E-09  -3.29329689831291E-18
      2.02922389402399E-09
      0.00000000000000E+00   1.91496277077693E-13   0.00000000000000E+00   1.78659113380308E-13  -4.75055415964340E-23
     -1.91699406792240E-10  -1.91520747678908E-10  -1.25747964679548E-18  -1.15568467001371E-02  -1.15568467013028E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16563615118994E-09   0.00000000000000E+00   1.16563615118994E-09
      4.57092158352533E-18  -2.82711936679508E-01  -2.82405021283128E-01   0.00000000000000E+00  -4.30987638687360E-11
     -1.33518590955174E-22  -9.31016639642112E-10  -9.74115403510981E-10  -3.31344193672985E-18
      2.04922389402399E-09
      0.00000000000000E+00   1.47318958480873E-13   0.00000000000000E+00   1.01137490569252E-13  -4.75277265374723E-23
     -1.47382227428797E-10  -1.47281089938275E-10  -1.25976624000994E-18  -1.02839212594023E-02  -1.02839212602931E-02
      0.00000000000000E+00   0.00000000000000E+00   8.90779734278886E-10   0.00000000000000E+00   8.90779734278886E-10
      4.58873717821091E-18  -2.90727684024304E-01  -2.90493430543859E-01   0.00000000000000E+00  -3.24124663271296E-11
     -1.34873464010318E-22  -7.11086178013408E-10  -7.43498644340673E-10  -3.32897093820097E-18
      2.06922389402399E-09
      0.00000000000000E+00   1.20316605741860E-13   0.00000000000000E+00   6.24986595380586E-14  -4.75416326486715E-23
     -1.20368059694610E-10  -1.20305561035120E-10  -1.26151830640236E-18  -9.35679943953757E-03  -9.35679944028357E-03
      0.00000000000000E+00   0.00000000000000E+00   7.46010446744983E-10   0.00000000000000E+00   7.46010446744983E-10
      4.60365738714581E-18  -2.97436909837280E-01  -2.97239770453579E-01   0.00000000000000E+00  -2.69332100301335E-11
     -1.35977941826525E-22  -5.98771675679594E-10  -6.25704885709864E-10  -3.34213908074345E-18
      2.07922389402399E-09
      0.00000000000000E+00   1.08193100430467E-13   0.00000000000000E+00   5.75793915561189E-14  -4.75464969855283E-23
     -1.08221791402340E-10  -1.08164212010831E-10  -1.26227429739662E-18  -8.97198543289836E-03  -8.97198543357393E-03
      0.00000000000000E+00   0.00000000000000E+00   6.75562399837719E-10   0.00000000000000E+00   6.75562399837719E-10
      4.61041301114418E-18  -3.00451059496082E-01  -3.00272291213524E-01   0.00000000000000E+00  -2.40393047440523E-11
     -1.36465861572821E-22  -5.43358883082694E-10  -5.67398187826882E-10  -3.34813871374756E-18
      2.09272389402399E-09
      0.00000000000000E+00   9.34060977400547E-14   0.00000000000000E+00   5.35788547849287E-14  -4.75497679977781E-23
     -9.35038770740010E-11  -9.34502982192636E-11  -1.26309946291171E-18  -8.55838515515835E-03  -8.55838515582992E-03
      0.00000000000000E+00   0.00000000000000E+00   6.71571090888067E-10   0.00000000000000E+00   6.71571090888067E-10
      4.61947922087117E-18  -3.04772609287424E-01  -3.04590462369180E-01   0.00000000000000E+00  -2.54473507495825E-11
     -1.37150707423166E-22  -5.52673441919214E-10  -5.78120792668934E-10  -3.35637975795947E-18
      2.11094889402399E-09
      0.00000000000000E+00   7.52208397729644E-14   0.00000000000000E+00   5.17191935207081E-14  -4.75487279634012E-23
     -7.52785032845317E-11  -7.52267840910586E-11  -1.26388979385977E-18  -8.13639577371848E-03  -8.13639577449049E-03
      0.00000000000000E+00   0.00000000000000E+00   7.72012488199570E-10   0.00000000000000E+00   7.72012488199570E-10
      4.63354914846861E-18  -3.12404363224933E-01  -3.12184827194803E-01   0.00000000000000E+00  -3.37930931405225E-11
     -1.38348120313281E-22  -6.62992610967821E-10  -6.96785704108482E-10  -3.36965935460884E-18
      2.13094889402399E-09
      0.00000000000000E+00   5.91480107616472E-14   0.00000000000000E+00   4.43202152512094E-14  -4.75426101423034E-23
     -5.91590744776297E-11  -5.91147542624260E-11  -1.26444910627544E-18  -7.75640982805355E-03  -7.75640982902404E-03
      0.00000000000000E+00   0.00000000000000E+00   9.70492286207255E-10   0.00000000000000E+00   9.70492286207255E-10
      4.65295899419275E-18  -3.24143882358497E-01  -3.23856732435396E-01   0.00000000000000E+00  -4.91883115190859E-11
     -1.40206952735580E-22  -8.62189220425567E-10  -9.11377531944793E-10  -3.38850988791732E-18
      2.15094889402399E-09
      0.00000000000000E+00   6.08930607685902E-14   0.00000000000000E+00  -3.28610205601102E-16  -4.75385639880471E-23
     -6.08543325785287E-11  -6.08546611887818E-11  -1.26505862506849E-18  -7.28278751375043E-03  -7.28278751485944E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10901764617391E-09   0.00000000000000E+00   1.10901764617391E-09
      4.67513934711623E-18  -3.37914069199305E-01  -3.37583820558162E-01   0.00000000000000E+00  -6.06915973809380E-11
     -1.42436543547156E-22  -9.87471387604089E-10  -1.04816298498517E-09  -3.41008072204774E-18
      2.17094889402399E-09
      0.00000000000000E+00   7.09959818614182E-14   0.00000000000000E+00  -2.30582662926869E-14  -4.75387672460240E-23
     -7.09370132818839E-11  -7.09600715482241E-11  -1.26588463472527E-18  -6.66265595923744E-03  -6.66265596038930E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15185374855191E-09   0.00000000000000E+00   1.15185374855191E-09
      4.69817642208727E-18  -3.52115061261979E-01  -3.51774499457325E-01   0.00000000000000E+00  -6.59927121149646E-11
     -1.44791274683918E-22  -1.01490096488853E-09  -1.08089367700364E-09  -3.43229178736200E-18
      2.19094889402399E-09
      0.00000000000000E+00   6.93427765916827E-14   0.00000000000000E+00   5.63072876738155E-15  -4.75378990653768E-23
     -6.93419228407379E-11  -6.93362921120180E-11  -1.26669226098617E-18  -6.05671300500005E-03  -6.05671300612787E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12781914123941E-09   0.00000000000000E+00   1.12781914123941E-09
      4.72073280491206E-18  -3.66078030975442E-01  -3.65744530042899E-01   0.00000000000000E+00  -6.76196383635014E-11
     -1.47135371330561E-22  -9.90863210763740E-10  -1.05848284912739E-09  -3.45404054392589E-18
      2.21094889402399E-09
      0.00000000000000E+00   2.97576948552387E-14   0.00000000000000E+00   1.05168859822280E-13  -4.75215023765664E-23
     -2.98382419556526E-11  -2.97330730958779E-11  -1.26672594599801E-18  -5.91878955355405E-03  -5.91878955458513E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03107556569731E-09   0.00000000000000E+00   1.03107556569731E-09
      4.74135431622600E-18  -3.79693161284709E-01  -3.79377664003981E-01   0.00000000000000E+00  -6.62929724757994E-11
     -1.49372296738529E-22  -9.35049520125536E-10  -1.00134249260149E-09  -3.47462837022799E-18
      2.23094889402399E-09
      0.00000000000000E+00  -1.46492355846005E-13   0.00000000000000E+00   4.69291583744029E-13  -4.74377402126756E-23
      1.46099793533612E-10   1.46569085117309E-10  -1.26327348118766E-18  -7.85343707253725E-03  -7.85343707325312E-03
      0.00000000000000E+00   0.00000000000000E+00   7.15871072020241E-10   0.00000000000000E+00   7.15871072020241E-10
      4.75567173766641E-18  -3.93173976445140E-01  -3.92902245101867E-01   0.00000000000000E+00  -5.72066028514245E-11
     -1.51259806151146E-22  -8.05233554285854E-10  -8.62440157137430E-10  -3.49239825647874E-18
      2.25094889402399E-09
      0.00000000000000E+00  -7.70118121485112E-13   0.00000000000000E+00   1.66446531873388E-12  -4.71223386225458E-23
      7.68451771696970E-10   7.70116237015656E-10  -1.24749181819396E-18  -1.70235981928719E-02  -1.70235981925638E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.08061094332186E-10   0.00000000000000E+00  -3.08061094332186E-10
      4.74951051577977E-18  -4.07214613019639E-01  -4.07069038263747E-01   0.00000000000000E+00  -2.30607295022301E-11
     -1.52018316195208E-22  -4.38994413181190E-10  -4.62055142683573E-10  -3.50201869758581E-18
      2.27094889402399E-09
      0.00000000000000E+00  -1.60067008005278E-12   0.00000000000000E+00   2.28313061693533E-12  -4.65413174907345E-23
      1.59835191018083E-09   1.60063504079772E-09  -1.21551413448103E-18  -3.53532735263156E-02  -3.53532735246814E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.63411160553461E-09   0.00000000000000E+00  -1.63411160553461E-09
      4.71682828366907E-18  -4.21977319151950E-01  -4.21987882027732E-01   0.00000000000000E+00   2.14644105361182E-11
     -1.51339756245895E-22   1.20121542008881E-11   3.34765647368550E-11  -3.50131414918804E-18
      2.29094889402399E-09
      0.00000000000000E+00  -2.26397277216553E-12   0.00000000000000E+00   1.92335711181155E-12  -4.57366554075811E-23
      2.26204569059936E-09   2.26396904771113E-09  -1.17134725315708E-18  -5.99547986797613E-02  -5.99547986771398E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.62149072408652E-09   0.00000000000000E+00  -2.62149072408652E-09
      4.66439846918734E-18  -4.36977715432300E-01  -4.37090384742793E-01   0.00000000000000E+00   5.17801211151511E-11
     -1.49668191117797E-22   3.05741555260449E-10   3.57521676375450E-10  -3.49305121603026E-18
      2.30094889402399E-09
      0.00000000000000E+00  -2.66946728693677E-12   0.00000000000000E+00   2.29462311484117E-12  -4.51492619672415E-23
      2.66721924858701E-09   2.66951387170181E-09  -1.14574598347615E-18  -7.38596831206969E-02  -7.38596831175203E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.17658327586093E-09   0.00000000000000E+00  -3.17658327586093E-09
      4.63263263642874E-18  -4.44478573265077E-01  -4.44638366651752E-01   0.00000000000000E+00   6.63703641092193E-11
     -1.48583772934411E-22   4.40699040050243E-10   5.07069404159314E-10  -3.48688665295258E-18
      2.31444889402399E-09
      0.00000000000000E+00  -3.14990710726934E-12   0.00000000000000E+00   2.05854202284987E-12  -4.37063133815020E-23
      3.14785903857321E-09   3.14991758059602E-09  -1.10653283135283E-18  -9.46481147179962E-02  -9.46481147142695E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.72665855144123E-09   0.00000000000000E+00  -3.72665855144123E-09
      4.58232274598428E-18  -4.54524939024396E-01  -4.54706694749594E-01   0.00000000000000E+00   7.92392256019431E-11
     -1.46807251724780E-22   4.97501745243404E-10   5.76740970845200E-10  -3.47578991463145E-18
      2.33267389402399E-09
      0.00000000000000E+00  -4.06220088195170E-12   0.00000000000000E+00   2.76584130250336E-12  -3.76458925999554E-23
      4.05939425847198E-09   4.06216009977445E-09  -1.04520612061563E-18  -1.26033158016746E-01  -1.26033158012259E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48750297736269E-09   0.00000000000000E+00  -4.48750297736269E-09
      4.50053800422184E-18  -4.67447155902616E-01  -4.67581240523436E-01   0.00000000000000E+00   9.49982711779111E-11
     -1.43844178193776E-22   3.30344606410413E-10   4.25342877588180E-10  -3.45533188360621E-18
      2.35267389402399E-09
      0.00000000000000E+00  -5.84766257326602E-12   0.00000000000000E+00   4.66806391909599E-12  -1.19933551489466E-23
      5.84298270547384E-09   5.84765076939293E-09  -9.70437452860800E-19  -1.62613005833413E-01  -1.62613005828169E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.24343105613868E-09   0.00000000000000E+00  -5.24343105613868E-09
      4.39566938309907E-18  -4.78980208106487E-01  -4.78789987141644E-01   0.00000000000000E+00   1.07446832080228E-10
     -1.39952759410022E-22  -7.11666545334429E-10  -6.04219713254341E-10  -3.42523193023827E-18
      2.37267389402399E-09
      0.00000000000000E+00  -9.37606184256758E-12   0.00000000000000E+00   8.90684561692201E-12   5.90916835916062E-23
      9.36718464205095E-09   9.37609148766793E-09  -8.95638387963029E-19  -1.97597021073520E-01  -1.97597021067766E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.75431965932724E-09   0.00000000000000E+00  -5.75431965932724E-09
      4.28058298991253E-18  -4.83773647363920E-01  -4.82632854766986E-01   0.00000000000000E+00   1.14730971841418E-10
     -1.35396417110901E-22  -3.73650280018181E-09  -3.62177182834053E-09  -3.38494460194949E-18
      2.39267389402399E-09
      0.00000000000000E+00  -1.55508753697668E-11   0.00000000000000E+00   1.53735435507937E-11   1.86642334039428E-22
      1.55354554494022E-08   1.55508289929532E-08  -8.28949681235443E-19  -2.27772487239014E-01  -2.27772487232874E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.13976346795289E-09   0.00000000000000E+00  -6.13976346795289E-09
      4.15778772055347E-18  -4.76142549094872E-01  -4.73177978497922E-01   0.00000000000000E+00   1.23610422680187E-10
     -1.29825130230594E-22  -9.53467594768032E-09  -9.41106552500026E-09  -3.32883803931802E-18
      2.41267389402399E-09
      0.00000000000000E+00  -2.35158346698779E-11   0.00000000000000E+00   1.97531107135417E-11   3.54478748079054E-22
      2.34960082676000E-08   2.35157613783139E-08  -7.75852219479050E-19  -2.51555011594867E-01  -2.51555011588360E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.50719507106206E-09   0.00000000000000E+00  -6.50719507106206E-09
      4.02764381913223E-18  -4.51512331096942E-01  -4.46154239915248E-01   0.00000000000000E+00   1.33546027708165E-10
     -1.22884255276815E-22  -1.71421123349600E-08  -1.70085663072520E-08  -3.25179159965318E-18
      2.43267389402399E-09
      0.00000000000000E+00  -3.06253520876382E-11   0.00000000000000E+00   1.76434618075122E-11   5.09071308787670E-22
      3.06076821912863E-08   3.06253256530943E-08  -7.37992549094115E-19  -2.68899357239701E-01  -2.68899357232844E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.85684009593147E-09   0.00000000000000E+00  -6.85684009593147E-09
      3.89050701721360E-18  -4.08570323026099E-01  -4.01082451740394E-01   0.00000000000000E+00   1.38213236885475E-10
     -1.14705089247861E-22  -2.39066987940482E-08  -2.37684855571629E-08  -3.15251446811948E-18
      2.45267389402399E-09
      0.00000000000000E+00  -3.43964969973792E-11   0.00000000000000E+00   9.38482762755535E-12   5.99234539348068E-22
      3.43871139050463E-08   3.43964987326744E-08  -7.14358754313393E-19  -2.80559646187162E-01  -2.80559646179991E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.17083564382226E-09   0.00000000000000E+00  -7.17083564382226E-09
      3.74709030433715E-18  -3.49204626769359E-01  -3.40627389707112E-01   0.00000000000000E+00   1.33152543212963E-10
     -1.06040215987555E-22  -2.73588156320651E-08  -2.72256630888522E-08  -3.03273155002376E-18
      2.47267389402399E-09
      0.00000000000000E+00  -3.44910970767030E-11   0.00000000000000E+00   2.82003098278287E-13   6.15911898713673E-22
      3.44908395439506E-08   3.44911215470495E-08  -7.01392668623816E-19  -2.88083947907113E-01  -2.88083947899710E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.40343198445376E-09   0.00000000000000E+00  -7.40343198445376E-09
      3.59902166464808E-18  -2.80188611546702E-01  -2.71654650329723E-01   0.00000000000000E+00   1.13908413918876E-10
     -9.74286766973319E-23  -2.72015979765145E-08  -2.70876895625957E-08  -2.89762899602426E-18
      2.49267389402399E-09
      0.00000000000000E+00  -3.29734546390858E-11   0.00000000000000E+00  -3.73377480856934E-12   5.94268377629459E-22
      3.29771615234768E-08   3.29734277486688E-08  -6.92865452075105E-19  -2.93940787954301E-01  -2.93940787946820E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.48068622085338E-09   0.00000000000000E+00  -7.48068622085338E-09
      3.44940794023101E-18  -2.12414187451999E-01  -2.04382566253240E-01   0.00000000000000E+00   8.29385914690966E-11
     -8.91177072223917E-23  -2.55756801192844E-08  -2.54927415278154E-08  -2.75654248815590E-18
      2.51267389402399E-09
      0.00000000000000E+00  -3.12603666006910E-11   0.00000000000000E+00  -4.22578533296784E-12   5.61070095758369E-22
      3.12645857098872E-08   3.12603599245548E-08  -6.85108589281418E-19  -2.99544239900689E-01  -2.99544239893233E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.45541406689958E-09   0.00000000000000E+00  -7.45541406689958E-09
      3.30029965889302E-18  -1.50897031251970E-01  -1.43397062379477E-01   0.00000000000000E+00   5.64378661178095E-11
     -8.15438082884303E-23  -2.38613837237729E-08  -2.38049458576551E-08  -2.61519106961160E-18
      2.53267389402399E-09
      0.00000000000000E+00  -2.95108162016248E-11   0.00000000000000E+00  -4.31497216858638E-12   5.22411945758774E-22
      2.95151053505202E-08   2.95107903783522E-08  -6.76845750085684E-19  -3.05374403732144E-01  -3.05374403724754E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.39049853481118E-09   0.00000000000000E+00  -7.39049853481118E-09
      3.15248968819679E-18  -9.74187743873482E-02  -9.04495099570314E-02   0.00000000000000E+00   3.85712315176546E-11
     -5.03614101815919E-23  -2.21588630750587E-08  -2.21202918435411E-08  -2.47564393811111E-18
      2.54267389402399E-09
      0.00000000000000E+00  -2.82057024859059E-11   0.00000000000000E+00  -6.43004465427168E-12   5.00160918003622E-22
      2.82121119867718E-08   2.82056819421180E-08  -6.72231930744213E-19  -3.08459568887474E-01  -3.08459568880131E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34369944142609E-09   0.00000000000000E+00  -7.34369944142609E-09
      3.07905269378253E-18  -7.39420962026051E-02  -6.73692539680532E-02   0.00000000000000E+00   3.10988955448963E-11
      7.28303708879252E-24  -2.08930813962367E-08  -2.08619825006918E-08  -2.40682076303832E-18
      2.55617389402399E-09
      0.00000000000000E+00  -2.62860556335314E-11   0.00000000000000E+00  -7.00105697026733E-12   4.82399631838408E-22
      2.62930583154320E-08   2.62860572584623E-08  -6.61851286190303E-19  -3.14120264423204E-01  -3.14120264416051E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.15329142920366E-09   0.00000000000000E+00  -7.15329142920366E-09
      2.98248325948828E-18  -5.00950777326572E-02  -4.40670288286055E-02   0.00000000000000E+00   2.36610527312362E-11
      1.34686016665671E-22  -1.91564268819899E-08  -1.91327658292586E-08  -2.32063197329798E-18
      2.57439889402399E-09
      0.00000000000000E+00  -2.37306595102063E-11   0.00000000000000E+00  -6.89564495246549E-12   4.87813147336434E-22
      2.37375180401495E-08   2.37306223951975E-08  -6.38985187514216E-19  -3.24881939784807E-01  -3.24881939777980E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.82766370474837E-09   0.00000000000000E+00  -6.82766370474837E-09
      2.85804908846925E-18  -3.16494423375956E-02  -2.63239083567207E-02   0.00000000000000E+00   1.63366707407253E-11
      3.29864872890023E-22  -1.69192953611902E-08  -1.69029586904492E-08  -2.21906390095503E-18
      2.59439889402399E-09
      0.00000000000000E+00  -2.17553547470841E-11   0.00000000000000E+00  -4.84454710879288E-12   5.07142515238091E-22
      2.17602224643497E-08   2.17553779172414E-08  -6.07722081671206E-19  -3.38827605430178E-01  -3.38827605423631E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.54703939361895E-09   0.00000000000000E+00  -6.54703939361895E-09
      2.72710830059686E-18  -2.19154694067348E-02  -1.71238408970389E-02   0.00000000000000E+00   1.03845134577522E-11
      5.05387839868152E-22  -1.52187230370807E-08  -1.52083385236225E-08  -2.11938621892566E-18
      2.61439889402399E-09
      0.00000000000000E+00  -2.05598118028537E-11   0.00000000000000E+00  -2.91899006816056E-12   5.14399284718565E-22
      2.05626941955722E-08   2.05597752055045E-08  -5.75211799807698E-19  -3.53178550924800E-01  -3.53178550918429E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.37064602889247E-09   0.00000000000000E+00  -6.37064602889247E-09
      2.59969538001901E-18  -1.69975079266250E-02  -1.25269910633424E-02   0.00000000000000E+00   6.87704408730601E-12
      6.13612564548535E-22  -1.41960062207001E-08  -1.41891291766121E-08  -2.02448358021132E-18
      2.63439889402399E-09
      0.00000000000000E+00  -1.97178710968723E-11   0.00000000000000E+00  -2.04622472623495E-12   4.99619260162995E-22
      1.97198752196338E-08   1.97178289949081E-08  -5.43635322272640E-19  -3.67185356409906E-01  -3.67185356403659E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.24634401197355E-09   0.00000000000000E+00  -6.24634401197355E-09
      2.47476849977954E-18  -1.40868380410971E-02  -9.84242238585972E-03   0.00000000000000E+00   5.26270871119291E-12
      6.57578779784098E-22  -1.34767476916464E-08  -1.34714849829345E-08  -1.93113317750690E-18
      2.65439889402399E-09
      0.00000000000000E+00  -1.90221472125253E-11   0.00000000000000E+00  -1.68701298316530E-12   4.64624894349602E-22
      1.90238445883381E-08   1.90221575753554E-08  -5.13407715880600E-19  -3.80707435582604E-01  -3.80707435576461E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.14320847496965E-09   0.00000000000000E+00  -6.14320847496965E-09
      2.35190433028015E-18  -1.21275685243019E-02  -8.06983793209454E-03   0.00000000000000E+00   4.47786255398772E-12
      6.49696623737762E-22  -1.28834269629404E-08  -1.28789491003858E-08  -1.83849661439955E-18
      2.67439889402399E-09
      0.00000000000000E+00  -1.84380146838854E-11   0.00000000000000E+00  -1.41416658279596E-12   4.15357837312775E-22
      1.84394193607622E-08   1.84380051941798E-08  -4.84286024185065E-19  -3.93816695906804E-01  -3.93816695900749E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.05496840987293E-09   0.00000000000000E+00  -6.05496840987293E-09
      2.23080496208269E-18  -1.07171957591000E-02  -6.81570800978810E-03   0.00000000000000E+00   3.94892923703802E-12
      6.04156380884109E-22  -1.23869857135445E-08  -1.23830367843069E-08  -1.74651893789763E-18
      2.69439889402399E-09
      0.00000000000000E+00  -1.79818218741756E-11   0.00000000000000E+00  -1.10029940574804E-12   3.57947844685753E-22
      1.79829012978946E-08   1.79818009984892E-08  -4.55740895025080E-19  -4.06680102518750E-01  -4.06680102512748E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.00176683046979E-09   0.00000000000000E+00  -6.00176683046979E-09
      2.11076962547330E-18  -9.66339462884940E-03  -5.88887739516309E-03   0.00000000000000E+00   3.53998530144073E-12
      5.34376278724196E-22  -1.19835741533214E-08  -1.19800341680194E-08  -1.65502873044822E-18
      2.71439889402399E-09
      0.00000000000000E+00  -1.78429526315178E-11   0.00000000000000E+00  -3.17479207841873E-13   2.98142401966291E-22
      1.78433024427699E-08   1.78429849635623E-08  -4.26305594260657E-19  -4.19858633131073E-01  -4.19858633124930E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.14328391586159E-09   0.00000000000000E+00  -6.14328391586159E-09
      1.98790394715606E-18  -8.88931056241007E-03  -5.20311531850984E-03   0.00000000000000E+00   3.19665058916836E-12
      4.52310887465509E-22  -1.17028976982903E-08  -1.16997010477007E-08  -1.56159835289541E-18
      2.73439889402399E-09
      0.00000000000000E+00  -1.81205074273590E-11   0.00000000000000E+00   7.09215970828697E-13   2.39070835763639E-22
      1.81197216795036E-08   1.81204308954746E-08  -3.94471264848210E-19  -4.33951558354978E-01  -4.33951558348443E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.53545596470097E-09   0.00000000000000E+00  -6.53545596470097E-09
      1.85719482786205E-18  -8.35042591862451E-03  -4.70037476795368E-03   0.00000000000000E+00   2.85794258754474E-12
      3.65485509916068E-22  -1.15878328733616E-08  -1.15849749307737E-08  -1.46272356301384E-18
      2.75439889402399E-09
      0.00000000000000E+00  -1.83672942362356E-11   0.00000000000000E+00   6.35502801294820E-13   1.81496396797589E-22
      1.83666134263213E-08   1.83672489291228E-08  -3.61216582950163E-19  -4.48538946580747E-01  -4.48538946573946E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.80146282297682E-09   0.00000000000000E+00  -6.80146282297682E-09
      1.72116557140251E-18  -7.92515387277790E-03  -4.28114619997253E-03   0.00000000000000E+00   2.59993255029387E-12
      2.77740295356168E-22  -1.15683860386966E-08  -1.15657861061461E-08  -1.35994898845235E-18
      2.77439889402399E-09
      0.00000000000000E+00  -1.85035918262516E-11   0.00000000000000E+00   3.62077192921989E-13   1.28754838791855E-22
      1.85031928917379E-08   1.85035549689310E-08  -3.27518896683557E-19  -4.63233242976185E-01  -4.63233242969266E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.91869645274535E-09   0.00000000000000E+00  -6.91869645274535E-09
      1.58279164234760E-18  -7.57398152198874E-03  -3.92396263686030E-03   0.00000000000000E+00   2.40181776218736E-12
      1.95680842904160E-22  -1.15872603339480E-08  -1.15848585161856E-08  -1.25527274566405E-18
      2.78439889402399E-09
      0.00000000000000E+00  -1.86183059030238E-11   0.00000000000000E+00   5.89500912360657E-13   1.03392366493998E-22
      1.86177468665786E-08   1.86183363674910E-08  -3.10675906919928E-19  -4.70584604124454E-01  -4.70584604117457E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.99702819404786E-09   0.00000000000000E+00  -6.99702819404786E-09
      1.51282136040712E-18  -7.44149814090882E-03  -3.77999405731243E-03   0.00000000000000E+00   2.16527745646565E-12
      1.55553726416131E-22  -1.16234734508997E-08  -1.16213081734431E-08  -1.20214545348720E-18
      2.79789889402399E-09
      0.00000000000000E+00  -1.87847285668438E-11   0.00000000000000E+00   6.31534646102321E-13   7.51459508695945E-23
      1.87841341052106E-08   1.87847656398567E-08  -2.88011043742568E-19  -4.80460836043462E-01  -4.80460836036463E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.99827281085719E-09   0.00000000000000E+00  -6.99827281085719E-09
      1.41834467746055E-18  -7.33430487545848E-03  -3.62075484725070E-03   0.00000000000000E+00   1.65991304831373E-12
      1.10845609303319E-22  -1.17881527420480E-08  -1.17864928289995E-08  -1.13033363371798E-18
      2.81612389402399E-09
      0.00000000000000E+00  -1.86381443662606E-11   0.00000000000000E+00  -3.73792053597840E-13   4.71199974434874E-23
      1.86384837910823E-08   1.86381099990287E-08  -2.59471523962737E-19  -4.92909719172327E-01  -4.92909719165699E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62861240483538E-09   0.00000000000000E+00  -6.62861240483538E-09
      1.29753821638243E-18  -7.18967374565357E-03  -3.40586020942402E-03   0.00000000000000E+00   1.43022072729994E-12
      6.65134240867971E-23  -1.20109278149208E-08  -1.20094975941934E-08  -1.03806669241969E-18
      2.83612389402399E-09
      0.00000000000000E+00  -1.72641470976360E-11   0.00000000000000E+00  -3.37004692338894E-12   2.66764022379887E-23
      1.72674981599973E-08   1.72641281130739E-08  -2.35915545649317E-19  -5.03200240615883E-01  -5.03200240610745E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.13718635552142E-09   0.00000000000000E+00  -5.13718635552142E-09
      1.19479448927200E-18  -6.91977546353513E-03  -3.09895685846560E-03   0.00000000000000E+00   1.19762939801964E-12
      3.45557515987776E-23  -1.21281393869505E-08  -1.21269417575525E-08  -9.58878943622681E-19
      2.85612389402399E-09
      0.00000000000000E+00  -1.36698033070195E-11   0.00000000000000E+00  -8.85420286411294E-12   1.41318607001117E-23
      1.36786998289717E-08   1.36698456261076E-08  -2.29575076814242E-19  -5.05855976430018E-01  -5.05855976428496E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52134054986592E-09   0.00000000000000E+00  -1.52134054986592E-09
      1.16436767827468E-18  -6.47452781120603E-03  -2.64691311535231E-03   0.00000000000000E+00   3.76836957439425E-13
      1.56609207701989E-23  -1.21488819131993E-08  -1.21485050762419E-08  -9.34792601460439E-19
      2.87612389402399E-09
      0.00000000000000E+00  -7.35630422663686E-12   0.00000000000000E+00  -1.55724708226673E-11   6.16417632375204E-24
      7.37186927666713E-09   7.35629680584446E-09  -2.53120110390779E-19  -4.95330109087682E-01  -4.95330109092465E-01
      0.00000000000000E+00   0.00000000000000E+00   4.78234283062355E-09   0.00000000000000E+00   4.78234283062355E-09
      1.26001453488715E-18  -5.83548524501903E-03  -2.01097698338765E-03   0.00000000000000E+00  -1.34374288797492E-12
      4.47280172865568E-24  -1.21372958935800E-08  -1.21386396364680E-08  -1.00689442449637E-18
      2.89612389402399E-09
      0.00000000000000E+00   3.99249072641119E-13   0.00000000000000E+00  -1.91265899080118E-11  -1.01852344219747E-24
     -3.80092198342349E-10  -3.99218788250362E-10  -3.17875323301336E-19  -4.67517273331824E-01  -4.67517273344337E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25133735508156E-08   0.00000000000000E+00   1.25133735508156E-08
      1.51028200590346E-18  -5.09707791863237E-03  -1.28029169597772E-03   0.00000000000000E+00  -4.06805271704532E-12
     -5.67722645897532E-24  -1.21100867098483E-08  -1.21141547625653E-08  -1.19240668260213E-18
      2.91612389402399E-09
      0.00000000000000E+00   6.85584225359304E-12   0.00000000000000E+00  -1.60034224987220E-11  -1.24072341692915E-23
     -6.83986759144438E-09  -6.85587101394312E-09  -4.30272445195642E-19  -4.21505362878516E-01  -4.21505362897437E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89213665178224E-08   0.00000000000000E+00   1.89213665178224E-08
      1.88870933625991E-18  -4.47462740122249E-03  -6.73168239298022E-04   0.00000000000000E+00  -8.19085266047221E-12
     -2.45190251861029E-23  -1.20573046512188E-08  -1.20654955038793E-08  -1.45843689106427E-18
      2.93612389402399E-09
      0.00000000000000E+00   9.60466339347711E-12   0.00000000000000E+00  -6.96107549682087E-12  -2.97246163834485E-23
     -9.59764753924551E-09  -9.60460861474236E-09  -5.87192591377573E-19  -3.59111537900149E-01  -3.59111537921709E-01
      0.00000000000000E+00   0.00000000000000E+00   2.15602168108747E-08   0.00000000000000E+00   2.15602168108747E-08
      2.31991367247741E-18  -4.42964124059776E-03  -6.62807601047501E-04   0.00000000000000E+00  -1.52494111717394E-11
     -5.61957780584510E-23  -1.19403587849606E-08  -1.19556081961324E-08  -1.73272108109983E-18
      2.95612389402399E-09
      0.00000000000000E+00   8.72681139524757E-12   0.00000000000000E+00   1.86610792980368E-12  -3.98985795032610E-23
     -8.72869648025280E-09  -8.72683037232304E-09  -7.61322361029076E-19  -2.86689354397302E-01  -2.86689354417468E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01659722430599E-08   0.00000000000000E+00   2.01659722430599E-08
      2.72323311733860E-18  -7.78038739948812E-03  -4.17628078587911E-03   0.00000000000000E+00  -2.67276338184300E-11
     -7.49743020097064E-23  -1.14124142369182E-08  -1.14391418707367E-08  -1.96191075630953E-18
      2.97612389402399E-09
      0.00000000000000E+00   7.34702790817889E-12   0.00000000000000E+00   3.01607390143367E-12  -4.27015458872219E-23
     -7.35004663178575E-09  -7.34703055788436E-09  -9.14558903453317E-19  -2.15966499349911E-01  -2.15966499367231E-01
      0.00000000000000E+00   0.00000000000000E+00   1.73202929946273E-08   0.00000000000000E+00   1.73202929946273E-08
      3.06963897723115E-18  -2.07973806580369E-02  -1.76551273954660E-02   0.00000000000000E+00  -4.30820374005336E-11
     -8.26371296558759E-23  -9.93018039934234E-09  -9.97326243674295E-09  -2.15508007377783E-18
      2.99612389402399E-09
      0.00000000000000E+00   6.20760209838232E-12   0.00000000000000E+00   2.34615023064790E-12  -4.45232153048270E-23
     -6.20996681634454E-09  -6.20762066611394E-09  -1.03975277809395E-18  -1.52398458487151E-01  -1.52398458501883E-01
      0.00000000000000E+00   0.00000000000000E+00   1.47319119808062E-08   0.00000000000000E+00   1.47319119808062E-08
      3.36427721684727E-18  -4.23208417095210E-02  -3.96351108497186E-02   0.00000000000000E+00  -6.71335996731099E-11
     -9.10469586067883E-23  -8.45715771501908E-09  -8.52429131469228E-09  -2.32452443875332E-18
      3.01612389402399E-09
      0.00000000000000E+00   5.11143515981049E-12   0.00000000000000E+00   2.17817369094907E-12  -4.61294973743412E-23
     -5.11361420878182E-09  -5.11143603509092E-09  -1.14104478073296E-18  -9.68170234904194E-02  -9.68170235028832E-02
      0.00000000000000E+00   0.00000000000000E+00   1.24637220830951E-08   0.00000000000000E+00   1.24637220830951E-08
      3.61355165850918E-18  -6.94662148791928E-02  -6.71497414841264E-02   0.00000000000000E+00  -9.66544368323418E-11
     -9.97472315649538E-23  -7.25563161117169E-09  -7.35228604800413E-09  -2.47250687777621E-18
      3.02612389402399E-09
      0.00000000000000E+00   4.31422284084915E-12   0.00000000000000E+00   3.38003760447585E-12  -4.68068563778543E-23
     -4.31758450984106E-09  -4.31420447223663E-09  -1.18356726880397E-18  -7.22910023538945E-02  -7.22910023648341E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09395767213447E-08   0.00000000000000E+00   1.09395767213447E-08
      3.72294742572262E-18  -8.46911745512062E-02  -8.26037183770867E-02   0.00000000000000E+00  -1.18739473784625E-10
     -1.04147517422895E-22  -6.50663277532344E-09  -6.62537224910816E-09  -2.53938015691865E-18
      3.03287389402399E-09
      0.00000000000000E+00   3.65082830399919E-12   0.00000000000000E+00   4.33222724047344E-12  -4.71829963695580E-23
     -3.65511952803253E-09  -3.65078730079211E-09  -1.20775632138965E-18  -5.79904898784009E-02  -5.79904898881524E-02
      0.00000000000000E+00   0.00000000000000E+00   9.75157180951064E-09   0.00000000000000E+00   9.75157180951064E-09
      3.78877053543682E-18  -9.57589878892405E-02  -9.38368091913486E-02   0.00000000000000E+00  -1.27463588662310E-10
     -1.07069731569920E-22  -5.97332092005590E-09  -6.10078450871832E-09  -2.58101421404717E-18
      3.04198639402399E-09
      0.00000000000000E+00   2.75653609780950E-12   0.00000000000000E+00   4.43236845423952E-12  -4.75496087741319E-23
     -2.76094150650314E-09  -2.75650913804894E-09  -1.23223367609077E-18  -4.31945261638962E-02  -4.31945261720816E-02
      0.00000000000000E+00   0.00000000000000E+00   8.18538440972159E-09   0.00000000000000E+00   8.18538440972159E-09
      3.86335985087041E-18  -1.11986350045870E-01  -1.10275869753197E-01   0.00000000000000E+00  -1.28977268526655E-10
     -1.10789759488329E-22  -5.29989800314579E-09  -5.42887527167256E-09  -2.63112617477964E-18
      3.05428826902399E-09
      0.00000000000000E+00   1.73228358847116E-12   0.00000000000000E+00   3.84451212348019E-12  -4.78339994927546E-23
     -1.73612400089804E-09  -1.73227948877461E-09  -1.25266785625245E-18  -3.04724688257568E-02  -3.04724688321123E-02
      0.00000000000000E+00   0.00000000000000E+00   6.35547232749572E-09   0.00000000000000E+00   6.35547232749572E-09
      3.94154407700922E-18  -1.35553249978843E-01  -1.34096616091029E-01   0.00000000000000E+00  -1.27358611844477E-10
     -1.15372041160826E-22  -4.49583422687669E-09  -4.62319283872128E-09  -2.68887622075677E-18
      3.07089580027399E-09
      0.00000000000000E+00   9.00721337794215E-13   0.00000000000000E+00   2.34249754218747E-12  -4.80071382300249E-23
     -9.03038508590324E-10  -9.00696011048185E-10  -1.26645917721955E-18  -2.14683185568364E-02  -2.14683185615839E-02
      0.00000000000000E+00   0.00000000000000E+00   4.74754368824613E-09   0.00000000000000E+00   4.74754368824613E-09
      4.02038905717250E-18  -1.68111256657628E-01  -1.66899225437739E-01   0.00000000000000E+00  -1.25769815563109E-10
     -1.20944731677094E-22  -3.72107786163475E-09  -3.84684767719798E-09  -2.75392987995296E-18
      3.09089580027399E-09
      0.00000000000000E+00   4.49579988630843E-13   0.00000000000000E+00   1.06143808405332E-12  -4.80899692008613E-23
     -4.50587238147141E-10  -4.49525800063136E-10  -1.27408007306808E-18  -1.61040202736077E-02  -1.61040202772578E-02
      0.00000000000000E+00   0.00000000000000E+00   3.65012529844945E-09   0.00000000000000E+00   3.65012529844945E-09
      4.09339156314149E-18  -2.05278145511364E-01  -2.04269726363146E-01   0.00000000000000E+00  -1.25182860721200E-10
     -1.26995037168557E-22  -3.07541663766499E-09  -3.20059949838632E-09  -2.81931149007342E-18
      3.11089580027399E-09
      0.00000000000000E+00   2.63686240522809E-13   0.00000000000000E+00   4.38199721746709E-13  -4.81244010864914E-23
     -2.64095128639399E-10  -2.63656928917700E-10  -1.27801723239883E-18  -1.31117419892819E-02  -1.31117419921847E-02
      0.00000000000000E+00   0.00000000000000E+00   2.90289806918812E-09   0.00000000000000E+00   2.90289806918812E-09
      4.15144952452526E-18  -2.37939004367238E-01  -2.37107450812585E-01   0.00000000000000E+00  -1.20447261157365E-10
     -1.32311796670811E-22  -2.51879387911287E-09  -2.63924114027037E-09  -2.87343229212642E-18
      3.13089580027399E-09
      0.00000000000000E+00   1.88281711275430E-13   0.00000000000000E+00   1.77753405588206E-13  -4.81401378991215E-23
     -1.88495754175055E-10  -1.88318000769515E-10  -1.28047538133280E-18  -1.11931149341769E-02  -1.11931149364648E-02
      0.00000000000000E+00   0.00000000000000E+00   2.28791265260422E-09   0.00000000000000E+00   2.28791265260422E-09
      4.19720777757734E-18  -2.64539026268324E-01  -2.63877499532804E-01   0.00000000000000E+00  -1.06872669240689E-10
     -1.36701028017480E-22  -1.99272198259393E-09  -2.09959465183476E-09  -2.91673239624454E-18
      3.15089580027399E-09
      0.00000000000000E+00   1.53839934822607E-13   0.00000000000000E+00   8.21894055502948E-14  -4.81471196529262E-23
     -1.53935720340447E-10  -1.53853530934945E-10  -1.28226602525289E-18  -9.85587468028641E-03  -9.85587468204114E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75472586246887E-09   0.00000000000000E+00   1.75472586246887E-09
      4.23230229482672E-18  -2.84750166894120E-01  -2.84245774919841E-01   0.00000000000000E+00  -8.66002120865671E-11
     -1.40073545368333E-22  -1.51427211944722E-09  -1.60087233153393E-09  -2.95003626957382E-18
      3.17089580027399E-09
      0.00000000000000E+00   1.35746521592725E-13   0.00000000000000E+00   4.44367688930099E-14  -4.81494197803260E-23
     -1.35784869636673E-10  -1.35740432867829E-10  -1.28371106039157E-18  -8.88357238314541E-03  -8.88357238445199E-03
      0.00000000000000E+00   0.00000000000000E+00   1.30658658662660E-09   0.00000000000000E+00   1.30658658662660E-09
      4.25843402655925E-18  -2.99091890971040E-01  -2.98722990814148E-01   0.00000000000000E+00  -6.37909881474410E-11
     -1.42470725420844E-22  -1.10705516561114E-09  -1.17084615375873E-09  -2.97472296616768E-18
      3.19089580027399E-09
      0.00000000000000E+00   1.25735445237104E-13   0.00000000000000E+00   2.56381733049216E-14  -4.81492984923518E-23
     -1.25780042778691E-10  -1.25754404605434E-10  -1.28496879900503E-18  -8.15503815030040E-03  -8.15503815123765E-03
      0.00000000000000E+00   0.00000000000000E+00   9.37246129789660E-10   0.00000000000000E+00   9.37246129789660E-10
      4.27717894915505E-18  -3.08339924453987E-01  -3.08084249951228E-01   0.00000000000000E+00  -4.13339121724683E-11
     -1.43994994848510E-22  -7.70157813011564E-10  -8.11491725184177E-10  -2.99221015015001E-18
      3.21089580027399E-09
      0.00000000000000E+00   1.15356989932654E-13   0.00000000000000E+00   2.80978285063465E-14  -4.81459982838121E-23
     -1.15344223055076E-10  -1.15316125226618E-10  -1.28602749258803E-18  -7.63356996960912E-03  -7.63356997028792E-03
      0.00000000000000E+00   0.00000000000000E+00   6.78804703205676E-10   0.00000000000000E+00   6.78804703205676E-10
      4.29075504321916E-18  -3.14084231532097E-01  -3.13906698381036E-01   0.00000000000000E+00  -2.46429481843455E-11
     -1.44898943750162E-22  -5.38845629794659E-10  -5.63488577979149E-10  -3.00472755063113E-18
      3.23089580027399E-09
      0.00000000000000E+00   9.96515398701665E-14   0.00000000000000E+00   4.33141473332539E-14  -4.81373639475426E-23
     -9.96854031362322E-11  -9.96420889889471E-11  -1.28678204993063E-18  -7.31213093416976E-03  -7.31213093475893E-03
      0.00000000000000E+00   0.00000000000000E+00   5.89164571331090E-10   0.00000000000000E+00   5.89164571331090E-10
      4.30253833464578E-18  -3.18972577762455E-01  -3.18818349885772E-01   0.00000000000000E+00  -2.01471513860770E-11
     -1.45626947531219E-22  -4.69375330955916E-10  -4.89522482342139E-10  -3.01575628471515E-18
      3.25089580027399E-09
      0.00000000000000E+00   9.06507556238289E-14   0.00000000000000E+00   2.80621189958700E-14  -4.81265584871520E-23
     -9.06777755068413E-11  -9.06497133878935E-11  -1.28736649741804E-18  -7.07663787688264E-03  -7.07663787747414E-03
      0.00000000000000E+00   0.00000000000000E+00   5.91503284158448E-10   0.00000000000000E+00   5.91503284158448E-10
      4.31436840032895E-18  -3.24167805615980E-01  -3.24010007364948E-01   0.00000000000000E+00  -2.17070340951744E-11
     -1.46394711781107E-22  -4.79146536675200E-10  -5.00853570770520E-10  -3.02700190291090E-18
      3.25589580027399E-09
      0.00000000000000E+00   9.24876503679794E-14   0.00000000000000E+00  -1.24122163141615E-14  -4.81243191228327E-23
     -9.24865844089649E-11  -9.24989966253272E-11  -1.28752243539747E-18  -7.01421992983811E-03  -7.01421993040025E-03
      0.00000000000000E+00   0.00000000000000E+00   5.62130715344338E-10   0.00000000000000E+00   5.62130715344338E-10
      4.31717905390567E-18  -3.25333906427434E-01  -3.25185945750217E-01   0.00000000000000E+00  -1.92129795167472E-11
     -1.46564634410451E-22  -4.50418739202288E-10  -4.69631718719181E-10  -3.02965661850820E-18
      3.26264580027399E-09
      0.00000000000000E+00   8.50482266541698E-14   0.00000000000000E+00   6.07660026560392E-14  -4.81198185682384E-23
     -8.50667881498296E-11  -8.50060221472217E-11  -1.28768349917684E-18  -6.95498273535456E-03  -6.95498273593680E-03
      0.00000000000000E+00   0.00000000000000E+00   5.82244197027168E-10   0.00000000000000E+00   5.82244197027168E-10
      4.32110920223560E-18  -3.27101422511408E-01  -3.26944763249204E-01   0.00000000000000E+00  -2.20010591802549E-11
     -1.46822873705638E-22  -4.75237115699781E-10  -4.97238174880182E-10  -3.03342570305876E-18
      3.27175830027399E-09
      0.00000000000000E+00   8.02723003193784E-14   0.00000000000000E+00   3.27702254280078E-14  -4.81134825311208E-23
     -8.03429884366581E-11  -8.03102182112782E-11  -1.28786034922957E-18  -6.88741465928031E-03  -6.88741465990897E-03
      0.00000000000000E+00   0.00000000000000E+00   6.28654913409321E-10   0.00000000000000E+00   6.28654913409321E-10
      4.32683782013405E-18  -3.29867508973024E-01  -3.29694746781889E-01   0.00000000000000E+00  -2.62847823583612E-11
     -1.47235328156450E-22  -5.22059912839567E-10  -5.48344695198075E-10  -3.03897747090447E-18
      3.27790923777399E-09
      0.00000000000000E+00   7.55882187217945E-14   0.00000000000000E+00   4.59950038776313E-14  -4.81086379681716E-23
     -7.55911766836293E-11  -7.55451816797997E-11  -1.28795148397678E-18  -6.85211666624722E-03  -6.85211666691641E-03
      0.00000000000000E+00   0.00000000000000E+00   6.69191327206624E-10   0.00000000000000E+00   6.69191327206624E-10
      4.33095397416324E-18  -3.31966105987245E-01  -3.31779069911655E-01   0.00000000000000E+00  -3.01733002765667E-11
     -1.47552202099787E-22  -5.63472845250450E-10  -5.93646145527164E-10  -3.04300249018646E-18
      3.28621300339899E-09
      0.00000000000000E+00   6.61282107894193E-14   0.00000000000000E+00   6.53493612065590E-14  -4.81006336820690E-23
     -6.61642592033286E-11  -6.60989098421702E-11  -1.28799830677906E-18  -6.82984651638335E-03  -6.82984651715261E-03
      0.00000000000000E+00   0.00000000000000E+00   7.69262954982280E-10   0.00000000000000E+00   7.69262954982280E-10
      4.33734175344540E-18  -3.35547957401700E-01  -3.35326413746025E-01   0.00000000000000E+00  -3.94745934540352E-11
     -1.48105662190531E-22  -6.63689451685738E-10  -7.03164045139922E-10  -3.04934344666635E-18
      3.29742308699274E-09
      0.00000000000000E+00   5.64845133826290E-14   0.00000000000000E+00   5.29516633839285E-14  -4.80883578667480E-23
     -5.65777284033748E-11  -5.65247767400389E-11  -1.28795901045839E-18  -6.81721751669984E-03  -6.81721751763730E-03
      0.00000000000000E+00   0.00000000000000E+00   9.37461816220735E-10   0.00000000000000E+00   9.37461816220735E-10
      4.34785077877119E-18  -3.41967422289704E-01  -3.41689864948567E-01   0.00000000000000E+00  -5.46305971093018E-11
     -1.49127334323752E-22  -8.26306442371241E-10  -8.80937039480692E-10  -3.05989176831279E-18
      3.31255669984430E-09
      0.00000000000000E+00   5.33617923175730E-14   0.00000000000000E+00   2.11959346747244E-14  -4.80720094119408E-23
     -5.34278779978288E-11  -5.34066820632022E-11  -1.28786878766494E-18  -6.76107252787723E-03  -6.76107252899325E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11601349243355E-09   0.00000000000000E+00   1.11601349243355E-09
      4.36474009490279E-18  -3.52751090539129E-01  -3.52416291808909E-01   0.00000000000000E+00  -7.10831362697631E-11
     -1.50893890570714E-22  -9.91523674100311E-10  -1.06260681037023E-09  -3.07687130723786E-18
      3.33255669984430E-09
      0.00000000000000E+00   5.98827686593074E-14   0.00000000000000E+00  -6.65039358140238E-15  -4.80541166623234E-23
     -5.98870604017886E-11  -5.98937107954181E-11  -1.28789737761100E-18  -6.55575889207526E-03  -6.55575889328479E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20952521850711E-09   0.00000000000000E+00   1.20952521850711E-09
      4.38893059927294E-18  -3.68271188954598E-01  -3.67908970107113E-01   0.00000000000000E+00  -8.13523853007578E-11
     -1.53506748927907E-22  -1.06827912241072E-09  -1.14963150771163E-09  -3.10103322166193E-18
      3.35255669984430E-09
      0.00000000000000E+00   7.41187029264741E-14   0.00000000000000E+00  -2.87785383304897E-14  -4.80424182205915E-23
     -7.41171925826627E-11  -7.41459711210413E-11  -1.28822824084421E-18  -6.16582806605451E-03  -6.16582806727521E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22069504605345E-09   0.00000000000000E+00   1.22069504605345E-09
      4.41334450019401E-18  -3.83639562489799E-01  -3.83278314553979E-01   0.00000000000000E+00  -8.50469518815955E-11
     -1.56169181551942E-22  -1.06150212305070E-09  -1.14654907493245E-09  -3.12511625934980E-18
      3.37255669984430E-09
      0.00000000000000E+00   9.24876503679794E-14   0.00000000000000E+00  -4.24612626776494E-14  -4.80380045322746E-23
     -9.24315910342762E-11  -9.24740522970019E-11  -1.28894142988196E-18  -5.55772498135433E-03  -5.55772498256045E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20612140458034E-09   0.00000000000000E+00   1.20612140458034E-09
      4.43746692828561E-18  -3.98363466814078E-01  -3.98012585414367E-01   0.00000000000000E+00  -8.60760440138163E-11
     -1.58798811371752E-22  -1.02757130826940E-09  -1.11364735228338E-09  -3.14852549840366E-18
      3.39255669984430E-09
      0.00000000000000E+00   1.05254068839826E-13   0.00000000000000E+00  -3.14338899493236E-14  -4.80382149321630E-23
     -1.05228326152080E-10  -1.05259760042078E-10  -1.28992478045619E-18  -4.80240279876097E-03  -4.80240279993958E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17860862961971E-09   0.00000000000000E+00   1.17860862961971E-09
      4.46103910087801E-18  -4.12387068226426E-01  -4.12048884038921E-01   0.00000000000000E+00  -8.60994273409547E-11
     -1.61370052936840E-22  -9.87249442236483E-10  -1.07334886957760E-09  -3.17111432042182E-18
      3.41255669984430E-09
      0.00000000000000E+00   1.04060087256128E-13   0.00000000000000E+00   2.88725962193897E-15  -4.80375516375129E-23
     -1.04074082803181E-10  -1.04071195543607E-10  -1.29089816176484E-18  -4.06796043396335E-03  -4.06796043509638E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13302828839761E-09   0.00000000000000E+00   1.13302828839761E-09
      4.48369966664596E-18  -4.25793260419361E-01  -4.25469063280082E-01   0.00000000000000E+00  -8.52745962015748E-11
     -1.63863650131052E-22  -9.43682496652314E-10  -1.02895709285405E-09  -3.19280150488112E-18
      3.43255669984430E-09
      0.00000000000000E+00   8.70688108727354E-14   0.00000000000000E+00   4.44955283296868E-14  -4.80303718466210E-23
     -8.71473444287778E-11  -8.71028489004962E-11  -1.29154616270097E-18  -3.54229834365361E-03  -3.54229834472110E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06749200256608E-09   0.00000000000000E+00   1.06749200256608E-09
      4.50504950669728E-18  -4.38680692077869E-01  -4.38371797959428E-01   0.00000000000000E+00  -8.34945159981364E-11
     -1.66258059281835E-22  -8.96894637667322E-10  -9.80389153665625E-10  -3.21350334399631E-18
      3.45255669984430E-09
      0.00000000000000E+00  -1.05621447788656E-14   0.00000000000000E+00   2.59812556015064E-13  -4.79843487357737E-23
      1.03173035355753E-11   1.05771160915424E-11  -1.29025896058347E-18  -4.19391707626147E-03  -4.19391707713843E-03
      0.00000000000000E+00   0.00000000000000E+00   8.76955551212322E-10   0.00000000000000E+00   8.76955551212322E-10
      4.52258861772153E-18  -4.51226095196376E-01  -4.50946459337728E-01   0.00000000000000E+00  -7.58017718616686E-11
     -1.68392601386080E-22  -8.11730895441925E-10  -8.87532667303762E-10  -3.23232965713806E-18
      3.47255669984430E-09
      0.00000000000000E+00  -6.10216434006808E-13   0.00000000000000E+00   1.59549633676927E-12  -4.76977396228062E-23
      6.08609886695302E-10   6.10205383032024E-10  -1.27703580606229E-18  -1.20052240325929E-02  -1.20052240324793E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.13656046990540E-10   0.00000000000000E+00  -1.13656046990540E-10
      4.52031549678172E-18  -4.64155237370939E-01  -4.63998798945434E-01   0.00000000000000E+00  -3.00674128471349E-11
     -1.69214196245017E-22  -4.66481923194179E-10  -4.96549336041483E-10  -3.24327969071943E-18
      3.49255669984430E-09
      0.00000000000000E+00  -1.50111038491982E-12   0.00000000000000E+00   2.44601546563418E-12  -4.70884833767750E-23
      1.49870991030160E-09   1.50115592576719E-09  -1.24617177587520E-18  -3.00692618213691E-02  -3.00692618198139E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.55521868293955E-09   0.00000000000000E+00  -1.55521868293955E-09
      4.48921112312292E-18  -4.77738181324954E-01  -4.77755239723221E-01   0.00000000000000E+00   3.67722635816592E-11
     -1.68146568637165E-22   1.72904935908005E-11   5.40627571722915E-11  -3.24303934724773E-18
      3.50255669984430E-09
      0.00000000000000E+00  -1.96547737624107E-12   0.00000000000000E+00   2.58838494345575E-12  -4.67062316847163E-23
      1.96293167798446E-09   1.96552006292787E-09  -1.22618740810867E-18  -4.15627880303240E-02  -4.15627880280334E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.29062574671794E-09   0.00000000000000E+00  -2.29062574671794E-09
      4.46630486565575E-18  -4.84614318002902E-01  -4.84716781873149E-01   0.00000000000000E+00   6.87429426741259E-11
     -1.67156473970859E-22   2.56362741116263E-10   3.25105683790222E-10  -3.24011745754708E-18
      3.51605669984430E-09
      0.00000000000000E+00  -2.37951345157260E-12   0.00000000000000E+00   1.84200503173201E-12  -4.61192057813592E-23
      2.37765242252297E-09   2.37949442755465E-09  -1.19393328134930E-18  -5.97397134103434E-02  -5.97397134074254E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.91800735789256E-09   0.00000000000000E+00  -2.91800735789256E-09
      4.42691176632420E-18  -4.93930946091995E-01  -4.94100655115241E-01   0.00000000000000E+00   9.31361134073843E-11
     -1.65336979889260E-22   4.45376816930564E-10   5.38512930337783E-10  -3.23297848497489E-18
      3.53428169984430E-09
      0.00000000000000E+00  -2.92093817741097E-12   0.00000000000000E+00   1.80540661531331E-12  -4.52042785195385E-23
      2.91918372906047E-09   2.92098913567574E-09  -1.14190010241502E-18  -8.81537664042702E-02  -8.81537664006172E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.65295775067211E-09   0.00000000000000E+00  -3.65295775067211E-09
      4.36033661131820E-18  -5.06390418774697E-01  -5.06621091158340E-01   0.00000000000000E+00   1.17417415419577E-10
     -1.62212580226537E-22   6.14551199577027E-10   7.31968614996442E-10  -3.21843650890318E-18
      3.53928169984430E-09
      0.00000000000000E+00  -3.23927203657226E-12   0.00000000000000E+00   3.45824275545619E-12  -4.49233292638515E-23
      3.23584159782977E-09   3.23929984058518E-09  -1.12622395586002E-18  -9.65216561351062E-02  -9.65216561310320E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.07423197243246E-09   0.00000000000000E+00  -4.07423197243246E-09
      4.33996545145604E-18  -5.09798709890386E-01  -5.10061827341889E-01   0.00000000000000E+00   1.28183398534929E-10
     -1.61270453753856E-22   7.06748733312386E-10   8.34932131847154E-10  -3.21374149559601E-18
      3.54603169984430E-09
      0.00000000000000E+00  -3.59241505113520E-12   0.00000000000000E+00   2.92617028629742E-12  -4.45173158604950E-23
      3.58942461961090E-09   3.59235078989715E-09  -1.10318063902585E-18  -1.08646146126326E-01  -1.08646146121817E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.50955936498781E-09   0.00000000000000E+00  -4.50955936498781E-09
      4.30952592574237E-18  -5.14394695506044E-01  -5.14683744126939E-01   0.00000000000000E+00   1.40544089101504E-10
     -1.59867333239458E-22   7.76664485989221E-10   9.17208575090564E-10  -3.20634528671652E-18
      3.55514419984430E-09
      0.00000000000000E+00  -4.05861893720061E-12   0.00000000000000E+00   2.86487899762331E-12  -4.38827730623747E-23
      4.05571177229785E-09   4.05857665129543E-09  -1.06934233981171E-18  -1.26094429945610E-01  -1.26094429940627E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.98284441985511E-09   0.00000000000000E+00  -4.98284441985511E-09
      4.26411975596644E-18  -5.20483804784469E-01  -5.20775092536021E-01   0.00000000000000E+00   1.51638600500431E-10
     -1.57804239855538E-22   7.72629168059450E-10   9.24267768559723E-10  -3.19477741615473E-18
      3.56744607484430E-09
      0.00000000000000E+00  -4.73514727147125E-12   0.00000000000000E+00   3.03217235104009E-12  -4.25981766682384E-23
      4.73208000214833E-09   4.73511217449933E-09  -1.02067646281230E-18  -1.50480047052060E-01  -1.50480047046667E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.39386308033719E-09   0.00000000000000E+00  -5.39386308033719E-09
      4.19776512658502E-18  -5.28160684532993E-01  -5.28368348827003E-01   0.00000000000000E+00   1.56992856526505E-10
     -1.54873767410950E-22   5.01758049311473E-10   6.58750905837823E-10  -3.17708866377271E-18
      3.58405360609430E-09
      0.00000000000000E+00  -6.13137096650007E-12   0.00000000000000E+00   4.41756440486422E-12  -3.81418553844840E-23
      6.12695184024578E-09   6.13136940465060E-09  -9.53614306312018E-19  -1.82817357715771E-01  -1.82817357710106E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.66558169709765E-09   0.00000000000000E+00  -5.66558169709765E-09
      4.10367380150104E-18  -5.36365677942559E-01  -5.36219123940271E-01   0.00000000000000E+00   1.55626673366520E-10
     -1.50831103309155E-22  -6.21414380919394E-10  -4.65787707553025E-10  -3.15005949518902E-18
      3.60405360609430E-09
      0.00000000000000E+00  -9.61522553825598E-12   0.00000000000000E+00   8.79379204283439E-12  -2.08546965780663E-23
      9.60647677125673E-09   9.61527056329954E-09  -8.76289519532391E-19  -2.18487463287717E-01  -2.18487463281855E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86208574661078E-09   0.00000000000000E+00  -5.86208574661078E-09
      3.98643208656882E-18  -5.39610069311600E-01  -5.38427977577326E-01   0.00000000000000E+00   1.55257039058483E-10
     -1.45668471220517E-22  -3.90844185574714E-09  -3.75318481668880E-09  -3.11014256703643E-18
      3.62405360609430E-09
      0.00000000000000E+00  -1.60210285795321E-11   0.00000000000000E+00   1.59379845936491E-11   1.92253769726324E-23
      1.60050782780869E-08   1.60210162626806E-08  -8.07954584636231E-19  -2.48870770969837E-01  -2.48870770963742E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.09575520114699E-09   0.00000000000000E+00  -6.09575520114699E-09
      3.86451698254588E-18  -5.30887515762939E-01  -5.27761127828141E-01   0.00000000000000E+00   1.61954304266946E-10
     -1.39681661464894E-22  -1.00872153658004E-08  -9.92526106153356E-09  -3.05656239790965E-18
      3.64405360609430E-09
      0.00000000000000E+00  -2.45678242898530E-11   0.00000000000000E+00   2.11935489274457E-11   7.35457543293379E-23
      2.45465921215686E-08   2.45677856704961E-08  -7.52927932273511E-19  -2.72950865854980E-01  -2.72950865848604E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.37667301097665E-09   0.00000000000000E+00  -6.37667301097665E-09
      3.73698352232635E-18  -5.05763667333523E-01  -5.00033270629971E-01   0.00000000000000E+00   1.72300476979270E-10
     -1.32299174780757E-22  -1.83634131364986E-08  -1.81911126595195E-08  -2.98405559005284E-18
      3.66405360609430E-09
      0.00000000000000E+00  -3.26837763379333E-11   0.00000000000000E+00   2.01571668507719E-11   1.25448803919958E-22
      3.26636388741688E-08   3.26837960410197E-08  -7.12536400045463E-19  -2.90846769495152E-01  -2.90846769488486E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66549834373037E-09   0.00000000000000E+00  -6.66549834373037E-09
      3.60367355545174E-18  -4.62871873312922E-01  -4.54675484502965E-01   0.00000000000000E+00   1.75892142981857E-10
     -1.23403910490681E-22  -2.61941898402710E-08  -2.60182976972893E-08  -2.89113715540628E-18
      3.68405360609430E-09
      0.00000000000000E+00  -3.76714047919880E-11   0.00000000000000E+00   1.24020138115904E-11   1.58752350728817E-22
      3.76589798017576E-08   3.76713818155694E-08  -6.86052535386796E-19  -3.03218800269139E-01  -3.03218800262200E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.93922004577977E-09   0.00000000000000E+00  -6.93922004577977E-09
      3.46488915453615E-18  -4.03336074314206E-01  -3.93654355027997E-01   0.00000000000000E+00   1.68455696955979E-10
     -1.13587297084327E-22  -3.09006174667454E-08  -3.07321617697896E-08  -2.77883661914935E-18
      3.70405360609430E-09
      0.00000000000000E+00  -3.81331082859302E-11   0.00000000000000E+00   1.18935184218347E-12   1.65302084564048E-22
      3.81318986390428E-08   3.81330879908852E-08  -6.71812706033234E-19  -3.10888063206857E-01  -3.10888063199666E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19096952284199E-09   0.00000000000000E+00  -7.19096952284199E-09
      3.32106976407931E-18  -3.30460323200643E-01  -3.20712185314344E-01   0.00000000000000E+00   1.50162195150041E-10
     -1.03746457989552E-22  -3.10922806631930E-08  -3.09421184680431E-08  -2.64925705804607E-18
      3.72405360609430E-09
      0.00000000000000E+00  -3.55710993415263E-11   0.00000000000000E+00  -6.28901118449735E-12   1.51862787305469E-22
      3.55774029766218E-08   3.55711139654374E-08  -6.64885518849281E-19  -3.15823881775878E-01  -3.15823881768540E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.33817700846608E-09   0.00000000000000E+00  -7.33817700846608E-09
      3.17430622390999E-18  -2.54041637486604E-01  -2.45146822052263E-01   0.00000000000000E+00   1.16443519642914E-10
     -9.36471684658436E-23  -2.83493804766142E-08  -2.82329369569713E-08  -2.50942070506071E-18
      3.74405360609430E-09
      0.00000000000000E+00  -3.28729764965808E-11   0.00000000000000E+00  -6.59505248696874E-12   1.33359880877356E-22
      3.28796471243411E-08   3.28730520718542E-08  -6.58702942003980E-19  -3.20542189074421E-01  -3.20542189067100E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32115251939045E-09   0.00000000000000E+00  -7.32115251939045E-09
      3.02788317352218E-18  -1.84745866595913E-01  -1.76695593278511E-01   0.00000000000000E+00   7.76328175844907E-11
     -8.45499003937691E-23  -2.56295323700482E-08  -2.55518995524637E-08  -2.36918023151820E-18
      3.75405360609430E-09
      0.00000000000000E+00  -3.14686704646777E-11   0.00000000000000E+00  -6.93018706522163E-12   1.23241674722467E-22
      3.14756006758558E-08   3.14686704887907E-08  -6.55821489812444E-19  -3.22834559472013E-01  -3.22834559464702E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.31052164050485E-09   0.00000000000000E+00  -7.31052164050485E-09
      2.95477795711713E-18  -1.52385161809926E-01  -1.44773926878949E-01   0.00000000000000E+00   5.88648269613417E-11
     -8.14779165162754E-23  -2.42170136752470E-08  -2.41581488482858E-08  -2.29895646730468E-18
      3.76755360609430E-09
      0.00000000000000E+00  -3.01326050725198E-11   0.00000000000000E+00  -4.89171591258953E-12   1.11825907595749E-22
      3.01375274586145E-08   3.01326357427020E-08  -6.50632248813492E-19  -3.26443935277038E-01  -3.26443935269808E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23027557193345E-09   0.00000000000000E+00  -7.23027557193345E-09
      2.85716923689603E-18  -1.13153821794735E-01  -1.05938182543987E-01   0.00000000000000E+00   4.46746235723478E-11
     -7.75671180562073E-23  -2.29470347943409E-08  -2.29023601707686E-08  -2.20653698808253E-18
      3.78577860609430E-09
      0.00000000000000E+00  -2.83330911364127E-11   0.00000000000000E+00  -4.56753503077704E-12   1.00955408519019E-22
      2.83379798044712E-08   2.83334122694405E-08  -6.40347455310831E-19  -3.32504605022671E-01  -3.32504605015582E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.08875756513212E-09   0.00000000000000E+00  -7.08875756513212E-09
      2.72797663027149E-18  -6.90850518134902E-02  -6.23917406738912E-02   0.00000000000000E+00   3.23474338152668E-11
     -6.00576520594675E-23  -2.12770021381236E-08  -2.12446547043084E-08  -2.08762917496066E-18
      3.79077860609430E-09
      0.00000000000000E+00  -2.73211458218602E-11   0.00000000000000E+00  -9.93788480752335E-12   9.81493060088201E-23
      2.73310814043421E-08   2.73211435195346E-08  -6.37011974399556E-19  -3.34321004424790E-01  -3.34321004417753E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.03637036292645E-09   0.00000000000000E+00  -7.03637036292645E-09
      2.69279477845686E-18  -5.83223544460477E-02  -5.19313610607095E-02   0.00000000000000E+00   3.13645614883990E-11
     -4.84740246493397E-23  -2.03161377180969E-08  -2.02847731566085E-08  -2.05578280405731E-18
      3.79752860609430E-09
      0.00000000000000E+00  -2.60157565719296E-11   0.00000000000000E+00  -9.53732266391054E-12   9.67192642727979E-23
      2.60252733938988E-08   2.60157360712350E-08  -6.30567028830382E-19  -3.37453223530083E-01  -3.37453223523197E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.88619085028182E-09   0.00000000000000E+00  -6.88619085028182E-09
      2.64631299021746E-18  -4.65122459299576E-02  -4.04852116145428E-02   0.00000000000000E+00   2.63474852332862E-11
     -2.65927151860723E-23  -1.91558927061863E-08  -1.91295452209531E-08  -2.01574596138708E-18
      3.80664110609430E-09
      0.00000000000000E+00  -2.43690722785359E-11   0.00000000000000E+00  -8.89976722787056E-12   9.92901081795023E-23
      2.43779353454432E-08   2.43690355782154E-08  -6.18406623661384E-19  -3.42870914689508E-01  -3.42870914682842E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66588018655826E-09   0.00000000000000E+00  -6.66588018655826E-09
      2.58557015701745E-18  -3.51256458989034E-02  -2.95480048735236E-02   0.00000000000000E+00   2.13057011941389E-11
      1.01647698978161E-23  -1.77244610928513E-08  -1.77031553916571E-08  -1.96716353335606E-18
      3.81894298109430E-09
      0.00000000000000E+00  -2.26729755165245E-11   0.00000000000000E+00  -6.77854095314833E-12   1.08476076740356E-22
      2.26797861939962E-08   2.26730076530432E-08  -5.97623117294542E-19  -3.51663173162705E-01  -3.51663173156286E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.41952998588019E-09   0.00000000000000E+00  -6.41952998588019E-09
      2.50659790157240E-18  -2.58050746070026E-02  -2.06841656395150E-02   0.00000000000000E+00   1.55417428297185E-11
      5.91341881526533E-23  -1.62690194099926E-08  -1.62534776671628E-08  -1.90897478427785E-18
      3.83555051234430E-09
      0.00000000000000E+00  -2.12886916373326E-11   0.00000000000000E+00  -4.08172409963725E-12   1.23968783493567E-22
      2.12927968080891E-08   2.12887150839896E-08  -5.66365076449811E-19  -3.64563101267432E-01  -3.64563101261227E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.20485302970471E-09   0.00000000000000E+00  -6.20485302970471E-09
      2.40355061097992E-18  -1.91340259977713E-02  -1.43816132573518E-02   0.00000000000000E+00   1.03904812852547E-11
      1.14649381173274E-22  -1.50942525355704E-08  -1.50838620542850E-08  -1.83718553453011E-18
      3.85555051234430E-09
      0.00000000000000E+00  -2.02917170149449E-11   0.00000000000000E+00  -2.42541117017556E-12   1.38223905268205E-22
      2.02941548204004E-08   2.02917294092304E-08  -5.28506917141100E-19  -3.80071413849609E-01  -3.80071413843564E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.04566993242744E-09   0.00000000000000E+00  -6.04566993242744E-09
      2.28263721233137E-18  -1.48982534573404E-02  -1.04097966107592E-02   0.00000000000000E+00   7.21143758521762E-12
      1.62417520588966E-22  -1.42532709143884E-08  -1.42460594768030E-08  -1.75413029519027E-18
      3.87555051234430E-09
      0.00000000000000E+00  -1.95294056961225E-11   0.00000000000000E+00  -1.84773435314780E-12   1.42978098005168E-22
      1.95312167205198E-08   1.95293689861668E-08  -4.92225574967631E-19  -3.94965971237017E-01  -3.94965971231089E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.92807660478366E-09   0.00000000000000E+00  -5.92807660478366E-09
      2.16407568023570E-18  -1.23752059212735E-02  -8.08988856419052E-03   0.00000000000000E+00   5.67862327480143E-12
      1.87825109448993E-22  -1.36069710046581E-08  -1.36012923813831E-08  -1.67185010526807E-18
      3.89555051234430E-09
      0.00000000000000E+00  -1.88615107671493E-11   0.00000000000000E+00  -1.61753610179962E-12   1.37376323548657E-22
      1.88631516464552E-08   1.88615341103536E-08  -4.57902890008880E-19  -4.09149439144571E-01  -4.09149439138745E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.82544103540729E-09   0.00000000000000E+00  -5.82544103540729E-09
      2.04756685952755E-18  -1.06913371625122E-02  -6.58409160209322E-03   0.00000000000000E+00   4.81403978065537E-12
      1.91476346383053E-22  -1.30409071147271E-08  -1.30360930749463E-08  -1.58966396951867E-18
      3.91555051234430E-09
      0.00000000000000E+00  -1.82760924121885E-11   0.00000000000000E+00  -1.41736766641784E-12   1.23205103951224E-22
      1.82775186315526E-08   1.82761012638863E-08  -4.25369418411628E-19  -4.22691291204140E-01  -4.22691291198407E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.73301209414825E-09   0.00000000000000E+00  -5.73301209414825E-09
      1.93290661764459E-18  -9.49550233978980E-03  -5.54358309183856E-03   0.00000000000000E+00   4.17373031697634E-12
      1.77288574716171E-22  -1.25472629000553E-08  -1.25430891697381E-08  -1.50753719923296E-18
      3.93555051234430E-09
      0.00000000000000E+00  -1.77789368496842E-11   0.00000000000000E+00  -1.20229740827059E-12   1.03505751722925E-22
      1.77800987525934E-08   1.77788964551852E-08  -3.94331238736437E-19  -4.35689856054235E-01  -4.35689856048586E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64931372475288E-09   0.00000000000000E+00  -5.64931372475288E-09
      1.81992034314953E-18  -8.61601424422186E-03  -4.79437484440804E-03   0.00000000000000E+00   3.63793306976551E-12
      1.51105165230817E-22  -1.21332206635021E-08  -1.21295827304322E-08  -1.42558910441309E-18
      3.95555051234430E-09
      0.00000000000000E+00  -1.73750955401827E-11   0.00000000000000E+00  -9.73810974850000E-13   8.16343941544337E-23
      1.73761084893277E-08   1.73751346783530E-08  -3.64450882590570E-19  -4.48263066438673E-01  -4.48263066433085E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58744209716610E-09   0.00000000000000E+00  -5.58744209716610E-09
      1.70817150120621E-18  -7.95089848617339E-03  -4.23697541728554E-03   0.00000000000000E+00   3.20443693453778E-12
      1.19238545908629E-22  -1.17908970181216E-08  -1.17876925811870E-08  -1.34372061861564E-18
      3.97555051234430E-09
      0.00000000000000E+00  -1.72865572135146E-11   0.00000000000000E+00  -1.96906683437427E-13   6.07343241458311E-23
      1.72867959597450E-08   1.72865990530616E-08  -3.34470839563342E-19  -4.60936800340096E-01  -4.60936800334368E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72842830568095E-09   0.00000000000000E+00  -5.72842830568095E-09
      1.59360293509259E-18  -7.48113337454886E-03  -3.83952369765946E-03   0.00000000000000E+00   2.79080657897596E-12
      8.73780379138803E-23  -1.15609615539597E-08  -1.15581707473806E-08  -1.25913209552924E-18
      3.99555051234430E-09
      0.00000000000000E+00  -1.76529258702355E-11   0.00000000000000E+00   9.24549557905593E-13   4.27767877682670E-23
      1.76520008094501E-08   1.76529253590081E-08  -3.02982707002080E-19  -4.74335717007993E-01  -4.74335717001836E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.15710877221004E-09   0.00000000000000E+00  -6.15710877221004E-09
      1.47046075964839E-18  -7.19960607474856E-03  -3.57764021356681E-03   0.00000000000000E+00   2.35316456451087E-12
      5.92669244352326E-23  -1.14981697513627E-08  -1.14958165867982E-08  -1.16747805264631E-18
      4.01555051234430E-09
      0.00000000000000E+00  -1.79679533188573E-11   0.00000000000000E+00   7.99399307130889E-13   2.84502100770211E-23
      1.79671936770515E-08   1.79679930763587E-08  -2.71042175639961E-19  -4.88047166607807E-01  -4.88047166601352E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.45505810841057E-09   0.00000000000000E+00  -6.45505810841057E-09
      1.34135959748018E-18  -6.98966166495760E-03  -3.36230025723307E-03   0.00000000000000E+00   2.07362936401275E-12
      3.67054287392595E-23  -1.15150085973120E-08  -1.15129349679480E-08  -1.07031742184021E-18
      4.01558957484430E-09
      0.00000000000000E+00  -1.79688717662294E-11   0.00000000000000E+00   9.36414397981007E-13   2.84221532594267E-23
      1.79679181068167E-08   1.79688545212147E-08  -2.70980385080848E-19  -4.88073811091650E-01  -4.88073811085194E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.45604174559745E-09   0.00000000000000E+00  -6.45604174559745E-09
      1.34110740834949E-18  -6.98921820212801E-03  -3.36189529771513E-03   0.00000000000000E+00   2.15460231683780E-12
      3.66610113371561E-23  -1.15149673779308E-08  -1.15128127756140E-08  -1.07012702326864E-18
      4.01564230921930E-09
      0.00000000000000E+00  -1.79705249714991E-11   0.00000000000000E+00   1.27601253020407E-12   2.83842335367139E-23
      1.79692597404150E-08   1.79705357529452E-08  -2.70897474980886E-19  -4.88109667825924E-01  -4.88109667819466E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.45831565619410E-09   0.00000000000000E+00  -6.45831565619410E-09
      1.34076683310981E-18  -6.98851437463373E-03  -3.36137825077946E-03   0.00000000000000E+00   2.40268030423835E-12
      3.66002498414423E-23  -1.15146227770699E-08  -1.15122200967657E-08  -1.06986935812892E-18
      4.01571350062555E-09
      0.00000000000000E+00  -1.79733721583525E-11   0.00000000000000E+00   1.69349016095602E-12   2.83329621255404E-23
      1.79716736173450E-08   1.79733671075060E-08  -2.70785910976758E-19  -4.88158011158039E-01  -4.88158011151576E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46266758200548E-09   0.00000000000000E+00  -6.46266758200548E-09
      1.34030674671652E-18  -6.98737104035172E-03  -3.36071411059074E-03   0.00000000000000E+00   2.81989337782930E-12
      3.65163213816096E-23  -1.15135194189204E-08  -1.15106995255425E-08  -1.06952083573976E-18
      4.01580960902399E-09
      0.00000000000000E+00  -1.79775051715269E-11   0.00000000000000E+00   1.99285356097304E-12   2.82633498470633E-23
      1.79755148026680E-08   1.79775076562290E-08  -2.70635465662641E-19  -4.88223275604394E-01  -4.88223275597925E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46972254978498E-09   0.00000000000000E+00  -6.46972254978498E-09
      1.33968495204392E-18  -6.98556817257333E-03  -3.35982963904719E-03   0.00000000000000E+00   3.29084275219630E-12
      3.63993390753745E-23  -1.15110759491706E-08  -1.15077851064183E-08  -1.06904948638128E-18
      4.01593935536188E-09
      0.00000000000000E+00  -1.79829240110221E-11   0.00000000000000E+00   2.04829040543815E-12   2.81680820986664E-23
      1.79808448525505E-08   1.79828931429559E-08  -2.70432297226052E-19  -4.88311444236168E-01  -4.88311444229688E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.47976420822866E-09   0.00000000000000E+00  -6.47976420822866E-09
      1.33884422636751E-18  -6.98286617311217E-03  -3.35859479355751E-03   0.00000000000000E+00   3.65857399784078E-12
      3.62359522484569E-23  -1.15067875087300E-08  -1.15031289347321E-08  -1.06841192914146E-18
      4.01611451291803E-09
      0.00000000000000E+00  -1.79891694531522E-11   0.00000000000000E+00   1.85505411273726E-12   2.80365776332877E-23
      1.79873534013141E-08   1.79892084554269E-08  -2.70157708838811E-19  -4.88430583060317E-01  -4.88430583053825E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.49259975611291E-09   0.00000000000000E+00  -6.49259975611291E-09
      1.33770699846115E-18  -6.97903125606764E-03  -3.35681426837209E-03   0.00000000000000E+00   3.81858428227265E-12
      3.60094274855740E-23  -1.15004272836006E-08  -1.14966086993183E-08  -1.06754928962234E-18
      4.01635097561884E-09
      0.00000000000000E+00  -1.79958741189684E-11   0.00000000000000E+00   1.50040991450303E-12   2.78543199560673E-23
      1.79944403804715E-08   1.79959407903860E-08  -2.69786452606705E-19  -4.88591581071469E-01  -4.88591581064961E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.50749570374059E-09   0.00000000000000E+00  -6.50749570374059E-09
      1.33616821845157E-18  -6.97388116692943E-03  -3.35423625413960E-03   0.00000000000000E+00   3.74784866965035E-12
      3.56996191365578E-23  -1.14921929353143E-08  -1.14884450866446E-08  -1.06638176584486E-18
      4.01667020026493E-09
      0.00000000000000E+00  -1.80026706295217E-11   0.00000000000000E+00   1.11492458480931E-12   2.76027239986505E-23
      1.80015151218096E-08   1.80026300463944E-08  -2.69284415563954E-19  -4.88809169063627E-01  -4.88809169057104E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.52331810865125E-09   0.00000000000000E+00  -6.52331810865125E-09
      1.33408581453701E-18  -6.96735527634733E-03  -3.35058782296751E-03   0.00000000000000E+00   3.48483179411573E-12
      3.52820360004949E-23  -1.14827967695394E-08  -1.14793119377452E-08  -1.06480139897306E-18
      4.01710115353715E-09
      0.00000000000000E+00  -1.80093752953379E-11   0.00000000000000E+00   8.23328044427317E-13   2.72592956953303E-23
      1.80085212606312E-08   1.80093445886756E-08  -2.68605488141016E-19  -4.89103306827078E-01  -4.89103306820539E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.53898955039976E-09   0.00000000000000E+00  -6.53898955039976E-09
      1.33126781559327E-18  -6.95957702028045E-03  -3.34563143573217E-03   0.00000000000000E+00   3.10307003450740E-12
      3.47257828142376E-23  -1.14734581083100E-08  -1.14703550382755E-08  -1.06266232745225E-18
      4.01768294045464E-09
      0.00000000000000E+00  -1.80171820980005E-11   0.00000000000000E+00   6.94001359163108E-13   2.67974927014431E-23
      1.80164566547529E-08   1.80171506561120E-08  -2.67687348361038E-19  -4.89501046868470E-01  -4.89501046861916E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.55408894078795E-09   0.00000000000000E+00  -6.55408894078795E-09
      1.32745473239142E-18  -6.95084893217426E-03  -3.33920104324344E-03   0.00000000000000E+00   2.68704418293488E-12
      3.39909792409121E-23  -1.14657487595069E-08  -1.14630617153239E-08  -1.05976738403038E-18
      4.01846835279326E-09
      0.00000000000000E+00  -1.80282034664654E-11   0.00000000000000E+00   7.11715062478835E-13   2.61859049065019E-23
      1.80274522383366E-08   1.80281639533991E-08  -2.66445799701388E-19  -4.90039015346586E-01  -4.90039015340017E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.56915103286091E-09   0.00000000000000E+00  -6.56915103286091E-09
      1.32229524011597E-18  -6.94152761946592E-03  -3.33115517549425E-03   0.00000000000000E+00   2.30887139344560E-12
      3.30266657410122E-23  -1.14613217919329E-08  -1.14590129205394E-08  -1.05584944041458E-18
      4.01899850612182E-09
      0.00000000000000E+00  -1.80362858033397E-11   0.00000000000000E+00   7.70159044923270E-13   2.57792722099231E-23
      1.80355023146133E-08   1.80362724736582E-08  -2.65607299108372E-19  -4.90402491680780E-01  -4.90402491674201E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.57834955641781E-09   0.00000000000000E+00  -6.57834955641781E-09
      1.31880770620215E-18  -6.93602993642440E-03  -3.32600081313703E-03   0.00000000000000E+00   2.14428836052999E-12
      3.23863908110503E-23  -1.14600672055975E-08  -1.14579229172370E-08  -1.05320040709378E-18
      4.01971421311539E-09
      0.00000000000000E+00  -1.80480419297023E-11   0.00000000000000E+00   8.29848083686888E-13   2.52424174482240E-23
      1.80472354073211E-08   1.80480652554048E-08  -2.64474257717597E-19  -4.90893816274080E-01  -4.90893816267490E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.58927607924312E-09   0.00000000000000E+00  -6.58927607924312E-09
      1.31409171522971E-18  -6.92972895452266E-03  -3.31942678098007E-03   0.00000000000000E+00   1.97654422415261E-12
      3.15415063078937E-23  -1.14607657203903E-08  -1.14587891761661E-08  -1.04961745751211E-18
      4.01995576422572E-09
      0.00000000000000E+00  -1.80522667876138E-11   0.00000000000000E+00   8.65234976988811E-13   2.50625387384327E-23
      1.80513686319238E-08   1.80522338669008E-08  -2.64091923592537E-19  -4.91059666361141E-01  -4.91059666354548E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.59305702993515E-09   0.00000000000000E+00  -6.59305702993515E-09
      1.31249915498367E-18  -6.92767614018773E-03  -3.31725179539382E-03   0.00000000000000E+00   1.94881541929838E-12
      3.12581127181735E-23  -1.14611256523787E-08  -1.14591768369594E-08  -1.04840723139113E-18
      4.02028185822466E-09
      0.00000000000000E+00  -1.80580530060579E-11   0.00000000000000E+00   8.90589165202015E-13   2.48220598988088E-23
      1.80571159505096E-08   1.80580065396748E-08  -2.63575614275132E-19  -4.91283674965011E-01  -4.91283674958413E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.59803750468868E-09   0.00000000000000E+00  -6.59803750468868E-09
      1.31034757454859E-18  -6.92504809695871E-03  -3.31437411412146E-03   0.00000000000000E+00   1.90704661762490E-12
      3.08789656870643E-23  -1.14618760816038E-08  -1.14599690349861E-08  -1.04677196027345E-18
      4.02072208512324E-09
      0.00000000000000E+00  -1.80658598087205E-11   0.00000000000000E+00   9.05500673965351E-13   2.45017212792715E-23
      1.80650077867416E-08   1.80659132874156E-08  -2.62878289160959E-19  -4.91586277615866E-01  -4.91586277609262E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.60434198392220E-09   0.00000000000000E+00  -6.60434198392220E-09
      1.30744016555988E-18  -6.92175185225894E-03  -3.31057298820982E-03   0.00000000000000E+00   1.84624697021560E-12
      3.03739036981831E-23  -1.14634175504618E-08  -1.14615713034915E-08  -1.04456187639892E-18
      4.02131639143631E-09
      0.00000000000000E+00  -1.80766974877110E-11   0.00000000000000E+00   9.16734893689149E-13   2.40771805165295E-23
      1.80757971214919E-08   1.80767138563856E-08  -2.61936450074018E-19  -4.91995087744782E-01  -4.91995087738170E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.61220260501310E-09   0.00000000000000E+00  -6.61220260501310E-09
      1.30351049180840E-18  -6.91766616309138E-03  -3.30556094158108E-03   0.00000000000000E+00   1.77853707225747E-12
      2.97046737176653E-23  -1.14662897884476E-08  -1.14645112513753E-08  -1.04157404173438E-18
      4.02211870495896E-09
      0.00000000000000E+00  -1.80913926456642E-11   0.00000000000000E+00   9.22167015815211E-13   2.35182458596066E-23
      1.80904512792111E-08   1.80913734462269E-08  -2.60664381959602E-19  -4.92547420306820E-01  -4.92547420300198E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62197736377324E-09   0.00000000000000E+00  -6.62197736377324E-09
      1.29819758982276E-18  -6.91258840100292E-03  -3.29894403647650E-03   0.00000000000000E+00   1.71753118348655E-12
      2.88235783853781E-23  -1.14711136136355E-08  -1.14693960824519E-08  -1.03753320786316E-18
      4.02266026658675E-09
      0.00000000000000E+00  -1.81014037220198E-11   0.00000000000000E+00   9.33161242816660E-13   2.31469719853391E-23
      1.81004637749803E-08   1.81013969362231E-08  -2.59805846333092E-19  -4.92920350996627E-01  -4.92920350989998E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62869437401361E-09   0.00000000000000E+00  -6.62869437401361E-09
      1.29460774330745E-18  -6.90921492916543E-03  -3.29452874972637E-03   0.00000000000000E+00   1.71032378552634E-12
      2.82376400322300E-23  -1.14744128859945E-08  -1.14727025622089E-08  -1.03480189697436E-18
      4.02339137478426E-09
      0.00000000000000E+00  -1.81147212089149E-11   0.00000000000000E+00   9.20114122663086E-13   2.26564595994791E-23
      1.81137876536140E-08   1.81147077677367E-08  -2.58646545002749E-19  -4.93424083004244E-01  -4.93424082997606E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.63720656084116E-09   0.00000000000000E+00  -6.63720656084116E-09
      1.28975522718222E-18  -6.90481341921357E-03  -3.28861527098884E-03   0.00000000000000E+00   1.68586886379665E-12
      2.74636123309009E-23  -1.14791870757593E-08  -1.14775012068955E-08  -1.03110868217947E-18
      4.02388487281759E-09
      0.00000000000000E+00  -1.81237219931613E-11   0.00000000000000E+00   9.18299714480811E-13   2.23299729493138E-23
      1.81227634234960E-08   1.81236817232105E-08  -2.57864176553260E-19  -4.93764157811074E-01  -4.93764157804431E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64301703880482E-09   0.00000000000000E+00  -6.64301703880482E-09
      1.28647691133825E-18  -6.90183640893667E-03  -3.28464150916672E-03   0.00000000000000E+00   1.68850565936912E-12
      2.69481004703873E-23  -1.14823531900669E-08  -1.14806646844075E-08  -1.02861273478499E-18
      4.02455109516257E-09
      0.00000000000000E+00  -1.81354781195238E-11   0.00000000000000E+00   8.97991416041931E-13   2.18975938456102E-23
      1.81346068909159E-08   1.81355048823320E-08  -2.56807853726148E-19  -4.94223441371938E-01  -4.94223441365287E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65037885982298E-09   0.00000000000000E+00  -6.65037885982298E-09
      1.28204628033921E-18  -6.89789235054561E-03  -3.27929176528256E-03   0.00000000000000E+00   1.67309600053852E-12
      2.62657661783171E-23  -1.14867991185091E-08  -1.14851260225086E-08  -1.02523842661306E-18
      4.02545049532830E-09
      0.00000000000000E+00  -1.81509998801119E-11   0.00000000000000E+00   8.70123161377006E-13   2.13291870948493E-23
      1.81500883940582E-08   1.81509585172196E-08  -2.55381723725481E-19  -4.94843744914655E-01  -4.94843744907995E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65946442754464E-09   0.00000000000000E+00  -6.65946442754464E-09
      1.27605675692940E-18  -6.89270176356993E-03  -3.27209472125576E-03   0.00000000000000E+00   1.65072834080704E-12
      2.53696896281519E-23  -1.14931448180150E-08  -1.14914940896742E-08  -1.02067503320392E-18
      4.02666468555204E-09
      0.00000000000000E+00  -1.81710220328231E-11   0.00000000000000E+00   8.37198959970238E-13   2.05891568157254E-23
      1.81701797316204E-08   1.81710169305804E-08  -2.53456658145249E-19  -4.95681504309828E-01  -4.95681504303158E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.67061684928241E-09   0.00000000000000E+00  -6.67061684928241E-09
      1.26795735916472E-18  -6.88582520981397E-03  -3.26241206682103E-03   0.00000000000000E+00   1.63264324021442E-12
      2.42042661014781E-23  -1.15020327245382E-08  -1.15004000812980E-08  -1.01450070101947E-18
      4.02830384235408E-09
      0.00000000000000E+00  -1.81967385592412E-11   0.00000000000000E+00   7.96937767194475E-13   1.96377398888466E-23
      1.81959682452051E-08   1.81967651829723E-08  -2.50858928465965E-19  -4.96812844288332E-01  -4.96812844281648E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.68419422783363E-09   0.00000000000000E+00  -6.68419422783363E-09
      1.25700091672998E-18  -6.87662985485065E-03  -3.24938191885063E-03   0.00000000000000E+00   1.62057047877735E-12
      2.27077745880195E-23  -1.15141915256162E-08  -1.15125709551374E-08  -1.00614198826402E-18
      4.03051670403684E-09
      0.00000000000000E+00  -1.82295271304243E-11   0.00000000000000E+00   7.52819281890629E-13   1.84350307381939E-23
      1.82288083371279E-08   1.82295611564098E-08  -2.47355355333827E-19  -4.98340335207744E-01  -4.98340335201043E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70048312128941E-09   0.00000000000000E+00  -6.70048312128941E-09
      1.24217367437491E-18  -6.86435574981187E-03  -3.23190677728411E-03   0.00000000000000E+00   1.60828643315664E-12
      2.08192503193034E-23  -1.15306863215540E-08  -1.15290780351209E-08  -9.94818319041080E-19
      4.03350406730856E-09
      0.00000000000000E+00  -1.82717757095398E-11   0.00000000000000E+00   7.19441054142749E-13   1.69495470186620E-23
      1.82711243353982E-08   1.82718437764524E-08  -2.42633998027035E-19  -5.00402006105865E-01  -5.00402006099145E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.71979991344821E-09   0.00000000000000E+00  -6.71979991344821E-09
      1.22209919092013E-18  -6.84845262649293E-03  -3.20876762278790E-03   0.00000000000000E+00   1.58201068103418E-12
      1.84921947849269E-23  -1.15536258736853E-08  -1.15520438630042E-08  -9.79465192893098E-19
      4.03753700772539E-09
      0.00000000000000E+00  -1.83292705150317E-11   0.00000000000000E+00   7.23749290958383E-13   1.51731835003537E-23
      1.83285777119173E-08   1.83293014612083E-08  -2.36279266577575E-19  -5.03183408869531E-01  -5.03183408862788E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74284993254644E-09   0.00000000000000E+00  -6.74284993254644E-09
      1.19490567890256E-18  -6.82953713314116E-03  -3.17901113624860E-03   0.00000000000000E+00   1.51882318572423E-12
      1.57178115605276E-23  -1.15879703518479E-08  -1.15864515286621E-08  -9.58626412324986E-19
      4.04298147728811E-09
      0.00000000000000E+00  -1.84140432074742E-11   0.00000000000000E+00   7.87495444071352E-13   1.31425484286135E-23
      1.84132738806514E-08   1.84140613760954E-08  -2.27741459608768E-19  -5.06933238804105E-01  -5.06933238797335E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.77039405269301E-09   0.00000000000000E+00  -6.77039405269301E-09
      1.15804447455507E-18  -6.81117680394824E-03  -3.14262329029548E-03   0.00000000000000E+00   1.39208862501630E-12
      1.25579338887812E-23  -1.16450594120275E-08  -1.16436673234024E-08  -9.30303014946297E-19
      4.05033151119778E-09
      0.00000000000000E+00  -1.85388602053393E-11   0.00000000000000E+00   8.56601632360889E-13   1.09590945246803E-23
      1.85379624958272E-08   1.85388190974596E-08  -2.16315407447522E-19  -5.11976473182001E-01  -5.11976473175206E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.79551544287703E-09   0.00000000000000E+00  -6.79551544287703E-09
      1.10809720561624E-18  -6.80005037164758E-03  -3.10010393513509E-03   0.00000000000000E+00   1.19877068517532E-12
      9.17940653830491E-24  -1.17445024252677E-08  -1.17433036545825E-08  -8.91781798168715E-19
      4.06025405697583E-09
      0.00000000000000E+00  -1.86586257426579E-11   0.00000000000000E+00   6.15767892319075E-13   8.78330992642564E-24
      1.86580237137634E-08   1.86586394816558E-08  -2.01228529868050E-19  -5.18679370160679E-01  -5.18679370153914E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76469976456743E-09   0.00000000000000E+00  -6.76469976456743E-09
      1.04097416252753E-18  -6.79257672650101E-03  -3.04516878032761E-03   0.00000000000000E+00   1.04598141966046E-12
      5.86515984698956E-24  -1.18949856985080E-08  -1.18939397170884E-08  -8.39745632659478E-19
      4.07364949377621E-09
      0.00000000000000E+00  -1.85276551474000E-11   0.00000000000000E+00  -4.61989643203757E-13   6.77679137572487E-24
      1.85280731120382E-08   1.85276111223950E-08  -1.82199871271902E-19  -5.27199425686288E-01  -5.27199425679812E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.47623203104663E-09   0.00000000000000E+00  -6.47623203104663E-09
      9.54222205651095E-19  -6.74684205133421E-03  -2.94982891834009E-03   0.00000000000000E+00   1.06459059584057E-12
      2.95696852706948E-24  -1.20524436819442E-08  -1.20513790913484E-08  -7.72022334379194E-19
      4.09173333345671E-09
      0.00000000000000E+00  -1.74448975404604E-11   0.00000000000000E+00  -2.93550465896848E-12   4.98843737407904E-24
      1.74478189592231E-08   1.74448834545642E-08  -1.61805044862393E-19  -5.36386398089025E-01  -5.36386398083723E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30216212667224E-09   0.00000000000000E+00  -5.30216212667224E-09
      8.58338755792321E-19  -6.57828342074079E-03  -2.75249015647016E-03   0.00000000000000E+00   1.03371543183127E-12
      6.88379748513394E-25  -1.21437550433237E-08  -1.21427213278919E-08  -6.96533710929928E-19
      4.11173333345671E-09
      0.00000000000000E+00  -1.43225438543533E-11   0.00000000000000E+00  -7.68713598090360E-12   3.40176231395053E-24
      1.43302652016604E-08   1.43225780656795E-08  -1.52995235899399E-19  -5.40245129699410E-01  -5.40245129697247E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.16297055108778E-09   0.00000000000000E+00  -2.16297055108778E-09
      8.15079344770565E-19  -6.22635169462563E-03  -2.39523704489858E-03   0.00000000000000E+00   4.70982529797316E-13
     -8.67445720308966E-25  -1.21600784971215E-08  -1.21596075145917E-08  -6.62084108871166E-19
      4.13173333345671E-09
      0.00000000000000E+00  -8.42216240193020E-12   0.00000000000000E+00  -1.45427263073128E-11   1.60454631709004E-24
      8.43674139235196E-09   8.42219866604465E-09  -1.69209406330448E-19  -5.32528816346080E-01  -5.32528816349809E-01
      0.00000000000000E+00   0.00000000000000E+00   3.72932748211401E-09   0.00000000000000E+00   3.72932748211401E-09
      8.89665894412844E-19  -5.65888878505866E-03  -1.83031929852708E-03   0.00000000000000E+00  -8.34462781905171E-13
     -2.29504994983211E-24  -1.21506916853768E-08  -1.21515261481587E-08  -7.20456488082396E-19
      4.15173333345671E-09
      0.00000000000000E+00  -4.51784262323824E-13   0.00000000000000E+00  -1.96591737213411E-11  -1.08312936030722E-24
      4.71407582197608E-10   4.51748408476266E-10  -2.21762334492960E-19  -5.08642088399094E-01  -5.08642088410776E-01
      0.00000000000000E+00   0.00000000000000E+00   1.16826205923033E-08   0.00000000000000E+00   1.16826205923033E-08
      1.12331830625891E-18  -4.91978816501725E-03  -1.09662413407293E-03   0.00000000000000E+00  -2.91284801839555E-12
     -4.87792403045567E-24  -1.21314561527610E-08  -1.21343690007794E-08  -9.01555971765949E-19
      4.17173333345671E-09
      0.00000000000000E+00   7.12614131519479E-12   0.00000000000000E+00  -1.87357185086785E-11  -6.42014452582684E-24
     -7.10735768917642E-09  -7.12609340768510E-09  -3.18362871094217E-19  -4.66994065897491E-01  -4.66994065916717E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92267623065291E-08   0.00000000000000E+00   1.92267623065291E-08
      1.50785355238949E-18  -4.16375730847198E-03  -3.51212202713379E-04   0.00000000000000E+00  -5.93135338662846E-12
     -1.23842459896423E-23  -1.20947375454575E-08  -1.21006688988441E-08  -1.18949068129527E-18
      4.19173333345671E-09
      0.00000000000000E+00   1.16086237146081E-11   0.00000000000000E+00  -1.11863732492892E-11  -1.88273449858937E-23
     -1.15974746821099E-08  -1.16086610553592E-08  -4.62296248918462E-19  -4.08579945949885E-01  -4.08579945973541E-01
      0.00000000000000E+00   0.00000000000000E+00   2.36562940523598E-08   0.00000000000000E+00   2.36562940523598E-08
      1.98097943343669E-18  -3.56274747495996E-03   2.33085093018096E-04   0.00000000000000E+00  -1.08214562032262E-11
     -3.42404737505020E-23  -1.20368115407973E-08  -1.20476329970006E-08  -1.51868318451823E-18
      4.21173333345671E-09
      0.00000000000000E+00   1.15446079327745E-11   0.00000000000000E+00  -7.88842757317181E-14  -3.50807772000419E-23
     -1.15445105043180E-08  -1.15445893885938E-08  -6.43327645015197E-19  -3.36432651952328E-01  -3.36432651975793E-01
      0.00000000000000E+00   0.00000000000000E+00   2.34652337098485E-08   0.00000000000000E+00   2.34652337098485E-08
      2.45028410763366E-18  -3.65191584734873E-03   1.03901768397880E-04   0.00000000000000E+00  -1.95607841622174E-11
     -6.50963422008073E-23  -1.19010835370924E-08  -1.19206443212547E-08  -1.80695646261846E-18
      4.23173333345671E-09
      0.00000000000000E+00   8.95109624350835E-12   0.00000000000000E+00   6.04683122575321E-12  -4.13477335870882E-23
     -8.95712066562691E-09  -8.95107383440120E-09  -8.21879337828044E-19  -2.59755787850959E-01  -2.59755787871032E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00726676049876E-08   0.00000000000000E+00   2.00726676049876E-08
      2.85173745973341E-18  -9.07765624058822E-03  -5.57359908924806E-03   0.00000000000000E+00  -3.27455796968611E-11
     -7.77407591171040E-23  -1.10888481908895E-08  -1.11215937705865E-08  -2.02985812190537E-18
      4.25173333345671E-09
      0.00000000000000E+00   7.14147938630845E-12   0.00000000000000E+00   4.03815234316874E-12  -4.34731808565424E-23
     -7.14548304586239E-09  -7.14144489351926E-09  -9.67806933203031E-19  -1.89766195434874E-01  -1.89766195451506E-01
      0.00000000000000E+00   0.00000000000000E+00   1.66327884525781E-08   0.00000000000000E+00   1.66327884525781E-08
      3.18439322878497E-18  -2.50692087267502E-02  -2.20787919685823E-02   0.00000000000000E+00  -5.12077482041335E-11
     -8.55624901792816E-23  -9.44013581085458E-09  -9.49134355905880E-09  -2.21658629558194E-18
      4.26173333345671E-09
      0.00000000000000E+00   6.28759886449007E-12   0.00000000000000E+00   3.71041403718467E-12  -4.43999610422136E-23
     -6.29132475339553E-09  -6.28761433935839E-09  -1.03135476424860E-18  -1.57061911726021E-01  -1.57061911740899E-01
      0.00000000000000E+00   0.00000000000000E+00   1.48785763159642E-08   0.00000000000000E+00   1.48785763159642E-08
      3.33317899194461E-18  -3.57784641266970E-02  -3.30717209889801E-02   0.00000000000000E+00  -7.06460074911354E-11
     -8.99010259353730E-23  -8.52031596911472E-09  -8.59096197660595E-09  -2.30182422769601E-18
      4.27523333345671E-09
      0.00000000000000E+00   5.46604769016875E-12   0.00000000000000E+00   2.47815231463192E-12  -4.55486622283923E-23
     -5.46848924223598E-09  -5.46601108992139E-09  -1.10482881922266E-18  -1.17371448768640E-01  -1.17371448781852E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32121667317894E-08   0.00000000000000E+00   1.32121667317894E-08
      3.51154324282377E-18  -5.31522597103893E-02  -5.07116871660118E-02   0.00000000000000E+00  -8.85977309645568E-11
     -9.58124537921612E-23  -7.65755791090332E-09  -7.74615564186797E-09  -2.40671442360111E-18
      4.29345833345671E-09
      0.00000000000000E+00   4.39495436485457E-12   0.00000000000000E+00   2.37090449317746E-12  -4.68201580869887E-23
     -4.39727951468559E-09  -4.39490861019246E-09  -1.18377964521944E-18  -7.23350800889933E-02  -7.23350801001361E-02
      0.00000000000000E+00   0.00000000000000E+00   1.11428591535560E-08   0.00000000000000E+00   1.11428591535560E-08
      3.71462185089733E-18  -8.05024033084776E-02  -7.83763331490521E-02   0.00000000000000E+00  -1.10219602181052E-10
     -1.03670528978384E-22  -6.63773094118242E-09  -6.74795054336357E-09  -2.53084220567789E-18
      4.29845833345671E-09
      0.00000000000000E+00   3.83672205210722E-12   0.00000000000000E+00   4.94977143997071E-12  -4.71100211617636E-23
     -3.84168416731569E-09  -3.83673439587577E-09  -1.20263010333323E-18  -6.12224494355267E-02  -6.12224494456313E-02
      0.00000000000000E+00   0.00000000000000E+00   1.01046213777597E-08   0.00000000000000E+00   1.01046213777597E-08
      3.76514495778613E-18  -8.85575628380272E-02  -8.65827349274586E-02   0.00000000000000E+00  -1.25400662713761E-10
     -1.05856325469693E-22  -6.14248631917028E-09  -6.26788698188414E-09  -2.56251485445289E-18
      4.30520833345671E-09
      0.00000000000000E+00   3.12382320190240E-12   0.00000000000000E+00   4.75492718736548E-12  -4.74220473660162E-23
     -3.12860505616658E-09  -3.12385012897926E-09  -1.22324486997196E-18  -4.88533239165336E-02  -4.88533239253911E-02
      0.00000000000000E+00   0.00000000000000E+00   8.85745804718757E-09   0.00000000000000E+00   8.85745804718757E-09
      3.82493279960464E-18  -1.00242017983630E-01  -9.84355248775408E-02   0.00000000000000E+00  -1.27791031803859E-10
     -1.08684684436701E-22  -5.60581688640449E-09  -5.73360791820846E-09  -2.60168792963269E-18
      4.31432083345671E-09
      0.00000000000000E+00   2.23834809048463E-12   0.00000000000000E+00   4.45482157194072E-12  -4.77061107107147E-23
     -2.24280351964790E-09  -2.23834869807600E-09  -1.24299103165805E-18  -3.67400083562873E-02  -3.67400083635889E-02
      0.00000000000000E+00   0.00000000000000E+00   7.30156953009990E-09   0.00000000000000E+00   7.30156953009990E-09
      3.89146835194768E-18  -1.17230601218155E-01  -1.15635327168410E-01   0.00000000000000E+00  -1.27034304608477E-10
     -1.12243436669761E-22  -4.93618652741531E-09  -5.06322083202390E-09  -2.64847732028963E-18
      4.32662270845671E-09
      0.00000000000000E+00   1.35498540802264E-12   0.00000000000000E+00   3.33999124896799E-12  -4.79165479057395E-23
     -1.35830027085159E-09  -1.35496027960267E-09  -1.25878069046468E-18  -2.67357167522190E-02  -2.67357167579085E-02
      0.00000000000000E+00   0.00000000000000E+00   5.68950246486829E-09   0.00000000000000E+00   5.68950246486829E-09
      3.96145990008268E-18  -1.41400176901414E-01  -1.40034487644681E-01   0.00000000000000E+00  -1.25133515064082E-10
     -1.16633506400066E-22  -4.20940867020136E-09  -4.33454218526556E-09  -2.70267920961801E-18
      4.34323023970671E-09
      0.00000000000000E+00   7.11613023883917E-13   0.00000000000000E+00   1.81550095825354E-12  -4.80451467291369E-23
     -7.13431677549551E-10  -7.11616176591345E-10  -1.26943315145589E-18  -1.96095043977567E-02  -1.96095044021340E-02
      0.00000000000000E+00   0.00000000000000E+00   4.37731732344312E-09   0.00000000000000E+00   4.37731732344312E-09
      4.03415633432293E-18  -1.74035840544105E-01  -1.72880882638725E-01   0.00000000000000E+00  -1.24537565610874E-10
     -1.22036417339828E-22  -3.54116358124074E-09  -3.66570114685174E-09  -2.76472318286704E-18
      4.36323023970671E-09
      0.00000000000000E+00   3.75736819915992E-13   0.00000000000000E+00   7.89598055347333E-13  -4.81089138456745E-23
     -3.76501513583420E-10  -3.75711915528121E-10  -1.27558031070087E-18  -1.51517402580528E-02  -1.51517402615099E-02
      0.00000000000000E+00   0.00000000000000E+00   3.45709913598468E-09   0.00000000000000E+00   3.45709913598468E-09
      4.10329831704262E-18  -2.10652051442076E-01  -2.09681192141569E-01   0.00000000000000E+00  -1.24124618071341E-10
     -1.27934519860337E-22  -2.95726260238515E-09  -3.08138722045662E-09  -2.82771800634175E-18
      4.38323023970671E-09
      0.00000000000000E+00   2.34846993039646E-13   0.00000000000000E+00   3.31929608160992E-13  -4.81360473807578E-23
     -2.35176336005320E-10  -2.34844406397207E-10  -1.27894317221233E-18  -1.25337427341960E-02  -1.25337427369703E-02
      0.00000000000000E+00   0.00000000000000E+00   2.77432209450573E-09   0.00000000000000E+00   2.77432209450573E-09
      4.15878475893274E-18  -2.42390476323595E-01  -2.41590355194404E-01   0.00000000000000E+00  -1.18353723399089E-10
     -1.33089833224980E-22  -2.42112396470928E-09  -2.53947768810850E-09  -2.87984158672041E-18
      4.40323023970671E-09
      0.00000000000000E+00   1.75331603329169E-13   0.00000000000000E+00   1.40904823366970E-13  -4.81482293957749E-23
     -1.75435881788968E-10  -1.75294976965649E-10  -1.28114196392819E-18  -1.08005554895910E-02  -1.08005554917773E-02
      0.00000000000000E+00   0.00000000000000E+00   2.18629295501390E-09   0.00000000000000E+00   2.18629295501390E-09
      4.20251061803302E-18  -2.67955643238029E-01  -2.67322030946128E-01   0.00000000000000E+00  -1.03694979516103E-10
     -1.37306589685095E-22  -1.90730299853204E-09  -2.01099797804828E-09  -2.92136865410483E-18
      4.42323023970671E-09
      0.00000000000000E+00   1.46676045320420E-13   0.00000000000000E+00   6.88810687715064E-14  -4.81530686335980E-23
     -1.46759320030460E-10  -1.46690438961736E-10  -1.28278971121375E-18  -9.57410808660492E-03  -9.57410808827973E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67480633043642E-09   0.00000000000000E+00   1.67480633043642E-09
      4.23600674464174E-18  -2.87235814260413E-01  -2.86754346147540E-01   0.00000000000000E+00  -8.30952535644016E-11
     -1.40520071953887E-22  -1.44502063791019E-09  -1.52811589147473E-09  -2.95321703342799E-18
      4.44323023970671E-09
      0.00000000000000E+00   1.31246129469556E-13   0.00000000000000E+00   3.84994382379761E-14  -4.81539661833071E-23
     -1.31307626149134E-10  -1.31269126710944E-10  -1.28414512699846E-18  -8.67450642138453E-03  -8.67450642263087E-03
      0.00000000000000E+00   0.00000000000000E+00   1.24634519074340E-09   0.00000000000000E+00   1.24634519074340E-09
      4.26093364845661E-18  -3.00830796758431E-01  -3.00479468619886E-01   0.00000000000000E+00  -6.05712800740218E-11
     -1.42785784362127E-22  -1.05450478395820E-09  -1.11507606403237E-09  -2.97678852145815E-18
      4.46323023970671E-09
      0.00000000000000E+00   1.22888258383671E-13   0.00000000000000E+00   2.21307049969429E-14  -4.81529410034898E-23
     -1.22902314913400E-10  -1.22880184208451E-10  -1.28534476545136E-18  -7.99490172950422E-03  -7.99490173039599E-03
      0.00000000000000E+00   0.00000000000000E+00   8.91763903077849E-10   0.00000000000000E+00   8.91763903077849E-10
      4.27876892651817E-18  -3.09489901556497E-01  -3.09247652064704E-01   0.00000000000000E+00  -3.85549385621079E-11
     -1.44204304857488E-22  -7.30328780307139E-10  -7.68883718869392E-10  -2.99342416106681E-18
      4.48323023970671E-09
      0.00000000000000E+00   1.13244560976880E-13   0.00000000000000E+00   2.63360139292974E-14  -4.81489906197057E-23
     -1.13299928681592E-10  -1.13273592667711E-10  -1.28636168503340E-18  -7.50851859370944E-03  -7.50851859435445E-03
      0.00000000000000E+00   0.00000000000000E+00   6.45011379916404E-10   0.00000000000000E+00   6.45011379916404E-10
      4.29166915411650E-18  -3.14789328678581E-01  -3.14621799666465E-01   0.00000000000000E+00  -2.24298279069409E-11
     -1.45027361623464E-22  -5.09307959341654E-10  -5.31737787248740E-10  -3.00530746908310E-18
      4.50323023970671E-09
      0.00000000000000E+00   9.76309556516009E-14   0.00000000000000E+00   4.34596899003882E-14  -4.81396868651530E-23
     -9.76989383888500E-11  -9.76554786989978E-11  -1.28707543507931E-18  -7.21658106310064E-03  -7.21658106366900E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68363626784309E-10   0.00000000000000E+00   5.68363626784309E-10
      4.30303642665218E-18  -3.19423912689107E-01  -3.19275612889884E-01   0.00000000000000E+00  -1.88296790772201E-11
     -1.45707480952482E-22  -4.51878469007939E-10  -4.70708148085305E-10  -3.01596099157288E-18
      4.52323023970671E-09
      0.00000000000000E+00   8.89057056168859E-14   0.00000000000000E+00   2.76918657391922E-14  -4.81283229210565E-23
     -8.89418136407129E-11  -8.89141217750219E-11  -1.28762405087568E-18  -7.00385460290706E-03  -7.00385460348771E-03
      0.00000000000000E+00   0.00000000000000E+00   5.80649126816255E-10   0.00000000000000E+00   5.80649126816255E-10
      4.31464940918851E-18  -3.24505797140050E-01  -3.24350871986966E-01   0.00000000000000E+00  -2.10877182410418E-11
     -1.46452280782906E-22  -4.70647286800031E-10  -4.91735005041220E-10  -3.02702535831283E-18
      4.53323023970671E-09
      0.00000000000000E+00   8.65177424494902E-14   0.00000000000000E+00   1.79906629959164E-14  -4.81224992288909E-23
     -8.65693164079215E-11  -8.65513257449737E-11  -1.28787716651369E-18  -6.90760023280083E-03  -6.90760023337871E-03
      0.00000000000000E+00   0.00000000000000E+00   5.77887733953980E-10   0.00000000000000E+00   5.77887733953980E-10
      4.32042828652805E-18  -3.27056175046364E-01  -3.26901375435472E-01   0.00000000000000E+00  -2.13224513216856E-11
     -1.46824897487573E-22  -4.70013956887345E-10  -4.91336408209178E-10  -3.03255112001435E-18
      4.54673023970671E-09
      0.00000000000000E+00   7.88946292612655E-14   0.00000000000000E+00   3.50796549917453E-14  -4.81128212589344E-23
     -7.89667067106438E-11  -7.89316270557002E-11  -1.28812093043896E-18  -6.81280597734889E-03  -6.81280597798883E-03
      0.00000000000000E+00   0.00000000000000E+00   6.39942089053273E-10   0.00000000000000E+00   6.39942089053273E-10
      4.32906750473027E-18  -3.31290982021703E-01  -3.31114229073762E-01   0.00000000000000E+00  -2.73379889912977E-11
     -1.47458777508061E-22  -5.33672473006113E-10  -5.61010461997558E-10  -3.04094657429131E-18
      4.55584273970671E-09
      0.00000000000000E+00   6.98020002777203E-14   0.00000000000000E+00   5.80325474766707E-14  -4.81046968680951E-23
     -6.98551898282701E-11  -6.97971572808415E-11  -1.28820476115165E-18  -6.77861396268868E-03  -6.77861396340844E-03
      0.00000000000000E+00   0.00000000000000E+00   7.19753872318439E-10   0.00000000000000E+00   7.19753872318439E-10
      4.33562626189177E-18  -3.34825212352925E-01  -3.34620433626076E-01   0.00000000000000E+00  -3.49985514975061E-11
     -1.47998953934498E-22  -6.14958163539986E-10  -6.49956715037640E-10  -3.04742150074012E-18
      4.56814461470671E-09
      0.00000000000000E+00   5.73111160174967E-14   0.00000000000000E+00   6.07220771438674E-14  -4.80912631719839E-23
     -5.73597251757501E-11  -5.72990030986543E-11  -1.28816980504425E-18  -6.76905676358166E-03  -6.76905676448123E-03
      0.00000000000000E+00   0.00000000000000E+00   8.99572845118497E-10   0.00000000000000E+00   8.99572845118497E-10
      4.34669269458581E-18  -3.41502157554721E-01  -3.41236782454859E-01   0.00000000000000E+00  -5.14040960630779E-11
     -1.49054872331989E-22  -7.90869745956597E-10  -8.42273842019824E-10  -3.05852288954156E-18
      4.58475214595671E-09
      0.00000000000000E+00   5.25351896827053E-14   0.00000000000000E+00   2.53330738798128E-14  -4.80730156497394E-23
     -5.25487524231581E-11  -5.25234193493264E-11  -1.28805528493922E-18  -6.71976999158978E-03  -6.71976999269210E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10231201457680E-09   0.00000000000000E+00   1.10231201457680E-09
      4.36499937581515E-18  -3.53184307701953E-01  -3.52853547855502E-01   0.00000000000000E+00  -7.00425158592999E-11
     -1.50964403159963E-22  -9.79746079367875E-10  -1.04978859522733E-09  -3.07694409087592E-18
      4.60475214595671E-09
      0.00000000000000E+00   5.88724765500246E-14   0.00000000000000E+00  -6.25430968074068E-15  -4.80548134554375E-23
     -5.89026238292351E-11  -5.89088781389639E-11  -1.28806315715652E-18  -6.52698760335697E-03  -6.52698760456134E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20436830745028E-09   0.00000000000000E+00   1.20436830745028E-09
      4.38908674196415E-18  -3.68656607794535E-01  -3.68295703483205E-01   0.00000000000000E+00  -8.11260514662908E-11
     -1.53567432931737E-22  -1.06433337784498E-09  -1.14545942931143E-09  -3.10102358480763E-18
      4.62475214595671E-09
      0.00000000000000E+00   7.33839450288139E-14   0.00000000000000E+00  -2.93466456331679E-14  -4.80429229419554E-23
     -7.34001605421203E-11  -7.34295071878015E-11  -1.28837868297378E-18  -6.14545522848836E-03  -6.14545522970667E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21830595655688E-09   0.00000000000000E+00   1.21830595655688E-09
      4.41345286109529E-18  -3.84009662200440E-01  -3.83648941268674E-01   0.00000000000000E+00  -8.50050995628424E-11
     -1.56226429590499E-22  -1.05987134980606E-09  -1.14487644936906E-09  -3.12507417812151E-18
      4.64475214595671E-09
      0.00000000000000E+00   9.20284266819418E-14   0.00000000000000E+00  -4.31193152486151E-14  -4.80383806693435E-23
     -9.19430581646324E-11  -9.19861774799290E-11  -1.28908111612612E-18  -5.54289838552058E-03  -5.54289838672512E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20454036091131E-09   0.00000000000000E+00   1.20454036091131E-09
      4.43754366831351E-18  -3.98723480582899E-01  -3.98372943567174E-01   0.00000000000000E+00  -8.60691406927009E-11
     -1.58854004998058E-22  -1.02648504273848E-09  -1.11255418343134E-09  -3.14846255218740E-18
      4.66475214595672E-09
      0.00000000000000E+00   1.05162224102618E-13   0.00000000000000E+00  -3.24232823169753E-14  -4.80386321438946E-23
     -1.05135755401358E-10  -1.05168178683723E-10  -1.29006163807105E-18  -4.78836351913219E-03  -4.78836352031002E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17782836639774E-09   0.00000000000000E+00   1.17782836639774E-09
      4.46110023564147E-18  -4.12738394426189E-01  -4.12400427223272E-01   0.00000000000000E+00  -8.61218539361172E-11
     -1.61424348711732E-22  -9.86538333777839E-10  -1.07266018771412E-09  -3.17103859757042E-18
      4.68475214595672E-09
      0.00000000000000E+00   1.04611155679373E-13   0.00000000000000E+00   1.20963625832154E-15  -4.80382303972174E-23
     -1.04612995865452E-10  -1.04611786229241E-10  -1.29104480569788E-18  -4.04715627601404E-03  -4.04715627714741E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13336915741880E-09   0.00000000000000E+00   1.13336915741880E-09
      4.48376761878984E-18  -4.26136250310383E-01  -4.25812116091026E-01   0.00000000000000E+00  -8.53416314388550E-11
     -1.63918518131515E-22  -9.43415739750476E-10  -1.02875737118950E-09  -3.19272281309197E-18
      4.70475214595672E-09
      0.00000000000000E+00   8.92730845657160E-14   0.00000000000000E+00   3.99630020893022E-14  -4.80319585878898E-23
     -8.93584752825284E-11  -8.93185122804871E-11  -1.29173598440178E-18  -3.49467434130673E-03  -3.49467434237731E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07057978822361E-09   0.00000000000000E+00   1.07057978822361E-09
      4.50517921455432E-18  -4.39013546041304E-01  -4.38704377113028E-01   0.00000000000000E+00  -8.36807648565323E-11
     -1.66317047570585E-22  -8.97580511086366E-10  -9.81261275943065E-10  -3.21344323015255E-18
      4.72475214595672E-09
      0.00000000000000E+00   5.41883949524408E-15   0.00000000000000E+00   2.23081868323176E-13  -4.79924346089275E-23
     -5.65901823114853E-12  -5.43593636287334E-12  -1.29076706544467E-18  -3.95381757511089E-03  -3.95381757601307E-03
      0.00000000000000E+00   0.00000000000000E+00   9.02189295368701E-10   0.00000000000000E+00   9.02189295368701E-10
      4.52322300046169E-18  -4.51528943215210E-01  -4.51246401949415E-01   0.00000000000000E+00  -7.69987243304737E-11
     -1.68484334295630E-22  -8.19754634675286E-10  -8.96753359005928E-10  -3.23245593501702E-18
      4.74475214595672E-09
      0.00000000000000E+00  -5.56762796952027E-13   0.00000000000000E+00   1.49473925488237E-12  -4.77267736989185E-23
      5.55311513150277E-10   5.56806252405112E-10  -1.27860568057765E-18  -1.11332105702481E-02  -1.11332105702193E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.87677275624259E-11   0.00000000000000E+00  -2.87677275624259E-11
      4.52264764591045E-18  -4.64378118878683E-01  -4.64211758307472E-01   0.00000000000000E+00  -3.39848748060823E-11
     -1.69415389906198E-22  -4.94053650036391E-10  -5.28038524842642E-10  -3.24404196533280E-18
      4.76475214595672E-09
      0.00000000000000E+00  -1.45665753211137E-12   0.00000000000000E+00   2.46206459066977E-12  -4.71317688690974E-23
      1.45425608498319E-09   1.45671814957381E-09  -1.24861336943086E-18  -2.87097313748906E-02  -2.87097313734045E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.48609573429898E-09   0.00000000000000E+00  -1.48609573429898E-09
      4.49292573122447E-18  -4.77903647826492E-01  -4.77912927947703E-01   0.00000000000000E+00   3.39208574316987E-11
     -1.68429932030941E-22  -4.54327270633122E-12   2.93775847251990E-11  -3.24431236179360E-18
      4.78475214595672E-09
      0.00000000000000E+00  -2.14558490590503E-12   0.00000000000000E+00   2.01284417918476E-12  -4.63294961573958E-23
      2.14354562070595E-09   2.14555846488509E-09  -1.20531518657157E-18  -5.34082837064606E-02  -5.34082837038965E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.56402493418690E-09   0.00000000000000E+00  -2.56402493418690E-09
      4.44164523254073E-18  -4.91623497882699E-01  -4.91755380525183E-01   0.00000000000000E+00   8.00495925214521E-11
     -1.66121141852480E-22   3.38416876780548E-10   4.18466469301834E-10  -3.23633004596915E-18
      4.78975214595672E-09
      0.00000000000000E+00  -2.41955775699508E-12   0.00000000000000E+00   3.01392964192417E-12  -4.61016912582043E-23
      2.41659490672075E-09   2.41960883636262E-09  -1.19317313495876E-18  -6.02064879383899E-02  -6.02064879354151E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.97476538582521E-09   0.00000000000000E+00  -2.97476538582521E-09
      4.42677140561160E-18  -4.95049343003507E-01  -4.95224296233611E-01   0.00000000000000E+00   9.49787916604257E-11
     -1.65434513159065E-22   4.60177757802046E-10   5.55156549462306E-10  -3.23359827065284E-18
      4.79650214595672E-09
      0.00000000000000E+00  -2.65385368161149E-12   0.00000000000000E+00   2.05045382188090E-12  -4.57812542704068E-23
      2.65176448725865E-09   2.65381494108048E-09  -1.17533310274809E-18  -7.00739836912131E-02  -7.00739836878977E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.31536560351256E-09   0.00000000000000E+00  -3.31536560351256E-09
      4.40439268778789E-18  -4.99684112404030E-01  -4.99892591187976E-01   0.00000000000000E+00   1.06752611368378E-10
     -1.64387822637835E-22   5.54798051063684E-10   6.61550662431897E-10  -3.22905958503980E-18
      4.80561464595672E-09
      0.00000000000000E+00  -2.96906481970772E-12   0.00000000000000E+00   2.04689064885540E-12  -4.53124475266817E-23
      2.96701433991846E-09   2.96906123056727E-09  -1.14875731489983E-18  -8.45321006485304E-02  -8.45321006447866E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.74378194657045E-09   0.00000000000000E+00  -3.74378194657045E-09
      4.37027747479977E-18  -5.05930858096425E-01  -5.06174999590565E-01   0.00000000000000E+00   1.20492641417363E-10
     -1.62784687123535E-22   6.54228074586130E-10   7.74720716003331E-10  -3.22152015989994E-18
      4.81176558345672E-09
      0.00000000000000E+00  -3.25947787875792E-12   0.00000000000000E+00   2.66631854831639E-12  -4.49696436864891E-23
      3.25677430095969E-09   3.25944061950796E-09  -1.12930159085296E-18  -9.49468528907010E-02  -9.49468528865782E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.12282596544756E-09   0.00000000000000E+00  -4.12282596544756E-09
      4.34491822996292E-18  -5.10140436688839E-01  -5.10412519149495E-01   0.00000000000000E+00   1.31229565054307E-10
     -1.61599963151444E-22   7.32155780885473E-10   8.63385345939618E-10  -3.21561663910996E-18
      4.82006934908172E-09
      0.00000000000000E+00  -3.65018539083874E-12   0.00000000000000E+00   2.66853681115376E-12  -4.44647572512162E-23
      3.64756166948175E-09   3.65023020629286E-09  -1.10056297956564E-18  -1.10065079712527E-01  -1.10065079707939E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.58754788468406E-09   0.00000000000000E+00  -4.58754788468406E-09
      4.30682430753504E-18  -5.15789051028971E-01  -5.16084437251412E-01   0.00000000000000E+00   1.43918446662225E-10
     -1.59833822056595E-22   7.93399231728925E-10   9.37317678390991E-10  -3.20626132796940E-18
      4.83127943267547E-09
      0.00000000000000E+00  -4.19996798776299E-12   0.00000000000000E+00   2.75795203904785E-12  -4.36400903601893E-23
      4.19721797713900E-09   4.19997592917800E-09  -1.05820344348552E-18  -1.31795365724739E-01  -1.31795365719647E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.09250158083389E-09   0.00000000000000E+00  -5.09250158083389E-09
      4.24973693911259E-18  -5.23181367150883E-01  -5.23462660577542E-01   0.00000000000000E+00   1.54521684783521E-10
     -1.57243524977940E-22   7.38003966872731E-10   8.92525651656095E-10  -3.19153349562706E-18
      4.84641304552703E-09
      0.00000000000000E+00  -5.10776137032219E-12   0.00000000000000E+00   3.26425305858310E-12  -4.15938954307590E-23
      5.10448574879966E-09   5.10775000185820E-09  -9.97705624084702E-19  -1.61755584854531E-01  -1.61755584849037E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49364735332376E-09   0.00000000000000E+00  -5.49364735332376E-09
      4.16659820692438E-18  -5.32091059409510E-01  -5.32212779899654E-01   0.00000000000000E+00   1.57583115591320E-10
     -1.53600294345086E-22   2.28314235874316E-10   3.85897351465483E-10  -3.16889258283967E-18
      4.86641304552703E-09
      0.00000000000000E+00  -7.37660191355972E-12   0.00000000000000E+00   5.83750371520497E-12  -3.26359812551192E-23
      7.37075155754838E-09   7.37658906126355E-09  -9.17993504012743E-19  -1.99481016060248E-01  -1.99481016054505E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.74306329281840E-09   0.00000000000000E+00  -5.74306329281840E-09
      4.05173694106801E-18  -5.39543544718487E-01  -5.39029155484489E-01   0.00000000000000E+00   1.55549708517093E-10
     -1.48635891888036E-22  -1.78907547696199E-09  -1.63352576844504E-09  -3.13374343705526E-18
      4.88641304552703E-09
      0.00000000000000E+00  -1.21418742588350E-11   0.00000000000000E+00   1.19224762616230E-11  -5.67842265432554E-24
      1.21299956000076E-08   1.21419180762692E-08  -8.44055369699719E-19  -2.32955547840242E-01  -2.32955547834282E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.95984338273856E-09   0.00000000000000E+00  -5.95984338273856E-09
      3.93254007341324E-18  -5.38050071044787E-01  -5.36102854489565E-01   0.00000000000000E+00   1.57516421876097E-10
     -1.43178858148440E-22  -6.33959111540669E-09  -6.18207469353074E-09  -3.08848470371352E-18
      4.90641304552703E-09
      0.00000000000000E+00  -1.97506596680554E-11   0.00000000000000E+00   1.88889321288750E-11   4.28320288556312E-23
      1.97318037276364E-08   1.97506926597653E-08  -7.81358912975044E-19  -2.60543351926913E-01  -2.60543351920695E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.21879054429879E-09   0.00000000000000E+00  -6.21879054429879E-09
      3.80816426252726E-18  -5.22298074668079E-01  -5.18035501339295E-01   0.00000000000000E+00   1.67103358478700E-10
     -1.36614300516049E-22  -1.36990054739450E-08  -1.35319021154665E-08  -3.02680534955222E-18
      4.92641304552703E-09
      0.00000000000000E+00  -2.84760933922448E-11   0.00000000000000E+00   2.16335240497939E-11   9.82336098978110E-23
      2.84543996825232E-08   2.84760332065731E-08  -7.32926133126002E-19  -2.81769096092608E-01  -2.81769096086100E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.50819202929417E-09   0.00000000000000E+00  -6.50819202929417E-09
      3.67800042194138E-18  -4.89135828909142E-01  -4.82215582110716E-01   0.00000000000000E+00   1.75519790186935E-10
     -1.28518147448531E-22  -2.21433609674657E-08  -2.19678411772789E-08  -2.94507428881538E-18
      4.94641304552703E-09
      0.00000000000000E+00  -3.54740194542979E-11   0.00000000000000E+00   1.73707953123412E-11   1.43391570733410E-22
      3.54566607771824E-08   3.54740315724949E-08  -6.98933840355646E-19  -2.97089242057812E-01  -2.97089242051022E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.79052891995501E-09   0.00000000000000E+00  -6.79052891995501E-09
      3.54218984354228E-18  -4.38509605140127E-01  -4.29473453280641E-01   0.00000000000000E+00   1.74123754511826E-10
     -1.19095315658951E-22  -2.88576264070516E-08  -2.86835026525399E-08  -2.84325600318663E-18
      4.96641304552703E-09
      0.00000000000000E+00  -3.84736685714957E-11   0.00000000000000E+00   7.47768836728659E-12   1.64922070834284E-22
      3.84661713821245E-08   3.84736490704919E-08  -6.78250116579709E-19  -3.07215767298996E-01  -3.07215767291940E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.05682396977453E-09   0.00000000000000E+00  -7.05682396977453E-09
      3.40105336414679E-18  -3.72307823145845E-01  -3.62410277593858E-01   0.00000000000000E+00   1.61929573970456E-10
     -1.09168572440162E-22  -3.15787546746878E-08  -3.14168251007174E-08  -2.72280324756708E-18
      4.98641304552703E-09
      0.00000000000000E+00  -3.71794843795045E-11   0.00000000000000E+00  -3.16495145682722E-12   1.60573222010410E-22
      3.71826596397107E-08   3.71794946882540E-08  -6.68219982743767E-19  -3.13295572330106E-01  -3.13295572322827E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27855761364859E-09   0.00000000000000E+00  -7.27855761364859E-09
      3.25548221187381E-18  -2.96108823078109E-01  -2.86688604050509E-01   0.00000000000000E+00   1.37265623700852E-10
     -9.93376076162095E-23  -3.00382026983061E-08  -2.99009370746053E-08  -2.58726222913005E-18
      5.00641304552703E-09
      0.00000000000000E+00  -3.43072239128135E-11   0.00000000000000E+00  -7.09133858374663E-12   1.43367367689070E-22
      3.43143764412404E-08   3.43072851026568E-08  -6.62195694736556E-19  -3.17918011825142E-01  -3.17918011817796E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34601591960479E-09   0.00000000000000E+00  -7.34601591960479E-09
      3.10856189348172E-18  -2.22138170891845E-01  -2.13643917478059E-01   0.00000000000000E+00   9.83147553057336E-11
     -8.91361482936103E-23  -2.70595839383576E-08  -2.69612691830520E-08  -2.44636619874516E-18
      5.02641304552703E-09
      0.00000000000000E+00  -3.18853700373882E-11   0.00000000000000E+00  -5.98577969845522E-12   1.25039735369892E-22
      3.18913545035798E-08   3.18853687238814E-08  -6.55552809861032E-19  -3.22832055365790E-01  -3.22832055358500E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28920134838446E-09   0.00000000000000E+00  -7.28920134838446E-09
      2.96277786651403E-18  -1.56725168071261E-01  -1.48975936988332E-01   0.00000000000000E+00   6.42535102788438E-11
     -8.17992328815318E-23  -2.46604208857758E-08  -2.45961673754970E-08  -2.30722505665300E-18
      5.03141304552703E-09
      0.00000000000000E+00  -3.10622575025344E-11   0.00000000000000E+00  -8.11580028079733E-12   1.19707912070386E-22
      3.10703142641703E-08   3.10621984638896E-08  -6.54254442466788E-19  -3.23921834315445E-01  -3.23921834308134E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.31098516776941E-09   0.00000000000000E+00  -7.31098516776941E-09
      2.92622294067518E-18  -1.40843224612727E-01  -1.33360179282044E-01   0.00000000000000E+00   5.45009652273456E-11
     -8.04707077603203E-23  -2.38057142613473E-08  -2.37512132961201E-08  -2.27196849820839E-18
      5.03816304552703E-09
      0.00000000000000E+00  -3.02777197573077E-11   0.00000000000000E+00  -5.75701703272155E-12   1.13204460806820E-22
      3.02834633155712E-08   3.02777062985386E-08  -6.52035340719652E-19  -3.25585699318317E-01  -3.25585699311050E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26689480424117E-09   0.00000000000000E+00  -7.26689480424117E-09
      2.87717140074656E-18  -1.20770955526871E-01  -1.13521155511372E-01   0.00000000000000E+00   4.56219662056460E-11
     -7.86070040568248E-23  -2.30564334605031E-08  -2.30108114942976E-08  -2.22513606002690E-18
      5.04727554552703E-09
      0.00000000000000E+00  -2.93503634457233E-11   0.00000000000000E+00  -5.02532648817781E-12   1.05913332435227E-22
      2.93554082254130E-08   2.93503828989249E-08  -6.48204592652837E-19  -3.28145602196980E-01  -3.28145602189781E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19846990214672E-09   0.00000000000000E+00  -7.19846990214672E-09
      2.81157534376324E-18  -9.59486629589327E-02  -8.89694406064380E-02   0.00000000000000E+00   3.83152583070967E-11
     -7.43697720892834E-23  -2.21902282550854E-08  -2.21519129967783E-08  -2.16337075111041E-18
      5.05957742052703E-09
      0.00000000000000E+00  -2.79804991902730E-11   0.00000000000000E+00  -5.48792078529952E-12   9.90435896093033E-23
      2.79860136207048E-08   2.79805256999196E-08  -6.40833647419978E-19  -3.32384136041040E-01  -3.32384136033963E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.07706036342910E-09   0.00000000000000E+00  -7.07706036342910E-09
      2.72451423180488E-18  -6.72809122762050E-02  -6.06949998932085E-02   0.00000000000000E+00   3.10713181741096E-11
     -5.90490817838202E-23  -2.09345366546644E-08  -2.09034653364904E-08  -2.08368058438490E-18
      5.06372930333953E-09
      0.00000000000000E+00  -2.71931142581929E-11   0.00000000000000E+00  -9.31101179694601E-12   9.69888947791684E-23
      2.72024552920315E-08   2.71931442802346E-08  -6.37925635370072E-19  -3.33944846911102E-01  -3.33944846904077E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02535154719287E-09   0.00000000000000E+00  -7.02535154719287E-09
      2.69534579546432E-18  -5.85085304164342E-02  -5.21543932830853E-02   0.00000000000000E+00   3.03846921317395E-11
     -4.93156645703621E-23  -2.01981774251736E-08  -2.01677927330419E-08  -2.05742016009425E-18
      5.06933434513641E-09
      0.00000000000000E+00  -2.61424104645388E-11   0.00000000000000E+00  -9.24199891327270E-12   9.57619273462079E-23
      2.61516956116635E-08   2.61424536127503E-08  -6.32704201933585E-19  -3.36503955531471E-01  -3.36503955524567E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.90441963009042E-09   0.00000000000000E+00  -6.90441963009042E-09
      2.65664623485450E-18  -4.84880329564979E-02  -4.24268195274549E-02   0.00000000000000E+00   2.65452898801662E-11
     -3.18032194653642E-23  -1.92645792725400E-08  -1.92380339826598E-08  -2.02394203292092E-18
      5.07690115156219E-09
      0.00000000000000E+00  -2.47612493064120E-11   0.00000000000000E+00  -8.99052964757599E-12   9.71971086887266E-23
      2.47702152269875E-08   2.47612246973400E-08  -6.23238322607160E-19  -3.40789877256347E-01  -3.40789877249624E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.72259197182883E-09   0.00000000000000E+00  -6.72259197182883E-09
      2.60577768272416E-18  -3.81544751828527E-02  -3.24711402070232E-02   0.00000000000000E+00   2.24197329601110E-11
     -2.36555750094882E-24  -1.80610524584712E-08  -1.80386327255111E-08  -1.98253936011700E-18
      5.08711634023699E-09
      0.00000000000000E+00  -2.32058586818025E-11   0.00000000000000E+00  -7.49049506928473E-12   1.03662027560705E-22
      2.32133708781878E-08   2.32058803831186E-08  -6.06972495781841E-19  -3.47762103966916E-01  -3.47762103960415E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.50118173190195E-09   0.00000000000000E+00  -6.50118173190195E-09
      2.53936688472359E-18  -2.89016754671078E-02  -2.36386061848472E-02   0.00000000000000E+00   1.73520765675505E-11
      3.95454555945712E-23  -1.67220507277842E-08  -1.67046986512166E-08  -1.93239438894175E-18
      5.10090684494798E-09
      0.00000000000000E+00  -2.17983380840972E-11   0.00000000000000E+00  -5.00736801333196E-12   1.16382367532333E-22
      2.18032907653081E-08   2.17982833972949E-08  -5.81667130261315E-19  -3.58280212890400E-01  -3.58280212884112E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.28767989153684E-09   0.00000000000000E+00  -6.28767989153684E-09
      2.45265660555818E-18  -2.17092277813153E-02  -1.68223672364445E-02   0.00000000000000E+00   1.21921378403549E-11
      8.98885001470454E-23  -1.55227956435986E-08  -1.55106035057582E-08  -1.87098947529686E-18
      5.11952402630781E-09
      0.00000000000000E+00  -2.06935377402279E-11   0.00000000000000E+00  -2.89402306845276E-12   1.32462797835710E-22
      2.06964241600417E-08   2.06935301369733E-08  -5.46135391637497E-19  -3.72859070172103E-01  -3.72859070165992E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.11039115298216E-09   0.00000000000000E+00  -6.11039115298216E-09
      2.33889834528360E-18  -1.65581362227263E-02  -1.19634799779454E-02   0.00000000000000E+00   8.27605306827053E-12
      1.42786133834357E-22  -1.45914150370595E-08  -1.45831389839911E-08  -1.79276295364610E-18
      5.13952402630781E-09
      0.00000000000000E+00  -1.98662003474625E-11   0.00000000000000E+00  -2.00691789603936E-12   1.41956102544433E-22
      1.98681786080385E-08   1.98661716901426E-08  -5.08999039505459E-19  -3.88075808952003E-01  -3.88075808946023E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.98017412957236E-09   0.00000000000000E+00  -5.98017412957236E-09
      2.21929486269215E-18  -1.34154952907861E-02  -9.04047896868574E-03   0.00000000000000E+00   6.22887013856024E-12
      1.78658466054887E-22  -1.38922264307089E-08  -1.38859975605701E-08  -1.71029582318669E-18
      5.15952402630781E-09
      0.00000000000000E+00  -1.91637717972993E-11   0.00000000000000E+00  -1.70141968148210E-12   1.41055972237653E-22
      1.91654023896985E-08   1.91637009700172E-08  -4.73758084983226E-19  -4.02589651831079E-01  -4.02589651825207E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.87212933399293E-09   0.00000000000000E+00  -5.87212933399293E-09
      2.10185227601229E-18  -1.14047581277526E-02  -7.21702136701543E-03   0.00000000000000E+00   5.16300687546680E-12
      1.92079729222337E-22  -1.32967346429000E-08  -1.32915716360244E-08  -1.62809419102907E-18
      5.17952402630781E-09
      0.00000000000000E+00  -1.85384009816532E-11   0.00000000000000E+00  -1.51419944449870E-12   1.30540815323920E-22
      1.85399446674767E-08   1.85384304680324E-08  -4.40417899743861E-19  -4.16420388890015E-01  -4.16420388884240E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.77506712527638E-09   0.00000000000000E+00  -5.77506712527638E-09
      1.98635093350677E-18  -1.00081073425859E-02  -5.98678826652889E-03   0.00000000000000E+00   4.45673283653824E-12
      1.85542102112195E-22  -1.27678200755927E-08  -1.27633633427560E-08  -1.54593303376291E-18
      5.19952402630781E-09
      0.00000000000000E+00  -1.80008337347776E-11   0.00000000000000E+00  -1.30073734006650E-12   1.13016237648606E-22
      1.80021587375798E-08   1.80008580002398E-08  -4.08710157219734E-19  -4.29662911643487E-01  -4.29662911637800E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.68742057394061E-09   0.00000000000000E+00  -5.68742057394061E-09
      1.87260252202795E-18  -8.99649109850145E-03  -5.11692620997497E-03   0.00000000000000E+00   3.87457767378019E-12
      1.64176216256647E-22  -1.23173120039732E-08  -1.23134374262992E-08  -1.46389236480822E-18
      5.21952402630781E-09
      0.00000000000000E+00  -1.75481310250817E-11   0.00000000000000E+00  -1.09379412972385E-12   9.17702779301190E-23
      1.75491807415422E-08   1.75480869474126E-08  -3.78342312462294E-19  -4.42413511799260E-01  -4.42413511793650E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.60971791737460E-09   0.00000000000000E+00  -5.60971791737460E-09
      1.76040816368046E-18  -8.23956026032980E-03  -4.47816489909941E-03   0.00000000000000E+00   3.39663094570606E-12
      1.34228271711616E-22  -1.19417656609838E-08  -1.19383690300380E-08  -1.38206585121817E-18
      5.23952402630781E-09
      0.00000000000000E+00  -1.72570750528710E-11   0.00000000000000E+00  -6.96754191753631E-13   7.00923951003663E-23
      1.72577580060650E-08   1.72570612518733E-08  -3.48688827034059E-19  -4.54919456237995E-01  -4.54919456232383E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.61188967729533E-09   0.00000000000000E+00  -5.61188967729533E-09
      1.64817037013455E-18  -7.67384883603412E-03  -4.00482848812337E-03   0.00000000000000E+00   2.99015640223591E-12
      1.01782646543057E-22  -1.16481617309804E-08  -1.16451715745780E-08  -1.29948154310049E-18
      5.25952402630781E-09
      0.00000000000000E+00  -1.74604193010485E-11   0.00000000000000E+00   5.21390037235674E-13   5.06726154594643E-23
      1.74598941239492E-08   1.74604155139865E-08  -3.17872541338104E-19  -4.67988084388251E-01  -4.67988084382298E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.95298072911496E-09   0.00000000000000E+00  -5.95298072911496E-09
      1.52911075555226E-18  -7.31568114553134E-03  -3.69005543811153E-03   0.00000000000000E+00   2.55292625172301E-12
      7.16772661888436E-23  -1.15099877111233E-08  -1.15074347848715E-08  -1.21123821421415E-18
      5.27952402630781E-09
      0.00000000000000E+00  -1.78398299104528E-11   0.00000000000000E+00   9.57227102852941E-13   3.46066951603642E-23
      1.78388673909305E-08   1.78398246180334E-08  -2.85986913437136E-19  -4.81614563917593E-01  -4.81614563911254E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.33872792639049E-09   0.00000000000000E+00  -6.33872792639049E-09
      1.40233619702445E-18  -7.08339221876110E-03  -3.45976149961540E-03   0.00000000000000E+00   2.17970318733628E-12
      4.63967499451699E-23  -1.15032763948303E-08  -1.15010966916429E-08  -1.11634928358731E-18
      5.28952402630781E-09
      0.00000000000000E+00  -1.80129572400890E-11   0.00000000000000E+00   8.76199050695969E-13   2.73025334401651E-23
      1.80120837139114E-08   1.80129599129621E-08  -2.70046782763909E-19  -4.88485448578213E-01  -4.88485448571693E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.51950251456169E-09   0.00000000000000E+00  -6.51950251456169E-09
      1.33714117187883E-18  -6.97998547308167E-03  -3.35876078638264E-03   0.00000000000000E+00   2.11915206737795E-12
      3.48155580844981E-23  -1.14955765504681E-08  -1.14934573984006E-08  -1.06709438911492E-18
      5.30302402630781E-09
      0.00000000000000E+00  -1.81605517327815E-11   0.00000000000000E+00   5.61259648858409E-13   1.97686426993372E-23
      1.81599716145154E-08   1.81605328741643E-08  -2.48643364046996E-19  -4.97768481588695E-01  -4.97768481582074E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62166503482229E-09   0.00000000000000E+00  -6.62166503482229E-09
      1.24774869390873E-18  -6.86847515969907E-03  -3.23294188246162E-03   0.00000000000000E+00   1.84629625857500E-12
      2.30021911960726E-23  -1.15407141356006E-08  -1.15388678393420E-08  -9.99105329861731E-19
      5.32124902630781E-09
      0.00000000000000E+00  -1.83378120755920E-11   0.00000000000000E+00   4.99796169967410E-13   1.30070420175984E-23
      1.83373260726867E-08   1.83378258688567E-08  -2.20369839730692E-19  -5.10165913054279E-01  -5.10165913047600E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.67922052658276E-09   0.00000000000000E+00  -6.67922052658276E-09
      1.12601989981176E-18  -6.76589541328704E-03  -3.09263510637282E-03   0.00000000000000E+00   1.57432640425540E-12
      1.25048840771733E-23  -1.16601796686782E-08  -1.16586053422739E-08  -9.05650060081065E-19
      5.32624902630781E-09
      0.00000000000000E+00  -1.84597818866036E-11   0.00000000000000E+00   1.21559396930846E-12   1.13206309039819E-23
      1.84585548178446E-08   1.84597704118139E-08  -2.12722663557124E-19  -5.13555607264903E-01  -5.13555607258162E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74162799472338E-09   0.00000000000000E+00  -6.74162799472338E-09
      1.09231175983814E-18  -6.76101800731774E-03  -3.06899890854338E-03   0.00000000000000E+00   1.23843826499687E-12
      9.83854235148658E-24  -1.17193808553557E-08  -1.17181424170907E-08  -8.79589096281016E-19
      5.33299902630781E-09
      0.00000000000000E+00  -1.86045291924427E-11   0.00000000000000E+00   1.07810735797307E-12   9.52181986252094E-24
      1.86034585697278E-08   1.86045366770858E-08  -2.02493642028208E-19  -5.18108997325246E-01  -5.18108997318491E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.75575138249921E-09   0.00000000000000E+00  -6.75575138249921E-09
      1.04671043800627E-18  -6.77495296654212E-03  -3.04177174231167E-03   0.00000000000000E+00   8.30817052311931E-13
      7.04404234416758E-24  -1.18496161116390E-08  -1.18487852945867E-08  -8.44216795978063E-19
      5.34211152630781E-09
      0.00000000000000E+00  -1.86365830057281E-11   0.00000000000000E+00   1.95689578369876E-13   7.74016688034259E-24
      1.86363458267053E-08   1.86365415162837E-08  -1.89147759173266E-19  -5.24079072289029E-01  -5.24079072282391E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.63792629672313E-09   0.00000000000000E+00  -6.63792629672313E-09
      9.86222334627381E-19  -6.77091196342917E-03  -2.99052336744801E-03   0.00000000000000E+00   8.89425519099579E-13
      4.36194285245330E-24  -1.19995046450797E-08  -1.19986152195606E-08  -7.97074575454114E-19
      5.35441340130781E-09
      0.00000000000000E+00  -1.82681937647887E-11   0.00000000000000E+00  -1.45577631087650E-12   6.07573012561209E-24
      1.82696635447780E-08   1.82682077684671E-08  -1.72805594522743E-19  -5.31429465636862E-01  -5.31429465630707E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.15578613468680E-09   0.00000000000000E+00  -6.15578613468680E-09
      9.10494623071730E-19  -6.70023941266848E-03  -2.88399320711963E-03   0.00000000000000E+00   1.06402567521222E-12
      2.03491864652996E-24  -1.21134856594555E-08  -1.21124216337803E-08  -7.37689028548987E-19
      5.37102093255781E-09
      0.00000000000000E+00  -1.67989535036799E-11   0.00000000000000E+00  -4.34697551143501E-12   4.52437326927443E-24
      1.68032532550853E-08   1.67989062795739E-08  -1.56632600742217E-19  -5.38713872022264E-01  -5.38713872017625E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.63830329249712E-09   0.00000000000000E+00  -4.63830329249712E-09
      8.33463856194607E-19  -6.49720014347388E-03  -2.66577260213107E-03   0.00000000000000E+00   9.60647303770512E-13
      1.92380791784833E-25  -1.21615636343807E-08  -1.21606029870769E-08  -6.76831255452391E-19
      5.39102093255781E-09
      0.00000000000000E+00  -1.28890311960183E-11   0.00000000000000E+00  -9.63135638236184E-12   2.92161254288672E-24
      1.28986247675927E-08   1.28889934112104E-08  -1.53905231695934E-19  -5.39749765383947E-01  -5.39749765383219E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28605158924867E-10   0.00000000000000E+00  -7.28605158924867E-10
      8.18891753016109E-19  -6.08136266064495E-03  -2.25000169278860E-03   0.00000000000000E+00   1.81334050664311E-13
     -1.25247908078854E-24  -1.21605695863361E-08  -1.21603882522854E-08  -6.64986521320174E-19
      5.41102093255782E-09
      0.00000000000000E+00  -6.20686734048466E-12   0.00000000000000E+00  -1.64725652241739E-11   9.52212495027791E-25
      6.22332915717289E-09   6.20685659194871E-09  -1.79731831258787E-19  -5.27650018261198E-01  -5.27650018267139E-01
      0.00000000000000E+00   0.00000000000000E+00   5.94121706481071E-09   0.00000000000000E+00   5.94121706481071E-09
      9.37716094312323E-19  -5.45203905495520E-03  -1.62455715205476E-03   0.00000000000000E+00  -1.35861341669094E-12
     -2.83126511289799E-24  -1.21467150433428E-08  -1.21480736567595E-08  -7.57984263053536E-19
      5.43102093255782E-09
      0.00000000000000E+00   1.95234357882040E-12   0.00000000000000E+00  -2.01317645933719E-11  -2.21911551936418E-24
     -1.93224277746308E-09  -1.95237454205645E-09  -2.44560664044899E-19  -4.98571631319986E-01  -4.98571631334065E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40789429792043E-08   0.00000000000000E+00   1.40789429792043E-08
      1.21929495389641E-18  -4.68901032701481E-03  -8.68304321645670E-04   0.00000000000000E+00  -3.67488375431876E-12
     -6.23784681341020E-24  -1.21228935533937E-08  -1.21265684371480E-08  -9.74734289851512E-19
      5.45102093255782E-09
      0.00000000000000E+00   8.87807967742837E-12   0.00000000000000E+00  -1.71465534977605E-11  -9.05692566810707E-24
     -8.86098326025775E-09  -8.87812981375552E-09  -3.54920924123865E-19  -4.51831727748797E-01  -4.51831727769763E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09653460760795E-08   0.00000000000000E+00   2.09653460760795E-08
      1.63860187541800E-18  -3.96050726548101E-03  -1.52202306798338E-04   0.00000000000000E+00  -7.09068729640354E-12
     -1.67161030024164E-23  -1.20801255750275E-08  -1.20872162623240E-08  -1.28368095129413E-18
      5.47102093255782E-09
      0.00000000000000E+00   1.20873184849338E-11   0.00000000000000E+00  -8.07390059758306E-12  -2.39058864729905E-23
     -1.20792954604902E-08  -1.20873693610878E-08  -5.11925376571993E-19  -3.88929303751264E-01  -3.88929303775378E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41140908912065E-08   0.00000000000000E+00   2.41140908912065E-08
      2.12088369324213E-18  -3.44658895286895E-03   3.42653882908317E-04   0.00000000000000E+00  -1.28679635405749E-11
     -4.37532264971607E-23  -1.20138535665780E-08  -1.20267215301186E-08  -1.60895831667014E-18
      5.49102093255782E-09
      0.00000000000000E+00   1.08569663853017E-11   0.00000000000000E+00   2.76196936272345E-12  -3.79229833978742E-23
     -1.08597594623241E-08  -1.08569974929614E-08  -6.97410905090905E-19  -3.14091839163580E-01  -3.14091839186247E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26674423166953E-08   0.00000000000000E+00   2.26674423166953E-08
      2.57423253957604E-18  -4.24681554148804E-03  -5.25719750133441E-04   0.00000000000000E+00  -2.29845473436833E-11
     -7.05489680466643E-23  -1.17874602763901E-08  -1.18104448237339E-08  -1.87682163448513E-18
      5.51102093255782E-09
      0.00000000000000E+00   8.33693048580162E-12   0.00000000000000E+00   5.84130784811119E-12  -4.20664555489369E-23
     -8.34278284716572E-09  -8.33694153931765E-09  -8.67638761305047E-19  -2.38569730522287E-01  -2.38569730541295E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90080983661943E-08   0.00000000000000E+00   1.90080983661943E-08
      2.95439450689992E-18  -1.26845677470208E-02  -9.32242958973742E-03   0.00000000000000E+00  -3.73516114122204E-11
     -7.98841915412987E-23  -1.06338052154644E-08  -1.06711568268767E-08  -2.08675574559487E-18
      5.53102093255782E-09
      0.00000000000000E+00   6.73883205839065E-12   0.00000000000000E+00   3.49487031082622E-12  -4.40297115958148E-23
     -6.74230362276926E-09  -6.73880875245848E-09  -1.00432599321978E-18  -1.71124914443703E-01  -1.71124914459496E-01
      0.00000000000000E+00   0.00000000000000E+00   1.57935227881278E-08   0.00000000000000E+00   1.57935227881278E-08
      3.27026496266248E-18  -3.12684748878153E-02  -2.84156256256043E-02   0.00000000000000E+00  -5.81429593068556E-11
     -8.80308612848708E-23  -8.99657107636234E-09  -9.05471403566929E-09  -2.26593896944269E-18
      5.54102093255782E-09
      0.00000000000000E+00   5.94455877101996E-12   0.00000000000000E+00   3.39550293511181E-12  -4.49049256884895E-23
     -5.94801287400486E-09  -5.94461737106979E-09  -1.06396829239245E-18  -1.39691183334031E-01  -1.39691183348189E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41585025147964E-08   0.00000000000000E+00   1.41585025147964E-08
      3.41184998781044E-18  -4.29699869031991E-02  -4.03820472616864E-02   0.00000000000000E+00  -7.93055942914269E-11
     -9.24239945614876E-23  -8.13457954943508E-09  -8.21388514372660E-09  -2.34788169541799E-18
      5.55452093255782E-09
      0.00000000000000E+00   5.13118177831010E-12   0.00000000000000E+00   2.43491941014514E-12  -4.59955814604371E-23
     -5.13360017107263E-09  -5.13116525166253E-09  -1.13266777793096E-18  -1.01787510036336E-01  -1.01787510048878E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25412538257680E-08   0.00000000000000E+00   1.25412538257680E-08
      3.58115691445831E-18  -6.13791202209529E-02  -5.90444302771706E-02   0.00000000000000E+00  -9.74021215457049E-11
     -9.83417016439240E-23  -7.31268645255965E-09  -7.41008857410545E-09  -2.44848913652735E-18
      5.57274593255782E-09
      0.00000000000000E+00   3.95134428414222E-12   0.00000000000000E+00   2.68454211783529E-12  -4.71308138910988E-23
     -3.95399184243286E-09  -3.95130730031507E-09  -1.20345755586106E-18  -6.06920010390924E-02  -6.06920010494222E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03297707347355E-08   0.00000000000000E+00   1.03297707347355E-08
      3.76941698609886E-18  -9.01399955711655E-02  -8.81303379607184E-02   0.00000000000000E+00  -1.16361059328186E-10
     -1.06102626744873E-22  -6.26210237509193E-09  -6.37846343442023E-09  -2.56595943023780E-18
      5.57774593255782E-09
      0.00000000000000E+00   3.32174861058462E-12   0.00000000000000E+00   5.69715002989757E-12  -4.73724171052978E-23
     -3.32746949962728E-09  -3.32177234959743E-09  -1.21971968640217E-18  -5.09673529065819E-02  -5.09673529157696E-02
      0.00000000000000E+00   0.00000000000000E+00   9.18770903120023E-09   0.00000000000000E+00   9.18770903120023E-09
      3.81535553125486E-18  -9.86091204962933E-02  -9.67609340969957E-02   0.00000000000000E+00  -1.28843441173182E-10
     -1.08236486983943E-22  -5.73709324042992E-09  -5.86593668160321E-09  -2.59563584485269E-18
      5.58449593255782E-09
      0.00000000000000E+00   2.56595826810388E-12   0.00000000000000E+00   5.13960158638615E-12  -4.76163298591928E-23
     -2.57105278666118E-09  -2.56591318507484E-09  -1.23656006454528E-18  -4.07178351917268E-02  -4.07178351995986E-02
      0.00000000000000E+00   0.00000000000000E+00   7.87175437333157E-09   0.00000000000000E+00   7.87175437333157E-09
      3.86848987327485E-18  -1.10867978907214E-01  -1.09196261499309E-01   0.00000000000000E+00  -1.28754571553756E-10
     -1.10959951427726E-22  -5.17708661670250E-09  -5.30584118825637E-09  -2.63192980872957E-18
      5.59360843255782E-09
      0.00000000000000E+00   1.74550923062905E-12   0.00000000000000E+00   4.17747356069619E-12  -4.78252129776921E-23
     -1.74970048869405E-09  -1.74552301513340E-09  -1.25181343857270E-18  -3.12108951098558E-02  -3.12108951162708E-02
      0.00000000000000E+00   0.00000000000000E+00   6.41503676641306E-09   0.00000000000000E+00   6.41503676641306E-09
      3.92694689580879E-18  -1.28444106535310E-01  -1.26972877007864E-01   0.00000000000000E+00  -1.26624832278662E-10
     -1.14363936443502E-22  -4.54288891900096E-09  -4.66951375127973E-09  -2.67513345723609E-18
      5.60591030755782E-09
      0.00000000000000E+00   1.03371251727071E-12   0.00000000000000E+00   2.70583936227510E-12  -4.79759701526638E-23
     -1.03636353500280E-09  -1.03365769564057E-09  -1.26365467085755E-18  -2.35516080105662E-02  -2.35516080156380E-02
      0.00000000000000E+00   0.00000000000000E+00   5.07182015566141E-09   0.00000000000000E+00   5.07182015566141E-09
      3.98933979338622E-18  -1.52878722666639E-01  -1.51606412938281E-01   0.00000000000000E+00  -1.24960577687641E-10
     -1.18588017824344E-22  -3.91320188233319E-09  -4.03816246002095E-09  -2.72568512252867E-18
      5.62251783880782E-09
      0.00000000000000E+00   5.59609983805460E-13   0.00000000000000E+00   1.33860953912646E-12  -4.80702337828166E-23
     -5.60918883733846E-10  -5.59580274194767E-10  -1.27179102463086E-18  -1.79556370583669E-02  -1.79556370623897E-02
      0.00000000000000E+00   0.00000000000000E+00   4.02288362836746E-09   0.00000000000000E+00   4.02288362836746E-09
      4.05614995895945E-18  -1.85120340222689E-01  -1.84029150978803E-01   0.00000000000000E+00  -1.24845707651591E-10
     -1.23831434955431E-22  -3.33845764652094E-09  -3.46330335417266E-09  -2.78435893432858E-18
      5.64251783880782E-09
      0.00000000000000E+00   3.16405119679930E-13   0.00000000000000E+00   5.70661391872660E-13  -4.81191272520333E-23
     -3.17011937489124E-10  -3.16441276097299E-10  -1.27676297925201E-18  -1.42484784732674E-02  -1.42484784765019E-02
      0.00000000000000E+00   0.00000000000000E+00   3.23450845751946E-09   0.00000000000000E+00   3.23450845751946E-09
      4.12084012810984E-18  -2.20520263043437E-01  -2.19600860426817E-01   0.00000000000000E+00  -1.23260003910343E-10
     -1.29529826541668E-22  -2.79480717751172E-09  -2.91806718142220E-09  -2.84407714885782E-18
      5.66251783880782E-09
      0.00000000000000E+00   2.11610274526142E-13   0.00000000000000E+00   2.46882130020876E-13  -4.81406336986984E-23
     -2.11811070051461E-10  -2.11564187921488E-10  -1.27966873352119E-18  -1.19586002640027E-02  -1.19586002665965E-02
      0.00000000000000E+00   0.00000000000000E+00   2.59375254195117E-09   0.00000000000000E+00   2.59375254195117E-09
      4.17271517894886E-18  -2.50534285148692E-01  -2.49783721167625E-01   0.00000000000000E+00  -1.14912370264585E-10
     -1.34426065641024E-22  -2.26727598376499E-09  -2.38218835402971E-09  -2.89304644542767E-18
      5.68251783880782E-09
      0.00000000000000E+00   1.64861303287511E-13   0.00000000000000E+00   1.10821212982911E-13  -4.81502153035784E-23
     -1.64963930082208E-10  -1.64853108869273E-10  -1.28166538675989E-18  -1.04002415091848E-02  -1.04002415112128E-02
      0.00000000000000E+00   0.00000000000000E+00   2.02801239926337E-09   0.00000000000000E+00   2.02801239926337E-09
      4.21327542693413E-18  -2.74225241318055E-01  -2.73638209147909E-01   0.00000000000000E+00  -9.80741426982046E-11
     -1.38348974754143E-22  -1.76508514769565E-09  -1.86315929039399E-09  -2.93161004017423E-18
      5.70251783880782E-09
      0.00000000000000E+00   1.41165361087969E-13   0.00000000000000E+00   5.75118564799412E-14  -4.81536326982715E-23
     -1.41233384025822E-10  -1.41175872169391E-10  -1.28320799724422E-18  -9.28380556744047E-03  -9.28380556898164E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54116854707351E-09   0.00000000000000E+00   1.54116854707351E-09
      4.24409879787560E-18  -2.91768814149921E-01  -2.91327714778526E-01   0.00000000000000E+00  -7.65755507018791E-11
     -1.41276781812006E-22  -1.32341712420219E-09  -1.39999267490421E-09  -2.96089080063138E-18
      5.72251783880782E-09
      0.00000000000000E+00   1.28307097878915E-13   0.00000000000000E+00   3.25593750047002E-14  -4.81538300526113E-23
     -1.28344292921519E-10  -1.28311733546562E-10  -1.28450813517272E-18  -8.45691418761210E-03  -8.45691418874741E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13530639509096E-09   0.00000000000000E+00   1.13530639509096E-09
      4.26680492577742E-18  -3.03836651438657E-01  -3.03519377624305E-01   0.00000000000000E+00  -5.39779041413254E-11
     -1.43282572969003E-22  -9.53016757402915E-10  -1.00699466154438E-09  -2.98229679060470E-18
      5.74251783880782E-09
      0.00000000000000E+00   1.20775829427898E-13   0.00000000000000E+00   2.02404180476261E-14  -4.81522817071614E-23
     -1.20801471663272E-10  -1.20781231245273E-10  -1.28566868120134E-18  -7.83153987644363E-03  -7.83153987724806E-03
      0.00000000000000E+00   0.00000000000000E+00   8.04421561186126E-10   0.00000000000000E+00   8.04421561186126E-10
      4.28289335700114E-18  -3.11270082837557E-01  -3.11054692016985E-01   0.00000000000000E+00  -3.27940576645942E-11
     -1.44487301306719E-22  -6.50846272276067E-10  -6.83640329940806E-10  -2.99722467579979E-18
      5.76251783880782E-09
      0.00000000000000E+00   1.08836013590919E-13   0.00000000000000E+00   3.28204534306726E-14  -4.81467587161512E-23
     -1.08838313677728E-10  -1.08805493224345E-10  -1.28659885617326E-18  -7.40761437391393E-03  -7.40761437451983E-03
      0.00000000000000E+00   0.00000000000000E+00   6.05904501836596E-10   0.00000000000000E+00   6.05904501836596E-10
      4.29501144703787E-18  -3.16123918133659E-01  -3.15967303166314E-01   0.00000000000000E+00  -2.01494943519354E-11
     -1.45225113553079E-22  -4.76949514260161E-10  -4.97099008612241E-10  -3.00841259086461E-18
      5.78251783880782E-09
      0.00000000000000E+00   9.42327003749225E-14   0.00000000000000E+00   4.13399196555994E-14  -4.81364871418985E-23
     -9.42895342798844E-11  -9.42481943602769E-11  -1.28724721438535E-18  -7.15037281959404E-03  -7.15037282016162E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67588016223316E-10   0.00000000000000E+00   5.67588016223316E-10
      4.30636320736234E-18  -3.20850847013217E-01  -3.20701717964275E-01   0.00000000000000E+00  -1.92523975936245E-11
     -1.45915725036554E-22  -4.54087424269233E-10  -4.73339821863003E-10  -3.01911599297698E-18
      5.79251783880782E-09
      0.00000000000000E+00   9.06507556238289E-14   0.00000000000000E+00   2.38543178079348E-14  -4.81310857955462E-23
     -9.06469420936775E-11  -9.06230877759177E-11  -1.28753746715236E-18  -7.04134290267013E-03  -7.04134290322316E-03
      0.00000000000000E+00   0.00000000000000E+00   5.53026080348410E-10   0.00000000000000E+00   5.53026080348410E-10
      4.31189346816582E-18  -3.23155675880502E-01  -3.23009992783939E-01   0.00000000000000E+00  -1.87147923597803E-11
     -1.46247999593149E-22  -4.43688200212684E-10  -4.62402992572610E-10  -3.02435600101346E-18
      5.80601783880782E-09
      0.00000000000000E+00   8.47726924425472E-14   0.00000000000000E+00   2.79758718210086E-14  -4.81226165518495E-23
     -8.47997924838817E-11  -8.47718166121088E-11  -1.28785487274493E-18  -6.92175929325258E-03  -6.92175929384461E-03
      0.00000000000000E+00   0.00000000000000E+00   5.92029449460560E-10   0.00000000000000E+00   5.92029449460560E-10
      4.31988586573354E-18  -3.26788349102254E-01  -3.26628532903768E-01   0.00000000000000E+00  -2.26666390951466E-11
     -1.46781808601579E-22  -4.84590993753345E-10  -5.07257632848638E-10  -3.03203099298860E-18
      5.82424283880782E-09
      0.00000000000000E+00   7.77924924147752E-14   0.00000000000000E+00   2.63095530377773E-14  -4.81095267833332E-23
     -7.78248126137703E-11  -7.77985030607807E-11  -1.28816559344300E-18  -6.79078998953498E-03  -6.79078999020643E-03
      0.00000000000000E+00   0.00000000000000E+00   6.71442568978774E-10   0.00000000000000E+00   6.71442568978774E-10
      4.33212290655318E-18  -3.32961448423417E-01  -3.32774413185591E-01   0.00000000000000E+00  -2.99496373982465E-11
     -1.47716820366445E-22  -5.63694428519537E-10  -5.93644065917931E-10  -3.04395731311017E-18
      5.82924283880782E-09
      0.00000000000000E+00   7.08122923870031E-14   0.00000000000000E+00   7.67538673929279E-14  -4.81050305204559E-23
     -7.09066743533968E-11  -7.08299204860520E-11  -1.28821674289960E-18  -6.77078567478909E-03  -6.77078567549294E-03
      0.00000000000000E+00   0.00000000000000E+00   7.03845705823490E-10   0.00000000000000E+00   7.03845705823490E-10
      4.33564213508229E-18  -3.34831425819651E-01  -3.34631984921567E-01   0.00000000000000E+00  -3.36448547711431E-11
     -1.48001587693716E-22  -5.99370930566134E-10  -6.33015785337425E-10  -3.04742539218269E-18
      5.83599283880782E-09
      0.00000000000000E+00   5.84132528639870E-14   0.00000000000000E+00   1.01247152123312E-13  -4.80973678938511E-23
     -5.84936991953659E-11  -5.83924520432907E-11  -1.28820342029725E-18  -6.77490218205790E-03  -6.77490218287277E-03
      0.00000000000000E+00   0.00000000000000E+00   8.14870980877569E-10   0.00000000000000E+00   8.14870980877569E-10
      4.34114251420322E-18  -3.38058666200839E-01  -3.37820323779412E-01   0.00000000000000E+00  -4.43714449425154E-11
     -1.48503028915834E-22  -7.12107083891625E-10  -7.56478528834289E-10  -3.05293909390597E-18
      5.84510533880782E-09
      0.00000000000000E+00   5.18922765222526E-14   0.00000000000000E+00   4.70054732477318E-14  -4.80867819121065E-23
     -5.19340674729970E-11  -5.18870619997973E-11  -1.28812947597940E-18  -6.78057945894952E-03  -6.78057945992392E-03
      0.00000000000000E+00   0.00000000000000E+00   9.74397378554769E-10   0.00000000000000E+00   9.74397378554769E-10
      4.35002171031530E-18  -3.43599035204846E-01  -3.43308378577009E-01   0.00000000000000E+00  -5.85251461920583E-11
     -1.49388330257468E-22  -8.63985170362787E-10  -9.22510316554995E-10  -3.06189223433590E-18
      5.85740721380782E-09
      0.00000000000000E+00   5.19841212594601E-14   0.00000000000000E+00   1.07506187758017E-14  -4.80733719969324E-23
     -5.20344051713516E-11  -5.20236545526238E-11  -1.28803802217008E-18  -6.74170746584187E-03  -6.74170746696834E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12647402055257E-09   0.00000000000000E+00   1.12647402055257E-09
      4.36387945290688E-18  -3.52489905866026E-01  -3.52151375233770E-01   0.00000000000000E+00  -7.22731224977699E-11
     -1.50846217730220E-22  -1.00217724350199E-09  -1.07445036599991E-09  -3.07584143073680E-18
      5.87401474505782E-09
      0.00000000000000E+00   5.84132528639870E-14   0.00000000000000E+00  -9.36168367332738E-15  -4.80580711922617E-23
     -5.84158646294222E-11  -5.84252263131436E-11  -1.28803342504801E-18  -6.58686245032249E-03  -6.58686245153342E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21092606012985E-09   0.00000000000000E+00   1.21092606012985E-09
      4.38398994529193E-18  -3.65423960163084E-01  -3.65060837061963E-01   0.00000000000000E+00  -8.12291297332002E-11
     -1.53018049255118E-22  -1.07127170408341E-09  -1.15250083381676E-09  -3.09595652024392E-18
      5.89401474505782E-09
      0.00000000000000E+00   7.05367581753806E-14   0.00000000000000E+00  -2.29128388527387E-14  -4.80448966412436E-23
     -7.05404337384584E-11  -7.05633465773592E-11  -1.28828815275442E-18  -6.23932998594560E-03  -6.23932998716891E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22330164892594E-09   0.00000000000000E+00   1.22330164892594E-09
      4.40845597827045E-18  -3.80912930831288E-01  -3.80549732821764E-01   0.00000000000000E+00  -8.48470757537509E-11
     -1.55686107545227E-22  -1.06789122659467E-09  -1.15273830234858E-09  -3.12016782551603E-18
      5.91401474505782E-09
      0.00000000000000E+00   8.85383266680558E-14   0.00000000000000E+00  -4.06664438447532E-14  -4.80389828815668E-23
     -8.84273041363215E-11  -8.84679705802142E-11  -1.28891705449328E-18  -5.67793113567590E-03  -5.67793113688478E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20887970320920E-09   0.00000000000000E+00   1.20887970320920E-09
      4.43263357233463E-18  -3.95772157564872E-01  -3.95419144862517E-01   0.00000000000000E+00  -8.59762293857118E-11
     -1.58323734801167E-22  -1.03443550324295E-09  -1.12041173262882E-09  -3.14371651784135E-18
      5.93401474505782E-09
      0.00000000000000E+00   1.03509018832883E-13   0.00000000000000E+00  -3.66430331361266E-14  -4.80386690774101E-23
     -1.03473628187961E-10  -1.03510271221145E-10  -1.28986147098323E-18  -4.94194347437824E-03  -4.94194347556273E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18448845934833E-09   0.00000000000000E+00   1.18448845934833E-09
      4.45632334152160E-18  -4.09921132369630E-01  -4.09580544333978E-01   0.00000000000000E+00  -8.61565462515247E-11
     -1.60906759846533E-22  -9.94821641875653E-10  -1.08097818812734E-09  -3.16646187053837E-18
      5.95401474505782E-09
      0.00000000000000E+00   1.05988826737486E-13   0.00000000000000E+00  -6.33458557078710E-15  -4.80388406292266E-23
     -1.05936833986054E-10  -1.05943168571672E-10  -1.29086839168413E-18  -4.18352774523913E-03  -4.18352774638288E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14374918569294E-09   0.00000000000000E+00   1.14374918569294E-09
      4.47919832523546E-18  -4.23433376985372E-01  -4.23106391695450E-01   0.00000000000000E+00  -8.55457412998629E-11
     -1.63417398306713E-22  -9.52260275821196E-10  -1.03780601712122E-09  -3.18832993355133E-18
      5.97401474505782E-09
      0.00000000000000E+00   9.39571661632999E-14   0.00000000000000E+00   3.09661860180243E-14  -4.80343292330025E-23
     -9.40188805722117E-11  -9.39879143862417E-11  -1.29164997803415E-18  -3.57413094468523E-03  -3.57413094577057E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08533790819558E-09   0.00000000000000E+00   1.08533790819558E-09
      4.50090508339937E-18  -4.36406778050224E-01  -4.36094430311507E-01   0.00000000000000E+00  -8.41051541100301E-11
     -1.65837477752312E-22  -9.07244839699174E-10  -9.91349993809370E-10  -3.20925510536522E-18
      5.99401474505782E-09
      0.00000000000000E+00   4.07790633201419E-14   0.00000000000000E+00   1.41436227587067E-13  -4.80090392351317E-23
     -4.09607350895109E-11  -4.08192988619718E-11  -1.29138403330146E-18  -3.60737493146194E-03  -3.60737493242740E-03
      0.00000000000000E+00   0.00000000000000E+00   9.65458729499882E-10   0.00000000000000E+00   9.65458729499882E-10
      4.52021425798937E-18  -4.48964436638196E-01  -4.48673108662924E-01   0.00000000000000E+00  -7.97145552955237E-11
     -1.68089471336923E-22  -8.44924875342281E-10  -9.24639430637973E-10  -3.22883022468790E-18
      6.01401474505782E-09
      0.00000000000000E+00  -3.83084398892594E-13   0.00000000000000E+00   1.12554049875781E-12  -4.78125675496429E-23
      3.81952174812293E-10   3.83077715311003E-10  -1.28268023130741E-18  -8.72061817658998E-03  -8.72061817684507E-03
      0.00000000000000E+00   0.00000000000000E+00   2.55088720094232E-10   0.00000000000000E+00   2.55088720094232E-10
      4.52531603239125E-18  -4.61666369894657E-01  -4.61465308320399E-01   0.00000000000000E+00  -4.72738864407810E-11
     -1.69397022404820E-22  -5.90892548964199E-10  -6.38166435405149E-10  -3.24263580108384E-18
      6.03401474505782E-09
      0.00000000000000E+00  -1.28711214722628E-12   0.00000000000000E+00   2.44931362822987E-12  -4.72743110630513E-23
      1.28463524114520E-09   1.28708455477338E-09  -1.25603039048650E-18  -2.43985760618070E-02  -2.43985760605936E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.21340693421026E-09   0.00000000000000E+00  -1.21340693421026E-09
      4.50104789370705E-18  -4.75090505867886E-01  -4.75067313593044E-01   0.00000000000000E+00   2.14421371065084E-11
     -1.68764656679146E-22  -9.51197576694985E-11  -7.36776205631588E-11  -3.24501750322054E-18
      6.05401474505782E-09
      0.00000000000000E+00  -2.01819625539819E-12   0.00000000000000E+00   2.10784343170779E-12  -4.65082394063004E-23
      2.01608571094579E-09   2.01819355437745E-09  -1.21513970255089E-18  -4.78745688404163E-02  -4.78745688380457E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.37056048764097E-09   0.00000000000000E+00  -2.37056048764097E-09
      4.45363668395423E-18  -4.88803046943750E-01  -4.88914101293507E-01   0.00000000000000E+00   7.23263129555711E-11
     -1.66680366608893E-22   2.80040620308095E-10   3.52366933263499E-10  -3.23849698140334E-18
      6.05403427630782E-09
      0.00000000000000E+00  -2.02040052909117E-12   0.00000000000000E+00   3.16999189145867E-12  -4.65074352833610E-23
      2.01722295749243E-09   2.02039294938384E-09  -1.21509972809476E-18  -4.78974744693099E-02  -4.78974744669366E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.37323803419269E-09   0.00000000000000E+00  -2.37323803419269E-09
      4.45359033164887E-18  -4.88816394333558E-01  -4.88927599402367E-01   0.00000000000000E+00   7.22794625071755E-11
     -1.66678320591199E-22   2.80565622244070E-10   3.52845084751079E-10  -3.23849060355411E-18
      6.05406064349532E-09
      0.00000000000000E+00  -2.02508461068876E-12   0.00000000000000E+00   5.22305746940640E-12  -4.65062103343443E-23
      2.01986065638137E-09   2.02508371385073E-09  -1.21504564031818E-18  -4.79284348193676E-02  -4.79284348169888E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.37880759893116E-09   0.00000000000000E+00  -2.37880759893116E-09
      4.45352760918288E-18  -4.88834361013742E-01  -4.88945842878958E-01   0.00000000000000E+00   7.23523317479164E-11
     -1.66675558114796E-22   2.81371553377334E-10   3.53723885125084E-10  -3.23848196886470E-18
      6.05409623919845E-09
      0.00000000000000E+00  -2.03307510282581E-12   0.00000000000000E+00   7.78041289803781E-12  -4.65043369458020E-23
      2.02527229814850E-09   2.03305271104649E-09  -1.21497234046587E-18  -4.79703783487149E-02  -4.79703783463265E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.38843401876096E-09   0.00000000000000E+00  -2.38843401876096E-09
      4.45344259119462E-18  -4.88858563142211E-01  -4.88970567221849E-01   0.00000000000000E+00   7.27001190719244E-11
     -1.66671816777813E-22   2.82681188666639E-10   3.55381307738397E-10  -3.23847025072874E-18
      6.05414429339767E-09
      0.00000000000000E+00  -2.04483122918838E-12   0.00000000000000E+00   1.00437611867538E-11  -4.65015749579767E-23
      2.03478524669813E-09   2.04482900788484E-09  -1.21487282366338E-18  -4.80273163679944E-02  -4.80273163655913E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.40315934094910E-09   0.00000000000000E+00  -2.40315934094910E-09
      4.45332710929689E-18  -4.88891195647235E-01  -4.89004128998612E-01   0.00000000000000E+00   7.34287405874308E-11
     -1.66666728525346E-22   2.84901592526724E-10   3.58330333113988E-10  -3.23845428563351E-18
      6.05420916656661E-09
      0.00000000000000E+00  -2.06044483451366E-12   0.00000000000000E+00   1.12585327924983E-11  -4.64977369871246E-23
      2.04922195104539E-09   2.06048048383784E-09  -1.21473746727680E-18  -4.81047200162674E-02  -4.81047200138438E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.42362883243459E-09   0.00000000000000E+00  -2.42362883243459E-09
      4.45316988081419E-18  -4.88935235597710E-01  -4.89049687234391E-01   0.00000000000000E+00   7.45252670904193E-11
     -1.66659781836508E-22   2.88623081482022E-10   3.63148348572274E-10  -3.23843241353739E-18
      6.05429674534469E-09
      0.00000000000000E+00  -2.07954853985282E-12   0.00000000000000E+00   1.11029747916830E-11  -4.64927181697799E-23
      2.06842599627007E-09   2.07952897106171E-09  -1.21455307952013E-18  -4.82100313262759E-02  -4.82100313238260E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.44989520603310E-09   0.00000000000000E+00  -2.44989520603310E-09
      4.45295532198563E-18  -4.88994710995571E-01  -4.89111437162035E-01   0.00000000000000E+00   7.58651642857700E-11
     -1.66650272586578E-22   2.94501070689985E-10   3.70366234975589E-10  -3.23840224246550E-18
      6.05441497669509E-09
      0.00000000000000E+00  -2.10104020835938E-12   0.00000000000000E+00   9.80973231067793E-12  -4.64864464960384E-23
      2.09123859463395E-09   2.10104832694458E-09  -1.21430163248898E-18  -4.83533695063399E-02  -4.83533695038585E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.48138428447729E-09   0.00000000000000E+00  -2.48138428447729E-09
      4.45266194457081E-18  -4.89075061031029E-01  -4.89194928777053E-01   0.00000000000000E+00   7.72934005705443E-11
     -1.66637232662388E-22   3.03042556963079E-10   3.80335957533457E-10  -3.23836031208183E-18
      6.05457458901813E-09
      0.00000000000000E+00  -2.12390954792406E-12   0.00000000000000E+00   7.94694130304309E-12  -4.64787513952073E-23
      2.11599327711650E-09   2.12394021841950E-09  -1.21395856274373E-18  -4.85485058077111E-02  -4.85485058051941E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.51702815998699E-09   0.00000000000000E+00  -2.51702815998699E-09
      4.45226019585902E-18  -4.89183626259226E-01  -4.89307512139029E-01   0.00000000000000E+00   7.87039711152593E-11
     -1.66619325486275E-22   3.14383970441852E-10   3.93087941556945E-10  -3.23830163311530E-18
      6.05479006565424E-09
      0.00000000000000E+00  -2.14732995591198E-12   0.00000000000000E+00   6.08212194503788E-12  -4.64692024151296E-23
      2.14125023537093E-09   2.14733235731592E-09  -1.21349044709348E-18  -4.88142029804933E-02  -4.88142029779377E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.55555436219350E-09   0.00000000000000E+00  -2.55555436219350E-09
      4.45170953360166E-18  -4.89330320865369E-01  -4.89458975317294E-01   0.00000000000000E+00   8.00621729356495E-11
     -1.66594702959725E-22   3.28159831936180E-10   4.08222004871663E-10  -3.23821908650819E-18
      6.05508095911299E-09
      0.00000000000000E+00  -2.17102589811152E-12   0.00000000000000E+00   4.57244629446524E-12  -4.64569763115651E-23
      2.16642649406039E-09   2.17099894035481E-09  -1.21285173400446E-18  -4.91760749511550E-02  -4.91760749485591E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.59595854428086E-09   0.00000000000000E+00  -2.59595854428086E-09
      4.45095438624195E-18  -4.89528555144891E-01  -4.89662483334720E-01   0.00000000000000E+00   8.13904107662566E-11
     -1.66560814520097E-22   3.43569193159144E-10   4.24959603925234E-10  -3.23810265223749E-18
      6.05547366528230E-09
      0.00000000000000E+00  -2.19573213242034E-12   0.00000000000000E+00   3.53278089084393E-12  -4.64407832281913E-23
      2.19211568871883E-09   2.19564846960963E-09  -1.21198002844546E-18  -4.96692237634583E-02  -4.96692237608202E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.63813588253587E-09   0.00000000000000E+00  -2.63813588253587E-09
      4.44991837400540E-18  -4.89796493724713E-01  -4.89935944619877E-01   0.00000000000000E+00   8.27579590033273E-11
     -1.66514138992397E-22   3.59729453922886E-10   4.42487412926046E-10  -3.23793834555994E-18
      6.05600381861087E-09
      0.00000000000000E+00  -2.22291817463377E-12   0.00000000000000E+00   2.90582313214471E-12  -4.64188329376138E-23
      2.22002878684542E-09   2.22293460997751E-09  -1.21078920431665E-18  -5.03420378550128E-02  -5.03420378523293E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.68344534545063E-09   0.00000000000000E+00  -2.68344534545063E-09
      4.44849573652349E-18  -4.90158752620446E-01  -4.90303882403962E-01   0.00000000000000E+00   8.42774133146744E-11
     -1.66449781134842E-22   3.76233322157042E-10   4.60510735471550E-10  -3.23770653220683E-18
      6.05671952560443E-09
      0.00000000000000E+00  -2.25524752213082E-12   0.00000000000000E+00   2.55939610148667E-12  -4.63887741967807E-23
      2.25264313834215E-09   2.25520253444359E-09  -1.20915933709118E-18  -5.12616896398645E-02  -5.12616896371297E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.73486012035827E-09   0.00000000000000E+00  -2.73486012035827E-09
      4.44653837800892E-18  -4.90648664551569E-01  -4.90799827335166E-01   0.00000000000000E+00   8.60924758521839E-11
     -1.66360845539472E-22   3.93565110061031E-10   4.79657585913049E-10  -3.23737904091774E-18
      6.05768573004575E-09
      0.00000000000000E+00  -2.29519998281609E-12   0.00000000000000E+00   2.36556721763033E-12  -4.63474985787743E-23
      2.29281187175180E-09   2.29517743896938E-09  -1.20692199916136E-18  -5.25220957414367E-02  -5.25220957386401E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.79657885488079E-09   0.00000000000000E+00  -2.79657885488079E-09
      4.44383631109885E-18  -4.91311296129635E-01  -4.91469310309855E-01   0.00000000000000E+00   8.83573969843672E-11
     -1.66237473285172E-22   4.13044018928406E-10   5.01401415912607E-10  -3.23691431193749E-18
      6.05899010604152E-09
      0.00000000000000E+00  -2.34580643301744E-12   0.00000000000000E+00   2.23864291932507E-12  -4.62907555929168E-23
      2.34358387298704E-09   2.34582251590632E-09  -1.20383865745033E-18  -5.42554727738627E-02  -5.42554727709893E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.87339640517551E-09   0.00000000000000E+00  -2.87339640517551E-09
      4.44008832180160E-18  -4.92207487712132E-01  -4.92373748826237E-01   0.00000000000000E+00   9.12198012267763E-11
     -1.66065390554177E-22   4.36354088040930E-10   5.27573889267540E-10  -3.23624966435127E-18
      6.06075101363581E-09
      0.00000000000000E+00  -2.41046512801154E-12   0.00000000000000E+00   2.13623730232105E-12  -4.62125629077611E-23
      2.40831768567893E-09   2.41045392298121E-09  -1.19956854671535E-18  -5.66492144959786E-02  -5.66492144930083E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.97032064043490E-09   0.00000000000000E+00  -2.97032064043490E-09
      4.43485786162837E-18  -4.93419279743910E-01  -4.93595716383188E-01   0.00000000000000E+00   9.48129391704686E-11
     -1.65823748284332E-22   4.65053778283742E-10   5.59866717454045E-10  -3.23528931491302E-18
      6.06312823888811E-09
      0.00000000000000E+00  -2.49312539149831E-12   0.00000000000000E+00   2.04551720679188E-12  -4.61043722864977E-23
      2.49111069761911E-09   2.49315621482586E-09  -1.19362000632238E-18  -5.99708160029429E-02  -5.99708159998501E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.09278016517991E-09   0.00000000000000E+00  -3.09278016517991E-09
      4.42750562651991E-18  -4.95057155606070E-01  -4.95246119903148E-01   0.00000000000000E+00   9.92589563621966E-11
     -1.65481888859526E-22   5.00364993992293E-10   5.99623950354324E-10  -3.23388562019753E-18
      6.06633749297871E-09
      0.00000000000000E+00  -2.59984897613346E-12   0.00000000000000E+00   1.97363270508624E-12  -4.59538063443799E-23
      2.59788824119119E-09   2.59986187389623E-09  -1.18527410676294E-18  -6.46057650801716E-02  -6.46057650769237E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.24785975227948E-09   0.00000000000000E+00  -3.24785975227948E-09
      4.41708241932420E-18  -4.97269593954738E-01  -4.97473801220788E-01   0.00000000000000E+00   1.04698290841503E-10
     -1.64994352057191E-22   5.43299587541993E-10   6.47997878383330E-10  -3.23180831256126E-18
      6.07066998600102E-09
      0.00000000000000E+00  -2.74138171617026E-12   0.00000000000000E+00   1.94829627018130E-12  -4.57425752196317E-23
      2.73939345230548E-09   2.74134174857562E-09  -1.17345514845477E-18  -7.11196988387286E-02  -7.11196988352806E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.44796604716484E-09   0.00000000000000E+00  -3.44796604716484E-09
      4.40214413048370E-18  -5.00255662231619E-01  -5.00478343427874E-01   0.00000000000000E+00   1.11397577190254E-10
     -1.64292488345347E-22   5.95226721398645E-10   7.06624298588734E-10  -3.22868898202893E-18
      6.07651885158114E-09
      0.00000000000000E+00  -2.94059295117338E-12   0.00000000000000E+00   2.02209520477107E-12  -4.54424050512353E-23
      2.93860889501092E-09   2.94063099021565E-09  -1.15648267506870E-18  -8.03742314342306E-02  -8.03742314305110E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.71955375482685E-09   0.00000000000000E+00  -3.71955375482685E-09
      4.38038896055369E-18  -5.04281956050646E-01  -5.04527420137148E-01   0.00000000000000E+00   1.20009347705315E-10
     -1.63268344331493E-22   6.58913416906811E-10   7.78922764611963E-10  -3.22390628548499E-18
      6.08441482011430E-09
      0.00000000000000E+00  -3.24413980764426E-12   0.00000000000000E+00   2.24180883907984E-12  -4.50068799207361E-23
      3.24190915166819E-09   3.24415096050722E-09  -1.13158228257932E-18  -9.37456695045646E-02  -9.37456695004533E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.11131962145461E-09   0.00000000000000E+00  -4.11131962145461E-09
      4.34792611019291E-18  -5.09701711988830E-01  -5.09974986262256E-01   0.00000000000000E+00   1.31658909282474E-10
     -1.61743848334120E-22   7.35509751665255E-10   8.67168660947568E-10  -3.21634382761359E-18
      6.08974459887418E-09
      0.00000000000000E+00  -3.51581654030412E-12   0.00000000000000E+00   2.85499980077367E-12  -4.46903526419412E-23
      3.51294692277631E-09   3.51580192257704E-09  -1.11360290815212E-18  -1.03257417120559E-01  -1.03257417116111E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.44793497860052E-09   0.00000000000000E+00  -4.44793497860052E-09
      4.32421960081862E-18  -5.13347979555170E-01  -5.13641727664362E-01   0.00000000000000E+00   1.40287268323108E-10
     -1.60641429949513E-22   7.91845787700518E-10   9.32133056023466E-10  -3.21061669266651E-18
      6.09693980020003E-09
      0.00000000000000E+00  -3.86850033118103E-12   0.00000000000000E+00   2.76598769573779E-12  -4.42232231693261E-23
      3.86577927221351E-09   3.86854525990920E-09  -1.08754171438916E-18  -1.16827809799943E-01  -1.16827809795106E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.83702746597441E-09   0.00000000000000E+00  -4.83702746597441E-09
      4.28941621438231E-18  -5.18221839933049E-01  -5.18527050565565E-01   0.00000000000000E+00   1.49910964578702E-10
     -1.59040101585025E-22   8.18571241486559E-10   9.68482206065101E-10  -3.20187449999314E-18
      6.10665332198992E-09
      0.00000000000000E+00  -4.35261394100190E-12   0.00000000000000E+00   2.79403417565218E-12  -4.34433823753718E-23
      4.34982144841761E-09   4.35261548259322E-09  -1.04997728467565E-18  -1.35954787258399E-01  -1.35954787253167E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.23174466409190E-09   0.00000000000000E+00  -5.23174466409190E-09
      4.23859754858852E-18  -5.24574558490615E-01  -5.24851636020599E-01   0.00000000000000E+00   1.56868345606758E-10
     -1.56752419064791E-22   7.22260835891994E-10   8.79129181498596E-10  -3.18862026391287E-18
      6.11976657640626E-09
      0.00000000000000E+00  -5.15037732838648E-12   0.00000000000000E+00   3.30429403252885E-12  -4.15610604262786E-23
      5.14708964914334E-09   5.15039394317582E-09  -9.97134493146766E-19  -1.62044042980317E-01  -1.62044042974774E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.54278157825912E-09   0.00000000000000E+00  -5.54278157825912E-09
      4.16591364357855E-18  -5.32284932389296E-01  -5.32408698164858E-01   0.00000000000000E+00   1.57949491868875E-10
     -1.53581805397002E-22   2.34438143214658E-10   3.92387635083380E-10  -3.16877915043178E-18
      6.13746946986834E-09
      0.00000000000000E+00  -7.06671777022152E-12   0.00000000000000E+00   5.58597466269178E-12  -3.41733642503208E-23
      7.06117325072940E-09   7.06675922539206E-09  -9.26055328403491E-19  -1.95757453957194E-01  -1.95757453951447E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.74747426917322E-09   0.00000000000000E+00  -5.74747426917322E-09
      4.06416671891538E-18  -5.39424701658979E-01  -5.39009298608944E-01   0.00000000000000E+00   1.55273252032821E-10
     -1.49211152256318E-22  -1.47455820825141E-09  -1.31928495621874E-09  -3.13811139051189E-18
      6.15746946986834E-09
      0.00000000000000E+00  -1.15187077168820E-11   0.00000000000000E+00   1.11567986962623E-11  -9.57833215270233E-24
      1.15075452208319E-08   1.15187020195282E-08  -8.51212989062068E-19  -2.29773607543401E-01  -2.29773607537461E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.93978954464594E-09   0.00000000000000E+00  -5.93978954464594E-09
      3.94537092802246E-18  -5.39092168401699E-01  -5.37334956273676E-01   0.00000000000000E+00   1.57154412819723E-10
     -1.43826952433112E-22  -5.73606688770191E-09  -5.57891247488233E-09  -3.09415793896039E-18
      6.17746946986834E-09
      0.00000000000000E+00  -1.88817166093350E-11   0.00000000000000E+00   1.82855665847994E-11   3.73162895983279E-23
      1.88633948787612E-08   1.88816804453460E-08  -7.87166697470254E-19  -2.58007505861578E-01  -2.58007505855388E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19065164843845E-09   0.00000000000000E+00  -6.19065164843845E-09
      3.82155789505369E-18  -5.24991054562129E-01  -5.20993382278129E-01   0.00000000000000E+00   1.66186615936652E-10
     -1.37400304435048E-22  -1.28572154128440E-08  -1.26910287969075E-08  -3.03439119758344E-18
      6.19746946986834E-09
      0.00000000000000E+00  -2.76231313177985E-11   0.00000000000000E+00   2.16730253614478E-11   9.27877064939980E-23
      2.76014234635926E-08   2.76230964889542E-08  -7.37222767158376E-19  -2.79874020665215E-01  -2.79874020658736E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.47846141045986E-09   0.00000000000000E+00  -6.47846141045986E-09
      3.69198866684449E-18  -4.93653661927504E-01  -4.86992770261765E-01   0.00000000000000E+00   1.75221415184906E-10
     -1.29462329550963E-22  -2.13198564936791E-08  -2.11446350784943E-08  -2.95476589968612E-18
      6.21746946986834E-09
      0.00000000000000E+00  -3.49269003547527E-11   0.00000000000000E+00   1.81264588867698E-11   1.39752183494638E-22
      3.49088238237495E-08   3.49269502826364E-08  -7.01784100565133E-19  -2.95768873415686E-01  -2.95768873408924E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76222494482014E-09   0.00000000000000E+00  -6.76222494482014E-09
      3.55674416794809E-18  -4.44755625191848E-01  -4.35882937497698E-01   0.00000000000000E+00   1.74972524782778E-10
     -1.20141258176186E-22  -2.83396978625990E-08  -2.81647253378164E-08  -2.85496006738296E-18
      6.23746946986834E-09
      0.00000000000000E+00  -3.84044176396413E-11   0.00000000000000E+00   8.66118274084678E-12   1.64071719873253E-22
      3.83957964240477E-08   3.84044576067887E-08  -6.79796356284001E-19  -3.06395880838473E-01  -3.06395880831443E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.03005657694643E-09   0.00000000000000E+00  -7.03005657694643E-09
      3.41614303640916E-18  -3.80004688873232E-01  -3.70120538718829E-01   0.00000000000000E+00   1.63817247822189E-10
     -1.10216852584943E-22  -3.15382182776643E-08  -3.13744010298422E-08  -2.73634668012516E-18
      6.25746946986834E-09
      0.00000000000000E+00  -3.74662236490664E-11   0.00000000000000E+00  -2.28185557586389E-12   1.61989475433621E-22
      3.74685372646318E-08   3.74662554090561E-08  -6.68915996668193E-19  -3.12793430620420E-01  -3.12793430613159E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26097782488319E-09   0.00000000000000E+00  -7.26097782488319E-09
      3.27092347991150E-18  -3.04316521358817E-01  -2.94800443479434E-01   0.00000000000000E+00   1.40750043385552E-10
     -1.00396734152948E-22  -3.03460276275585E-08  -3.02052775841730E-08  -2.60200748324330E-18
      6.27746946986834E-09
      0.00000000000000E+00  -3.46091175640146E-11   0.00000000000000E+00  -7.05228708084102E-12   1.45343355760958E-22
      3.46161344147203E-08   3.46090821276396E-08  -6.62809429332352E-19  -3.17439192072824E-01  -3.17439192065477E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34742073919689E-09   0.00000000000000E+00  -7.34742073919689E-09
      3.12397506512756E-18  -2.29573551226137E-01  -2.20984674118530E-01   0.00000000000000E+00   1.02638393176768E-10
     -9.01594884493779E-23  -2.73642997816192E-08  -2.72616613884426E-08  -2.46116563579521E-18
      6.29746946986834E-09
      0.00000000000000E+00  -3.21127776067141E-11   0.00000000000000E+00  -6.16985015492340E-12   1.26864330457594E-22
      3.21188975210402E-08   3.21127276708854E-08  -6.56302109057464E-19  -3.22296497380637E-01  -3.22296497373339E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29755883061538E-09   0.00000000000000E+00  -7.29755883061538E-09
      2.97802388851525E-18  -1.63232214346371E-01  -1.55413994949004E-01   0.00000000000000E+00   6.72027459720249E-11
     -8.23668891474533E-23  -2.48823715862420E-08  -2.48151688402700E-08  -2.32172177945779E-18
      6.30746946986834E-09
      0.00000000000000E+00  -3.08111539910090E-11   0.00000000000000E+00  -6.42870370934349E-12   1.17135474832137E-22
      3.08176076392497E-08   3.08111789355405E-08  -6.53164071853813E-19  -3.24692237055940E-01  -3.24692237048660E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28004386061891E-09   0.00000000000000E+00  -7.28004386061891E-09
      2.90522344990906E-18  -1.32350646160028E-01  -1.24936927911818E-01   0.00000000000000E+00   5.14385138120328E-11
     -7.97186800590585E-23  -2.35825735887335E-08  -2.35311350749216E-08  -2.25205937805525E-18
      6.32096946986834E-09
      0.00000000000000E+00  -2.94844567620463E-11   0.00000000000000E+00  -4.85474013240521E-12   1.06486285499089E-22
      2.94893295523405E-08   2.94844748122082E-08  -6.47451732107230E-19  -3.28496560605291E-01  -3.28496560598099E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19245996346455E-09   0.00000000000000E+00  -7.19245996346455E-09
      2.80812524040229E-18  -9.52917721599943E-02  -8.82684088249107E-02   0.00000000000000E+00   3.93604581145235E-11
     -7.40103205656742E-23  -2.23313753068581E-08  -2.22920148487437E-08  -2.16067350829506E-18
      6.33919446986834E-09
      0.00000000000000E+00  -2.73875495668612E-11   0.00000000000000E+00  -5.66756734318685E-12   9.85468158276634E-23
      2.73932881800111E-08   2.73876206126680E-08  -6.34574822735268E-19  -3.35454252232420E-01  -3.35454252225421E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.99919352156620E-09   0.00000000000000E+00  -6.99919352156620E-09
      2.68056493847175E-18  -5.61543592022994E-02  -4.97307059117900E-02   0.00000000000000E+00   2.88686431708555E-11
     -4.44246524005742E-23  -2.04172957342726E-08  -2.03884270911018E-08  -2.04599011573648E-18
      6.34419446986834E-09
      0.00000000000000E+00  -2.62123043095537E-11   0.00000000000000E+00  -1.15379891868592E-11   9.70082927583791E-23
      2.62238018296999E-08   2.62122638405132E-08  -6.30088334656872E-19  -3.37660172176187E-01  -3.37660172169277E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.91010612547472E-09   0.00000000000000E+00  -6.91010612547472E-09
      2.64601440784437E-18  -4.70789010997062E-02  -4.09974837717304E-02   0.00000000000000E+00   2.87531747725187E-11
     -2.76679593221273E-23  -1.93309108898110E-08  -1.93021577150385E-08  -2.01592607318750E-18
      6.35094446986834E-09
      0.00000000000000E+00  -2.48105699302924E-11   0.00000000000000E+00  -1.02411267658964E-11   9.77470881469016E-23
      2.48207638049147E-08   2.48105226781489E-08  -6.21799918997960E-19  -3.41415964944286E-01  -3.41415964937553E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73215381362641E-09   0.00000000000000E+00  -6.73215381362641E-09
      2.60057236960239E-18  -3.77353080782812E-02  -3.20394534502102E-02   0.00000000000000E+00   2.34212459816204E-11
     -3.67199332251564E-25  -1.81017901105039E-08  -1.80783688645223E-08  -1.97877245060443E-18
      6.36005696986834E-09
      0.00000000000000E+00  -2.32952236111055E-11   0.00000000000000E+00  -8.18857831993775E-12   1.03001982847747E-22
      2.33033624805667E-08   2.32951739022469E-08  -6.07489602965085E-19  -3.47557827470086E-01  -3.47557827463570E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.51670259934856E-09   0.00000000000000E+00  -6.51670259934856E-09
      2.54118891716583E-18  -2.92326604226596E-02  -2.39463484569675E-02   0.00000000000000E+00   1.80475590652938E-11
      3.74852275992265E-23  -1.67965188619638E-08  -1.67784713028984E-08  -1.93369931420075E-18
      6.37235884486834E-09
      0.00000000000000E+00  -2.19305945056760E-11   0.00000000000000E+00  -5.44724637520960E-12   1.14068049565189E-22
      2.19360227549466E-08   2.19305755085715E-08  -5.85109232743976E-19  -3.56873871205282E-01  -3.56873871198972E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.31012232498786E-09   0.00000000000000E+00  -6.31012232498786E-09
      2.46356258108912E-18  -2.24070931406723E-02  -1.74856237676785E-02   0.00000000000000E+00   1.28051335514770E-11
      8.32380384430264E-23  -1.56332583171352E-08  -1.56204531835836E-08  -1.87845334834515E-18
      6.38896637611834E-09
      0.00000000000000E+00  -2.08550926329759E-11   0.00000000000000E+00  -3.16246477543399E-12   1.29160184772974E-22
      2.08582022290436E-08   2.08550397642683E-08  -5.53352366313136E-19  -3.69910538616537E-01  -3.69910538610399E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.13835411077354E-09   0.00000000000000E+00  -6.13835411077354E-09
      2.36161967337088E-18  -1.73390249142434E-02  -1.27022939877805E-02   0.00000000000000E+00   8.78186351133441E-12
      1.33027268976443E-22  -1.47254675170062E-08  -1.47166856534948E-08  -1.80826730705775E-18
      6.40896637611834E-09
      0.00000000000000E+00  -2.00068146401272E-11   0.00000000000000E+00  -2.05808742167928E-12   1.40580698923810E-22
      2.00088794236529E-08   2.00068213362314E-08  -5.15878444798659E-19  -3.85257614058920E-01  -3.85257614052918E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.00145932600817E-09   0.00000000000000E+00  -6.00145932600817E-09
      2.24159048685072E-18  -1.38964660421807E-02  -9.48384292980271E-03   0.00000000000000E+00   6.46748489785480E-12
      1.73097839143866E-22  -1.40118294951212E-08  -1.40053620102232E-08  -1.72571204205206E-18
      6.42896637611834E-09
      0.00000000000000E+00  -1.92913441372805E-11   0.00000000000000E+00  -1.73260311613231E-12   1.41753301610291E-22
      1.92931552402986E-08   1.92914226371826E-08  -4.80250570563804E-19  -3.99911198210017E-01  -3.99911198204126E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.89128917702451E-09   0.00000000000000E+00  -5.89128917702451E-09
      2.12376470331023E-18  -1.17281999084129E-02  -7.50625963595942E-03   0.00000000000000E+00   5.32099080392356E-12
      1.90768251668894E-22  -1.34054544509623E-08  -1.34001334601582E-08  -1.64351413274643E-18
      6.44896637611834E-09
      0.00000000000000E+00  -1.86513700084185E-11   0.00000000000000E+00  -1.55015797933072E-12   1.32965220935713E-22
      1.86528730874619E-08   1.86513229294827E-08  -4.46561981837857E-19  -4.13866096743473E-01  -4.13866096737681E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.79242900942574E-09   0.00000000000000E+00  -5.79242900942574E-09
      2.00791612312172E-18  -1.02379636789431E-02  -6.18654663458525E-03   0.00000000000000E+00   4.57952564555015E-12
      1.87774082165572E-22  -1.28634734457027E-08  -1.28588939200569E-08  -1.56135414128386E-18
      6.46896637611834E-09
      0.00000000000000E+00  -1.80967196404222E-11   0.00000000000000E+00  -1.34227142651898E-12   1.16578537278259E-22
      1.80980537662006E-08   1.80967114947742E-08  -4.14565287580699E-19  -4.27212948184123E-01  -4.27212948178420E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.70315660977281E-09   0.00000000000000E+00  -5.70315660977281E-09
      1.89385299092626E-18  -9.16529246847344E-03  -5.26048566596388E-03   0.00000000000000E+00   3.97868632682280E-12
      1.68835302501776E-22  -1.23975335713285E-08  -1.23935548850015E-08  -1.47928770334556E-18
      6.48896637611834E-09
      0.00000000000000E+00  -1.76278522569778E-11   0.00000000000000E+00  -1.13319305981797E-12   9.58193923650685E-23
      1.76289466406592E-08   1.76278134475994E-08  -3.83967087667475E-19  -4.40048230550558E-01  -4.40048230544935E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62272130136312E-09   0.00000000000000E+00  -5.62272130136312E-09
      1.78139856489900E-18  -8.36748079243649E-03  -4.58506355377541E-03   0.00000000000000E+00   3.47976395515989E-12
      1.40093233647064E-22  -1.20085719101916E-08  -1.20050921462363E-08  -1.39743147723152E-18
      6.50896637611834E-09
      0.00000000000000E+00  -1.72841692503473E-11   0.00000000000000E+00  -8.26059678400510E-13   7.40127012915584E-23
      1.72850418286281E-08   1.72842157689498E-08  -3.54294600913524E-19  -4.52551365609251E-01  -4.52551365603659E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59220515540342E-09   0.00000000000000E+00  -5.59220515540342E-09
      1.66955446179093E-18  -7.76568253960567E-03  -4.08190508628078E-03   0.00000000000000E+00   3.06752881064963E-12
      1.07740156213496E-22  -1.16950781423571E-08  -1.16920106135463E-08  -1.31525986087741E-18
      6.52896637611834E-09
      0.00000000000000E+00  -1.73850147718011E-11   0.00000000000000E+00   2.68205009557528E-13   5.40562813487593E-23
      1.73847264149563E-08   1.73849946199659E-08  -3.23807876916250E-19  -4.65464204613321E-01  -4.65464204607456E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86492140908118E-09   0.00000000000000E+00  -5.86492140908118E-09
      1.55225603360930E-18  -7.36876106759830E-03  -3.73915365360807E-03   0.00000000000000E+00   2.63958309505356E-12
      7.69726741402633E-23  -1.15227127939800E-08  -1.15200732108849E-08  -1.22844815669305E-18
      6.54896637611834E-09
      0.00000000000000E+00  -1.77762733523052E-11   0.00000000000000E+00   9.85966546276756E-13   3.73287660666468E-23
      1.77752974018301E-08   1.77762833683764E-08  -2.92027010646532E-19  -4.79023872797593E-01  -4.79023872791315E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.27871188824016E-09   0.00000000000000E+00  -6.27871188824016E-09
      1.42668179584450E-18  -7.12292053767667E-03  -3.50040084074151E-03   0.00000000000000E+00   2.23442054596349E-12
      5.06841222255243E-23  -1.14998059006822E-08  -1.14975714801362E-08  -1.13465478519797E-18
      6.55896637611834E-09
      0.00000000000000E+00  -1.79657490451643E-11   0.00000000000000E+00   9.56771322331404E-13   2.96353568356597E-23
      1.79647975116453E-08   1.79657542829677E-08  -2.76076040151158E-19  -4.85885632002829E-01  -4.85885631996350E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.47899523518353E-09   0.00000000000000E+00  -6.47899523518353E-09
      1.36189184349267E-18  -7.01627896540141E-03  -3.39716504557135E-03   0.00000000000000E+00   2.15600661085172E-12
      3.84802206614959E-23  -1.14889150543950E-08  -1.14867590477841E-08  -1.08581580334151E-18
      6.57246637611834E-09
      0.00000000000000E+00  -1.81259262668542E-11   0.00000000000000E+00   6.07781788408777E-13   2.15744037689367E-23
      1.81253423148499E-08   1.81259500966384E-08  -2.54594943619371E-19  -4.95179882014255E-01  -4.95179882007658E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.59750302946145E-09   0.00000000000000E+00  -6.59750302946145E-09
      1.27282555259494E-18  -6.89957850277841E-03  -3.26732880042885E-03   0.00000000000000E+00   1.88550859954314E-12
      2.58236141168554E-23  -1.15303325757765E-08  -1.15284470671769E-08  -1.01823060897557E-18
      6.59069137611834E-09
      0.00000000000000E+00  -1.82886751411860E-11   0.00000000000000E+00   4.60842903400462E-13   1.41931117072778E-23
      1.82882223629184E-08   1.82886832058218E-08  -2.26167177860569E-19  -5.07608883221624E-01  -5.07608883214958E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66587221351715E-09   0.00000000000000E+00  -6.66587221351715E-09
      1.15134003150359E-18  -6.77905924477617E-03  -3.11707693602562E-03   0.00000000000000E+00   1.66971286329239E-12
      1.43447503754797E-23  -1.16244807051679E-08  -1.16228109923046E-08  -9.25172853643017E-19
      6.59569137611834E-09
      0.00000000000000E+00  -1.84008175653164E-11   0.00000000000000E+00   1.11957840421053E-12   1.23358659105499E-23
      1.83997011207591E-08   1.84008206991633E-08  -2.18472235237399E-19  -5.11009187403182E-01  -5.11009187396447E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73451845741218E-09   0.00000000000000E+00  -6.73451845741218E-09
      1.11766743921652E-18  -6.76534271352601E-03  -3.08965718849152E-03   0.00000000000000E+00   1.42252684507176E-12
      1.14072625305188E-23  -1.16677247685961E-08  -1.16663022417510E-08  -8.99195203979127E-19
      6.60244137611834E-09
      0.00000000000000E+00  -1.85559433264599E-11   0.00000000000000E+00   1.15271552474334E-12   1.03416184962913E-23
      1.85547674510510E-08   1.85559201665757E-08  -2.08145183401140E-19  -5.15592733256343E-01  -5.15592733249574E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76886021521454E-09   0.00000000000000E+00  -6.76886021521454E-09
      1.07197763276383E-18  -6.77470522799170E-03  -3.06097204432383E-03   0.00000000000000E+00   9.34187583399307E-13
      8.29783634048608E-24  -1.17879941389447E-08  -1.17870599513613E-08  -8.63832449362687E-19
      6.61155387611834E-09
      0.00000000000000E+00  -1.86526558347394E-11   0.00000000000000E+00   5.45549012070796E-13   8.36181482953334E-24
      1.86521561741862E-08   1.86527017231983E-08  -1.94552670217860E-19  -5.21657769158359E-01  -5.21657769151652E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70745251303925E-09   0.00000000000000E+00  -6.70745251303925E-09
      1.01085597173876E-18  -6.77820374084761E-03  -3.01462938350426E-03   0.00000000000000E+00   8.86900090133927E-13
      5.27989313876877E-24  -1.19461361102492E-08  -1.19452492101590E-08  -8.16303301520897E-19
      6.62385575111834E-09
      0.00000000000000E+00  -1.84307589496460E-11   0.00000000000000E+00  -8.68561048241981E-13   6.52326845037687E-24
      1.84316381558392E-08   1.84307695947910E-08  -1.77569910542169E-19  -5.29282325539670E-01  -5.29282325533322E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.34784413622682E-09   0.00000000000000E+00  -6.34784413622682E-09
      9.32765586655412E-19  -6.72742138156093E-03  -2.92046872858640E-03   0.00000000000000E+00   1.03564327711494E-12
      2.63863552136967E-24  -1.20839611018412E-08  -1.20829254585641E-08  -7.55195676113242E-19
      6.64046328236834E-09
      0.00000000000000E+00  -1.72560647607617E-11   0.00000000000000E+00  -3.47107752480611E-12   4.85881657574409E-24
      1.72595618653612E-08   1.72560907878364E-08  -1.59645359956621E-19  -5.37361491871746E-01  -5.37361491866643E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.10346311372688E-09   0.00000000000000E+00  -5.10346311372688E-09
      8.48009663510970E-19  -6.55366859005533E-03  -2.72475402552983E-03   0.00000000000000E+00   1.01765548107139E-12
      5.59631237244688E-25  -1.21536453295907E-08  -1.21526276741097E-08  -6.88364303554348E-19
      6.66046328236834E-09
      0.00000000000000E+00  -1.38714943499272E-11   0.00000000000000E+00  -8.33476704225877E-12   3.25178531388375E-24
      1.38798421210463E-08   1.38715073540040E-08  -1.52764361803130E-19  -5.40326250435414E-01  -5.40326250433703E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71047673812438E-09   0.00000000000000E+00  -1.71047673812438E-09
      8.13800128748482E-19  -6.17944277082076E-03  -2.34787962657212E-03   0.00000000000000E+00   3.86304618210330E-13
     -9.81260067271250E-25  -1.21614169204979E-08  -1.21610306158797E-08  -6.61035766945353E-19
      6.68046328236834E-09
      0.00000000000000E+00  -7.69759927010003E-12   0.00000000000000E+00  -1.52180302340869E-11   1.39756949724296E-24
      7.71274862354199E-09   7.69753059330791E-09  -1.72092467916569E-19  -5.31182444436245E-01  -5.31182444440698E-01
      0.00000000000000E+00   0.00000000000000E+00   4.45308837835460E-09   0.00000000000000E+00   4.45308837835460E-09
      9.02861896315575E-19  -5.59026876335198E-03  -1.76198502550054E-03   0.00000000000000E+00  -1.00059756811626E-12
     -2.45544213059239E-24  -1.21496183740942E-08  -1.21506189716624E-08  -7.30769428399006E-19
      6.70046328236834E-09
      0.00000000000000E+00   3.64256227765051E-13   0.00000000000000E+00  -1.98860918012682E-11  -1.43368609104810E-24
     -3.44369549895071E-10  -3.64255641696341E-10  -2.28683263090451E-19  -5.05565771200281E-01  -5.05565771212777E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24961754778472E-08   0.00000000000000E+00   1.24961754778472E-08
      1.15278540587252E-18  -4.84135757247135E-03  -1.01896536743027E-03   0.00000000000000E+00  -3.15775207297220E-12
     -5.27429294463218E-24  -1.21287620840779E-08  -1.21319198361509E-08  -9.24102142782068E-19
      6.72046328236834E-09
      0.00000000000000E+00   7.75197135452688E-12   0.00000000000000E+00  -1.82733555698794E-11  -7.21398181835743E-24
     -7.73363640171114E-09  -7.75190975728103E-09  -3.29846335699774E-19  -4.62199504298574E-01  -4.62199504318422E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98482090312082E-08   0.00000000000000E+00   1.98482090312082E-08
      1.54974958649668E-18  -4.09276629784919E-03  -2.81598231437547E-04   0.00000000000000E+00  -6.29681820013373E-12
     -1.36524801063718E-23  -1.20900024557271E-08  -1.20962992739272E-08  -1.21990325079691E-18
      6.74046328236834E-09
      0.00000000000000E+00   1.18241833128342E-11   0.00000000000000E+00  -1.01835314544733E-11  -2.04629659769153E-23
     -1.18139872639033E-08  -1.18241707953578E-08  -4.78244830287235E-19  -4.02254895371801E-01  -4.02254895395667E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38653270669939E-08   0.00000000000000E+00   2.38653270669939E-08
      2.02705612783656E-18  -3.51652542942912E-03   2.77266173012844E-04   0.00000000000000E+00  -1.14587336186809E-11
     -3.72778608815576E-23  -1.20296975380174E-08  -1.20411562716361E-08  -1.54881129754933E-18
      6.76046328236834E-09
      0.00000000000000E+00   1.13457640767202E-11   0.00000000000000E+00   9.30824992957445E-13  -3.61432153882486E-23
     -1.13466865502091E-08  -1.13457557252162E-08  -6.61234999878481E-19  -3.29103490650232E-01  -3.29103490673470E-01
      0.00000000000000E+00   0.00000000000000E+00   2.32374720340636E-08   0.00000000000000E+00   2.32374720340636E-08
      2.49180556851783E-18  -3.78786123112819E-03  -4.11582353926401E-05   0.00000000000000E+00  -2.06517692376913E-11
     -6.71274763990661E-23  -1.18710645396096E-08  -1.18917163088473E-08  -1.83057056863935E-18
      6.78046328236834E-09
      0.00000000000000E+00   8.73985334793104E-12   0.00000000000000E+00   6.06876243972333E-12  -4.16049058025335E-23
     -8.74595009835140E-09  -8.73988133591172E-09  -8.37315965995250E-19  -2.52685426580388E-01  -2.52685426600109E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97207486261649E-08   0.00000000000000E+00   1.97207486261649E-08
      2.88622054104113E-18  -1.01578055891488E-02  -6.69808714473389E-03   0.00000000000000E+00  -3.42192290141865E-11
     -7.84471551673237E-23  -1.09466480612391E-08  -1.09808672902533E-08  -2.04890457504588E-18
      6.80046328236834E-09
      0.00000000000000E+00   7.00582470945293E-12   0.00000000000000E+00   3.84475767190574E-12  -4.36505879410062E-23
     -7.00963279145204E-09  -7.00578803378017E-09  -9.80131050180315E-19  -1.83527644518259E-01  -1.83527644534608E-01
      0.00000000000000E+00   0.00000000000000E+00   1.63496327871930E-08   0.00000000000000E+00   1.63496327871930E-08
      3.21321319678499E-18  -2.70394665133369E-02  -2.40955217698866E-02   0.00000000000000E+00  -5.34169431101942E-11
     -8.63703596444084E-23  -9.29042781030247E-09  -9.34384475341275E-09  -2.23308214660468E-18
      6.81046328236834E-09
      0.00000000000000E+00   6.17352770087833E-12   0.00000000000000E+00   3.59708854508231E-12  -4.45684994579829E-23
     -6.17709030843538E-09  -6.17349321989034E-09  -1.04236265968224E-18  -1.51242989674929E-01  -1.51242989689567E-01
      0.00000000000000E+00   0.00000000000000E+00   1.46374746079672E-08   0.00000000000000E+00   1.46374746079672E-08
      3.35958794286466E-18  -3.80893492510504E-02  -3.54226132062832E-02   0.00000000000000E+00  -7.34614682940155E-11
     -9.07322476775949E-23  -8.39051991978276E-09  -8.46398138807686E-09  -2.31722528318242E-18
      6.82396328236834E-09
      0.00000000000000E+00   5.35684429762900E-12   0.00000000000000E+00   2.45503951133770E-12  -4.56997839968776E-23
     -5.35928062278674E-09  -5.35682558327545E-09  -1.11426634456968E-18  -1.12123337672176E-01  -1.12123337685168E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29913351936595E-08   0.00000000000000E+00   1.29913351936595E-08
      3.53497096797907E-18  -5.58132931517267E-02  -5.34078962421608E-02   0.00000000000000E+00  -9.15210060325843E-11
     -9.66478032076560E-23  -7.54298860435142E-09  -7.63450961038410E-09  -2.42070462340939E-18
      6.84218828236834E-09
      0.00000000000000E+00   4.25470745113868E-12   0.00000000000000E+00   2.45948435479436E-12  -4.69291002573230E-23
     -4.25712658591096E-09  -4.25466710155621E-09  -1.19063144539648E-18  -6.83023120332095E-02  -6.83023120440930E-02
      0.00000000000000E+00   0.00000000000000E+00   1.08835648045085E-08   0.00000000000000E+00   1.08835648045085E-08
      3.73332393654123E-18  -8.36192442199458E-02  -8.15306834469308E-02   0.00000000000000E+00  -1.12420709041375E-10
     -1.04480114604493E-22  -6.51647699391077E-09  -6.62889770295225E-09  -2.54269249114476E-18
      6.84718828236834E-09
      0.00000000000000E+00   3.67140152513367E-12   0.00000000000000E+00   5.20925340780390E-12  -4.72034401436842E-23
     -3.67661936128102E-09  -3.67141010787327E-09  -1.20864990795709E-18  -5.76282906444652E-02  -5.76282906542744E-02
      0.00000000000000E+00   0.00000000000000E+00   9.80921567014004E-09   0.00000000000000E+00   9.80921567014004E-09
      3.78237001489193E-18  -9.18094981364884E-02  -8.98756546293758E-02   0.00000000000000E+00  -1.26762647139692E-10
     -1.06651112751375E-22  -6.01104291512687E-09  -6.13780556226667E-09  -2.57372010693485E-18
      6.85393828236834E-09
      0.00000000000000E+00   2.93838867748040E-12   0.00000000000000E+00   4.92443551029386E-12  -4.74925547500639E-23
     -2.94326704262375E-09  -2.93834260711350E-09  -1.22800903840559E-18  -4.59571109606380E-02  -4.59571109691682E-02
      0.00000000000000E+00   0.00000000000000E+00   8.53020333796743E-09   0.00000000000000E+00   8.53020333796743E-09
      3.83994888742321E-18  -1.03689369422193E-01  -1.01927536333868E-01   0.00000000000000E+00  -1.28273131938434E-10
     -1.09446748635398E-22  -5.46358759891533E-09  -5.59186073085388E-09  -2.61193984901763E-18
      6.86305078236834E-09
      0.00000000000000E+00   2.06678212138097E-12   0.00000000000000E+00   4.40456906428337E-12  -4.77499866691372E-23
     -2.07121553881079E-09  -2.06681096974656E-09  -1.24619097703206E-18  -3.47461536172479E-02  -3.47461536242430E-02
      0.00000000000000E+00   0.00000000000000E+00   6.99514915534292E-09   0.00000000000000E+00   6.99514915534292E-09
      3.90369218410127E-18  -1.20892912108200E-01  -1.19340135275210E-01   0.00000000000000E+00  -1.26931812655406E-10
     -1.12953604365848E-22  -4.80140637294078E-09  -4.92833818559630E-09  -2.65750120706922E-18
      6.87535265736834E-09
      0.00000000000000E+00   1.23889366019233E-12   0.00000000000000E+00   3.13696537626119E-12  -4.79384694415929E-23
     -1.24198199709975E-09  -1.23884503172354E-09  -1.26055336947100E-18  -2.55867120141309E-02  -2.55867120196007E-02
      0.00000000000000E+00   0.00000000000000E+00   5.46979965950121E-09   0.00000000000000E+00   5.46979965950121E-09
      3.97098097578750E-18  -1.45180310485159E-01  -1.43847258281232E-01   0.00000000000000E+00  -1.25034012571562E-10
     -1.17285730823064E-22  -4.10592061520604E-09  -4.23095462777772E-09  -2.71042760631650E-18
      6.89196018861834E-09
      0.00000000000000E+00   6.55771423661741E-13   0.00000000000000E+00   1.64615335363554E-12  -4.80542975124274E-23
     -6.57370444416701E-10  -6.55724291063113E-10  -1.27028046886151E-18  -1.90212974717951E-02  -1.90212974760467E-02
      0.00000000000000E+00   0.00000000000000E+00   4.25160309235932E-09   0.00000000000000E+00   4.25160309235932E-09
      4.04158960700646E-18  -1.77713636364859E-01  -1.76580677110313E-01   0.00000000000000E+00  -1.24631661656419E-10
     -1.22634132420760E-22  -3.47124713963974E-09  -3.59587880129628E-09  -2.77130913814495E-18
      6.91196018861834E-09
      0.00000000000000E+00   3.53969617197808E-13   0.00000000000000E+00   7.08982219446174E-13  -4.81125994193926E-23
     -3.54686603280256E-10  -3.53977621060858E-10  -1.27599634164657E-18  -1.48368451937957E-02  -1.48368451971765E-02
      0.00000000000000E+00   0.00000000000000E+00   3.38081487845204E-09   0.00000000000000E+00   3.38081487845204E-09
      4.10920590457550E-18  -2.13950903537910E-01  -2.12997231094772E-01   0.00000000000000E+00  -1.23901672984865E-10
     -1.28467571923084E-22  -2.90293558440616E-09  -3.02683725739116E-09  -2.83320956292893E-18
      6.93196018861834E-09
      0.00000000000000E+00   2.26397277216553E-13   0.00000000000000E+00   3.00467189745443E-13  -4.81377042681649E-23
     -2.26714824990917E-10  -2.26414357801220E-10  -1.27919345461756E-18  -1.23359006540012E-02  -1.23359006567150E-02
      0.00000000000000E+00   0.00000000000000E+00   2.71386806258195E-09   0.00000000000000E+00   2.71386806258195E-09
      4.16348326582714E-18  -2.45132313843911E-01  -2.44348583890224E-01   0.00000000000000E+00  -1.17302858175816E-10
     -1.33539193340962E-22  -2.37015084660482E-09  -2.48745370478077E-09  -2.88428981120958E-18
      6.95196018861835E-09
      0.00000000000000E+00   1.71565969103660E-13   0.00000000000000E+00   1.29828610539405E-13  -4.81489658130897E-23
     -1.71714346960726E-10  -1.71584518350235E-10  -1.28132029235394E-18  -1.06636685912385E-02  -1.06636685933719E-02
      0.00000000000000E+00   0.00000000000000E+00   2.13333083962002E-09   0.00000000000000E+00   2.13333083962002E-09
      4.20614988261954E-18  -2.70078980662322E-01  -2.69460886267055E-01   0.00000000000000E+00  -1.01891150793107E-10
     -1.37659413454739E-22  -1.85985517047649E-09  -1.96174632126973E-09  -2.92482959026559E-18
      6.97196018861835E-09
      0.00000000000000E+00   1.44747305839062E-13   0.00000000000000E+00   6.47899498706915E-14  -4.81533042893964E-23
     -1.44816142824881E-10  -1.44751352875058E-10  -1.28293099532918E-18  -9.47515916032281E-03  -9.47515916195276E-03
      0.00000000000000E+00   0.00000000000000E+00   1.62994513490405E-09   0.00000000000000E+00   1.62994513490405E-09
      4.23874878531762E-18  -2.88780365036058E-01  -2.88312420700341E-01   0.00000000000000E+00  -8.09583204319861E-11
     -1.40778042492123E-22  -1.40423546159685E-09  -1.48519378202898E-09  -2.95581778998844E-18
      6.99196018861835E-09
      0.00000000000000E+00   1.30235837360273E-13   0.00000000000000E+00   3.64330161902618E-14  -4.81539491109158E-23
     -1.30258203140270E-10  -1.30221770124128E-10  -1.28426677117614E-18  -8.60058183468469E-03  -8.60058183589379E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20910207849245E-09   0.00000000000000E+00   1.20910207849245E-09
      4.26293082688747E-18  -3.01865721821360E-01  -3.01525798244926E-01   0.00000000000000E+00  -5.83938893047759E-11
     -1.42957218117547E-22  -1.02048641906345E-09  -1.07888030836837E-09  -2.97866405571133E-18
      7.01196018861835E-09
      0.00000000000000E+00   1.22245345223218E-13   0.00000000000000E+00   2.12864302936727E-14  -4.81527630803376E-23
     -1.22225591569146E-10  -1.22204305138900E-10  -1.28545386074975E-18  -7.93905804623329E-03  -7.93905804709523E-03
      0.00000000000000E+00   0.00000000000000E+00   8.61945386232727E-10   0.00000000000000E+00   8.61945386232727E-10
      4.28016973461212E-18  -3.10105524500833E-01  -3.09872457331228E-01   0.00000000000000E+00  -3.65963824786423E-11
     -1.44302798788061E-22  -7.03144698615053E-10  -7.39741081093839E-10  -2.99471587386237E-18
      7.03196018861835E-09
      0.00000000000000E+00   1.11866889918768E-13   0.00000000000000E+00   2.83142695342106E-14  -4.81483243826463E-23
     -1.11904136829946E-10  -1.11875822560460E-10  -1.28644367941950E-18  -7.47312452124865E-03  -7.47312452187897E-03
      0.00000000000000E+00   0.00000000000000E+00   6.30315067087731E-10   0.00000000000000E+00   6.30315067087731E-10
      4.29277603595388E-18  -3.15229021103912E-01  -3.15065682222751E-01   0.00000000000000E+00  -2.15408247548759E-11
     -1.45092870174065E-22  -4.96898419772147E-10  -5.18439244527168E-10  -3.00633235653437E-18
      7.05196018861835E-09
      0.00000000000000E+00   9.64369740679031E-14   0.00000000000000E+00   4.32069979167566E-14  -4.81386548227725E-23
     -9.64762423149232E-11  -9.64330353170546E-11  -1.28713387678615E-18  -7.19405061075067E-03  -7.19405061131809E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67414847342830E-10   0.00000000000000E+00   5.67414847342830E-10
      4.30412433290073E-18  -3.19886749559804E-01  -3.19738363515057E-01   0.00000000000000E+00  -1.89273476786661E-11
     -1.45774973487621E-22  -4.52054464346992E-10  -4.70981812025804E-10  -3.01699045611458E-18
      7.07196018861835E-09
      0.00000000000000E+00   8.83546371936407E-14   0.00000000000000E+00   2.60911926358996E-14  -4.81271976125948E-23
     -8.83902250510047E-11  -8.83641338584169E-11  -1.28767243772214E-18  -6.98511852542273E-03  -6.98511852600581E-03
      0.00000000000000E+00   0.00000000000000E+00   5.83073445437881E-10   0.00000000000000E+00   5.83073445437881E-10
      4.31578580180949E-18  -3.25020867634196E-01  -3.24865005318236E-01   0.00000000000000E+00  -2.13671652519796E-11
     -1.46528197851377E-22  -4.73342146327290E-10  -4.94709311579416E-10  -3.02811336408734E-18
      7.07321018861835E-09
      0.00000000000000E+00   1.00110763556204E-13   0.00000000000000E+00  -4.42247735556005E-13  -4.81276231041856E-23
     -9.97129611050642E-11  -1.00155208840668E-10  -1.28772087078153E-18  -6.96356712113277E-03  -6.96356712168866E-03
      0.00000000000000E+00   0.00000000000000E+00   5.55890920224941E-10   0.00000000000000E+00   5.55890920224941E-10
      4.31648066545977E-18  -3.25282864137020E-01  -3.25139282314933E-01   0.00000000000000E+00  -1.69960027552061E-11
     -1.46566901331259E-22  -4.38739708630533E-10  -4.55735711385885E-10  -3.02875979467824E-18
      7.07489768861835E-09
      0.00000000000000E+00   9.46000793237526E-14   0.00000000000000E+00   1.48678944591971E-13  -4.81264095426298E-23
     -9.47878254392833E-11  -9.46391464947394E-11  -1.28777701062369E-18  -6.94139129684581E-03  -6.94139129738550E-03
      0.00000000000000E+00   0.00000000000000E+00   5.39686817889953E-10   0.00000000000000E+00   5.39686817889953E-10
      4.31739138696496E-18  -3.25643469225311E-01  -3.25503254624701E-01   0.00000000000000E+00  -1.73290370806873E-11
     -1.46618706266504E-22  -4.27718634314046E-10  -4.45047671394880E-10  -3.02961437634127E-18
      7.07717581361835E-09
      0.00000000000000E+00   8.71606556099429E-14   0.00000000000000E+00   1.67528875221861E-13  -4.81246462798320E-23
     -8.73319964506945E-11  -8.71644675755207E-11  -1.28783589211499E-18  -6.92100116852535E-03  -6.92100116906645E-03
      0.00000000000000E+00   0.00000000000000E+00   5.41101404986689E-10   0.00000000000000E+00   5.41101404986689E-10
      4.31862408360320E-18  -3.26163178910583E-01  -3.26020163214091E-01   0.00000000000000E+00  -1.85916223216605E-11
     -1.46692558246992E-22  -4.35345315089542E-10  -4.53936937411349E-10  -3.03078819148821E-18
      7.08025128236835E-09
      0.00000000000000E+00   8.26602634867741E-14   0.00000000000000E+00   8.02991847179282E-14  -4.81224429976869E-23
     -8.27576979492654E-11  -8.26773987645955E-11  -1.28790181173058E-18  -6.89974535824091E-03  -6.89974535879751E-03
      0.00000000000000E+00   0.00000000000000E+00   5.56602906619352E-10   0.00000000000000E+00   5.56602906619352E-10
      4.32033589844866E-18  -3.26921359914312E-01  -3.26772046051557E-01   0.00000000000000E+00  -2.03464718256864E-11
     -1.46801059398855E-22  -4.53579036028487E-10  -4.73925507854320E-10  -3.03243408671809E-18
      7.08440316518085E-09
      0.00000000000000E+00   8.02723003193784E-14   0.00000000000000E+00   3.63605812005900E-14  -4.81195141669540E-23
     -8.03119561016380E-11  -8.02755955204855E-11  -1.28798126665601E-18  -6.87370478434454E-03  -6.87370478492709E-03
      0.00000000000000E+00   0.00000000000000E+00   5.82556071527798E-10   0.00000000000000E+00   5.82556071527798E-10
      4.32275460298936E-18  -3.28039548450162E-01  -3.27881300344298E-01   0.00000000000000E+00  -2.26644530193602E-11
     -1.46963613452211E-22  -4.79616022987963E-10  -5.02280476007471E-10  -3.03477333633335E-18
      7.09000820697772E-09
      0.00000000000000E+00   7.77924924147752E-14   0.00000000000000E+00   2.97291742306580E-14  -4.81153858681857E-23
     -7.77995923768482E-11  -7.77698632026657E-11  -1.28807532274991E-18  -6.84102354187942E-03  -6.84102354249988E-03
      0.00000000000000E+00   0.00000000000000E+00   6.20463781859584E-10   0.00000000000000E+00   6.20463781859584E-10
      4.32623232842013E-18  -3.29728581106170E-01  -3.29557599315186E-01   0.00000000000000E+00  -2.59793816978558E-11
     -1.47213804909163E-22  -5.16714536959119E-10  -5.42693918657122E-10  -3.03815700567021E-18
      7.09757501340350E-09
      0.00000000000000E+00   7.26491871311537E-14   0.00000000000000E+00   4.15970734280567E-14  -4.81091101404112E-23
     -7.26973492893129E-11  -7.26557522159330E-11  -1.28816526800038E-18  -6.80692273849177E-03  -6.80692273917722E-03
      0.00000000000000E+00   0.00000000000000E+00   6.85445067505861E-10   0.00000000000000E+00   6.85445067505861E-10
      4.33141895856145E-18  -3.32436540767053E-01  -3.32243472922133E-01   0.00000000000000E+00  -3.18197446919317E-11
     -1.47623948012888E-22  -5.80969570597970E-10  -6.12789315290049E-10  -3.04325369056107E-18
      7.10268260774091E-09
      0.00000000000000E+00   6.64037450010418E-14   0.00000000000000E+00   6.90980773063180E-14  -4.81041788020173E-23
     -6.65047205431749E-11  -6.64356224659167E-11  -1.28819503524634E-18  -6.79511796287583E-03  -6.79511796361980E-03
      0.00000000000000E+00   0.00000000000000E+00   7.43960285155746E-10   0.00000000000000E+00   7.43960285155746E-10
      4.33521880590117E-18  -3.34539177144434E-01  -3.34325712031016E-01   0.00000000000000E+00  -3.73941725040803E-11
     -1.47946679457366E-22  -6.40130490185183E-10  -6.77524662689411E-10  -3.04702377065483E-18
      7.10957786009640E-09
      0.00000000000000E+00   5.82295633895720E-14   0.00000000000000E+00   6.94020073785690E-14  -4.80966188063446E-23
     -5.82824637169742E-11  -5.82130617096437E-11  -1.28818022433344E-18  -6.79434551010619E-03  -6.79434551095918E-03
      0.00000000000000E+00   0.00000000000000E+00   8.52989703197457E-10   0.00000000000000E+00   8.52989703197457E-10
      4.34110038516135E-18  -3.38032693601944E-01  -3.37782284017498E-01   0.00000000000000E+00  -4.73644549755848E-11
     -1.48493972676962E-22  -7.47412186512173E-10  -7.94776641487906E-10  -3.05292016082791E-18
      7.11888645077631E-09
      0.00000000000000E+00   5.27188791571204E-14   0.00000000000000E+00   4.05112712353225E-14  -4.80860280509720E-23
     -5.27748608313511E-11  -5.27343495601639E-11  -1.28811275299204E-18  -6.79026932073189E-03  -6.79026932173297E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00108484367684E-09   0.00000000000000E+00   1.00108484367684E-09
      4.35041907420700E-18  -3.43864571007540E-01  -3.43565772549680E-01   0.00000000000000E+00  -6.05648685494267E-11
     -1.49430012880673E-22  -8.87785625567044E-10  -9.48350494116620E-10  -3.06230632121497E-18
      7.13145304819420E-09
      0.00000000000000E+00   5.29025686315354E-14   0.00000000000000E+00   1.03513042871128E-14  -4.80725584427625E-23
     -5.29310423120477E-11  -5.29206910078087E-11  -1.28803103235551E-18  -6.74006200841610E-03  -6.74006200955643E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14033217741684E-09   0.00000000000000E+00   1.14033217741684E-09
      4.36474916960326E-18  -3.53059840278643E-01  -3.52717225813885E-01   0.00000000000000E+00  -7.33856945458893E-11
     -1.50941301368294E-22  -1.01402579186302E-09  -1.08741148640906E-09  -3.07671813724775E-18
      7.14841795470835E-09
      0.00000000000000E+00   5.92398554988548E-14   0.00000000000000E+00  -8.95796068748153E-15  -4.80572052063235E-23
     -5.92487994170090E-11  -5.92577573777446E-11  -1.28804130795433E-18  -6.57154327811939E-03  -6.57154327933425E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21485348812041E-09   0.00000000000000E+00   1.21485348812041E-09
      4.38535904545761E-18  -3.66303622320259E-01  -3.65939524077696E-01   0.00000000000000E+00  -8.16524556633490E-11
     -1.53168760094187E-22  -1.07394327507920E-09  -1.15559573074270E-09  -3.09731773750328E-18
      7.16841795470835E-09
      0.00000000000000E+00   7.16388950218709E-14   0.00000000000000E+00  -2.36553783589560E-14  -4.80444531782926E-23
     -7.15883524225135E-11  -7.16120078009205E-11  -1.28831793308462E-18  -6.21119082976031E-03  -6.21119083098326E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22295560362057E-09   0.00000000000000E+00   1.22295560362057E-09
      4.40981815753002E-18  -3.81762488077943E-01  -3.81399729503989E-01   0.00000000000000E+00  -8.49481390170298E-11
     -1.55836216403635E-22  -1.06639545680241E-09  -1.15134359581960E-09  -3.12150022444541E-18
      7.18841795470835E-09
      0.00000000000000E+00   8.96404635145461E-14   0.00000000000000E+00  -4.10914431986661E-14  -4.80389748514942E-23
     -8.95575482908527E-11  -8.95986397340994E-11  -1.28897027862746E-18  -5.63652307845531E-03  -5.63652307966303E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20772046470278E-09   0.00000000000000E+00   1.20772046470278E-09
      4.43397256682408E-18  -3.96577443112044E-01  -3.96225151910892E-01   0.00000000000000E+00  -8.59871690410637E-11
     -1.58470686099087E-22  -1.03213465592753E-09  -1.11812182496875E-09  -3.14500228819662E-18
      7.20841795470835E-09
      0.00000000000000E+00   1.04060087256128E-13   0.00000000000000E+00  -3.53842883426241E-14  -4.80388530508287E-23
     -1.04044778419833E-10  -1.04080162708224E-10  -1.28992685374347E-18  -4.89411098054193E-03  -4.89411098172450E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18257627617298E-09   0.00000000000000E+00   1.18257627617298E-09
      4.45762409234754E-18  -4.10685088327543E-01  -4.10345282346288E-01   0.00000000000000E+00  -8.61270879732178E-11
     -1.61049668668012E-22  -9.92369025491335E-10  -1.07849611346471E-09  -3.16769723860407E-18
      7.22841795470835E-09
      0.00000000000000E+00   1.05621447788656E-13   0.00000000000000E+00  -4.05409568168102E-15  -4.80388733500832E-23
     -1.05600298886656E-10  -1.05604352982385E-10  -1.29092773503710E-18  -4.14013286917159E-03  -4.14013287031234E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14075323821583E-09   0.00000000000000E+00   1.14075323821583E-09
      4.48043915711185E-18  -4.24162834972762E-01  -4.23836686901076E-01   0.00000000000000E+00  -8.54714187316662E-11
     -1.63555285764274E-22  -9.49677466501528E-10  -1.03514888523336E-09  -3.18951142207476E-18
      7.24841795470835E-09
      0.00000000000000E+00   9.27631845796020E-14   0.00000000000000E+00   3.34367834277809E-14  -4.80338892083037E-23
     -9.27634935977990E-11  -9.27300568144193E-11  -1.29168492674981E-18  -3.54608509817613E-03  -3.54608509925734E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08120810721629E-09   0.00000000000000E+00   1.08120810721629E-09
      4.50206331925618E-18  -4.37107919197685E-01  -4.36796476368465E-01   0.00000000000000E+00  -8.39773444623881E-11
     -1.65969149709694E-22  -9.04500705939309E-10  -9.88478050401863E-10  -3.21037839250637E-18
      7.26841795470835E-09
      0.00000000000000E+00   3.20538132854268E-14   0.00000000000000E+00   1.61315843897390E-13  -4.80051031937535E-23
     -3.22520236022637E-11  -3.20907077584143E-11  -1.29124558539091E-18  -3.68442267745695E-03  -3.68442267840655E-03
      0.00000000000000E+00   0.00000000000000E+00   9.49605730822325E-10   0.00000000000000E+00   9.49605730822325E-10
      4.52105543387262E-18  -4.49651566887793E-01  -4.49362483762375E-01   0.00000000000000E+00  -7.90365099654833E-11
     -1.68199778486957E-22  -8.38478513098361E-10  -9.17515023064013E-10  -3.22980984848171E-18
      7.28841795470835E-09
      0.00000000000000E+00  -4.32405022773036E-13   0.00000000000000E+00   1.23368387549989E-12  -4.77888814088884E-23
      4.31180894452752E-10   4.32414578328204E-10  -1.28155954080012E-18  -9.38554988599876E-03  -9.38554988617323E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74469512786272E-10   0.00000000000000E+00   1.74469512786272E-10
      4.52454482412835E-18  -4.62396343842349E-01  -4.62205139243605E-01   0.00000000000000E+00  -4.35052042795068E-11
     -1.69400481113739E-22  -5.63378886834779E-10  -6.06884091114456E-10  -3.24298528332823E-18
      7.30841795470835E-09
      0.00000000000000E+00  -1.33891257901133E-12   0.00000000000000E+00   2.46268364099333E-12  -4.72329881415071E-23
      1.33642001978628E-09   1.33888270342722E-09  -1.25388741359285E-18  -2.56476596658992E-02  -2.56476596646025E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.29669905772002E-09   0.00000000000000E+00  -1.29669905772002E-09
      4.49861084297395E-18  -4.75855630754201E-01  -4.75842362182308E-01   0.00000000000000E+00   2.52605419109116E-11
     -1.68660114359343E-22  -6.74441876179736E-11  -4.21836457072306E-11  -3.24472342938110E-18
      7.32841795470835E-09
      0.00000000000000E+00  -2.05667920028815E-12   0.00000000000000E+00   2.07810189921813E-12  -4.64558731431577E-23
      2.05461712290544E-09   2.05669522480461E-09  -1.21226499486416E-18  -4.94989932069428E-02  -4.94989932045134E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.42931842671791E-09   0.00000000000000E+00  -2.42931842671791E-09
      4.45002447443959E-18  -4.89574393142841E-01  -4.89691830327876E-01   0.00000000000000E+00   7.46813909377729E-11
     -1.66507339832987E-22   2.97941810975833E-10   3.72623201913440E-10  -3.23775947957544E-18
}
